/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: GETDTA.C $
   $Locker:  $	$Name:  $	$State: Exp $

	byte far *getdta(void)

	Get the current used DTA (DOS Transfer Area). This area is used when
	communicating with DOS 1 FCB-style functions. There is exactly one
	DTA active at one time. All processes uses the same DTA unless
	changed manually. The DTA must be 128 bytes in size.

	Input:
		dta != NULL

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		setdta, findfirst

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 12:27:30  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GETDTA.C 1.1 1997/10/27 12:27:30 ska Exp $";
#endif

_CLibFunc byte far *
getdta(void)
{	struct REGPACK r;

	r.r_ax = 0x2F00;
	_callDOS(&r);
	return MK_FP(r.r_es, r.r_bx);
}
