/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FDOALL.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int fflushall(void)
	int fcloseall(void)

	Flushes or closes all open streams. The standard streams (stdin,
	stdout, stderr, stdprn,& stdaux) are only flushed, but never closed.

	If any TTY is opened via fopen(), it is treated like any other
	stream and is closed via fcloseall().


	Input:
		<none>

	Return:
		EOF: if there was any error
		else: the number of closed or flushed streams excl. standard streams

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		fclose, fflush

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.1  1997/11/26 04:03:45  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FDOALL.C 1.1 1997/11/26 04:03:45 ska Exp $";
#endif

static int 
_fwalk(int (*fct)(FILE*))
{	int cnt, err;
	FILE *fp;

	/* Standard devices are not to be closed */
	fflush(stdout);
	fflush(stderr);
#ifdef FIO_PRN
	fflush(stdprn);
#endif	/* FIO_PRN */
#ifdef FIO_AUX
	fflush(stdaux);
#endif	/* FIO_AUX */

	if((fp = __IO_list) != NULL) do {
		err |= fct(fp) == EOF;
		++cnt;
	} while((fp = fp->next) != NULL);

	return err? EOF: cnt;
}

_CLibFunc int
fcloseall(void)
{	return _fwalk(fclose);	}

_CLibFunc int
fflushall(void)
{	return _fwalk(fflush);	}
