/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FREAD.C $
   $Locker:  $	$Name:  $	$State: Exp $

	size_t fread(void *buf, size_t size, size_t nelm, FILE *fp)

	Read nelm records of the size from the stream.

	Bytes, that do not fill a complete record at the end of file,
	are ignored.

	The caller must assume that the complete buffer (all size * nelm
	bytes) have been modified by this function.

	This function does _not_ translate characters in text mode!

	Input:
		buf != NULL
		fp != NULL; a valid FILE pointer
		size and nelm may be 0

	Return:
		0: on EOF or error
		else: number of completely read records

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		fget, fgetc, fgets

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"
#include <limits.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FREAD.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc size_t
fread(void *buf, size_t size, size_t nelm, FILE *fp)
{
	assert((unsigned long)size * nelm <= SIZE_T_MAX);
	assert(fp != NULL);
	assert(buf != NULL);

	return (nelm *= size) == 0
		? 0				/* prevent division-by-zero trap */
		: fget(buf, nelm, fp) / size;
}
