/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: DIR.H 1.3 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Directory related settings

*/

#ifndef __DIR_H
#define __DIR_H

#include <stddef.h>
#include <limits.h>			/* ANSI compatible settings */

#if 1

#define MAXPATH PATH_MAX
#define MAXFILE NAME_MAX
#define MAXEXT NAME_MAX
#define MAXDRIVE PATH_MAX		/* UNC path uses two components */
#define MAXDIR PATH_MAX

#else

#define MAXDIR 66		/* 64: path; +1: root sign; +1: NUL terminator */
#define MAXDRIVE 3		/* 1: drive letter; +1: ':'; +1: NUL terminator */
#define MAXNAME 9		/* 8: name; +1: NUL terminator */
#define MAXEXT 5		/* 3: name; +1: dot; +1: NUL terminator */
#define MAXPATH (MAXDIR + MAXDRIVE + MAXNAME + MAXEXT - 3)

#endif

/* file attributes for Borland C */
#define FA_NORMAL   0x00        /* no special */
#define FA_RDONLY   0x01        /* Read only */
#define FA_HIDDEN   0x02        /* Hidden */
#define FA_SYSTEM   0x04        /* System */
#define FA_LABEL    0x08        /* Volume */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */
#define FA_ALL		0x3F

/* file attributes for MSC */
#define _A_NORMAL   FA_NORMAL
#define _A_RDONLY   FA_RDONLY
#define _A_HIDDEN   FA_HIDDEN
#define _A_SYSTEM   FA_SYSTEM
#define _A_VOLID    FA_LABEL
#define _A_SUBDIR   FA_DIREC
#define _A_ARCH     FA_ARCH

/* findfirst()/findnext() block for Borland C */
#define find_t ffblk		/* MSC's block structure is the same */
#define _find_t ffblk
#include <_ffblk.inc>

#ifndef LFN_WIN95
#define _fexpand fullpath
#endif

#include "..\dir\dirproto"		/**EXPAND**/

#endif
