/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: DIRENT.H 1.1 1997/10/27 12:27:31 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Declarations of struct dirent and *dir() related functions.

*/

#ifndef __DIRENT_H
#define __DIRENT_H

#include <dir.h>
#include <fcntl.h>
#include <_ffblk.inc>		/* source in the real ffblk structure */

/********	Declaration of struct dirent ***********/

/* dirent is equal to ffblk, except for its name and the member:
	ff_name -> d_name
	This mapping is performed by the preprocessor. */
#ifdef ffblk
#undef ffblk
#endif
#ifdef ff_name
#undef ff_name
#endif
#undef ___FFBLK_INC			/* ensure that the file is included */

#define ffblk dirent		/* name mappings */
#define ff_name d_name

#include <_ffblk.inc>

#undef ffblk
#undef ff_name


/****************	Declaration of DIR	******************/
typedef struct {
	short	dd_stat;		/* status return from last lookup */
	boolean	dd_filled;		/* dd_dta already filled? */
	struct ffblk dd_dta; 	/* disk transfer area for this dir */
	char	dd_dir[1];		/* fully-qualifed name of directory
								incl the search pattern */
   		/* this member is dynamically extended that the name fits in there.
   			Note: The DTA, which is active during the findfirst/findnext
   			calls, is probably smaller than the "normal" size of 128 bytes.
   			This should not cause any problems, as I see more than one
   			implementations assuming this, that causes no crash.
   		*/
} DIR;


/***************	Parameters of the DIR* functions **********/
#define _DIR_PATTERN 	"\\*.*"		/* search pattern incl leading '\\' */
#define _DIR_ATTRIB		FA_ALL		/* standard search attributes */

#include "..\dir\entproto"		/**EXPAND**/

#endif
