/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: STDARG.H 1.2 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	va_start(va_list ap, lastfix)
	va_arg(va_list ap, type)
	va_end(va_list)

	ANSI compatible variable argument handling.

*/

#ifndef __STDARG_H
#define __STDARG_H

#include <stddef.h>

typedef byte *va_list;		/* compatible to sizeof() */
				/* Unless we don't provide an option for DS != SS (==
					stack and data segments differ from each other)
					we can assume a native pointer - 1997/11/12 ska*/

/*
 *	According to ANSI variable arguments are promoted, as far as I know:
 *		(char) -> (int)
 *		(short) -> (int)
 *		(float) -> (double)
 *
 *	Because this library is not accompanied by a compiler we must assume
 *	that these rules are applied.
 *	On the other hand, the user is not to pass invalid types, e.g. (char)
 *	or (float), to the va_arg() macro, otherwise he must accept "undefined"
 *	behaviour.
 *
 *	That's why the macro to generate the size of a type is to be placed
 *	into the CORE (compiler depended) section.
 *		int __va_size(type)	:= sizeof(promoted type)
 *	(Also the other macros are compiler-depended.)
 */
#include "../core/_stdarg.inc"

#endif
