/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: VALUES.H $
   $Locker:  $	$Name:  $	$State: Exp $

	System V compatible limits.

*/

#ifndef __VALUES_H
#define __VALUES_H

#include <limits.h>

#define BITSPERBYTE CHAR_BIT
#define MAXSHORT    SHRT_MAX

#define MAXINT      INT_MAX
#define HIBITS      (SHRT_MAX + 1)
#define HIBITI      (INT_MAX + 1)

#define MAXLONG     LONG_MAX
#define HIBITL      (LONG_MAX + 1)

#if 0 		/* from Borland's values.h */
#define DMAXEXP     308
#define FMAXEXP     38
#define DMINEXP     -307
#define FMINEXP     -37

#define MAXDOUBLE   1.7976931348623158E+308
#define MAXFLOAT    3.40282347E+38F
#define MINDOUBLE   2.2250738585072014E-308
#define MINFLOAT    1.17549435E-38F
#define MAXLDOUBLE  1.1897314953572317649E+4932L
#define MINLDOUBLE  3.362103143112094E-4917L /* This isn't accurate, but it */
                                             /* will do for now. The real   */
                                             /* value should be:            */
                                             /* 3.362103143112094E-4932L    */

#define DSIGNIF     53
#define FSIGNIF     24

#define DMAXPOWTWO  0x3FF
#define FMAXPOWTWO  0x7F
#define DEXPLEN     11
#define FEXPLEN     8
#define EXPBASE     2
#define IEEE        1
#define LENBASE     1
#define HIDDENBIT   1
#define LN_MAXDOUBLE    7.0978E+2
#define LN_MINDOUBLE    -7.0840E+2
#endif

#endif  /* __VALUES_H */
