/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _DEFS.H $
   $Locker:  $	$Name:  $	$State: Exp $

	Definitions for making the CLib

	Target compilers:
		Any C compiler

*/

#ifndef ___DEFS_H
#define ___DEFS_H

/*
 *	Definitions depending on the memory model
 *	_NEARDATA: wether or not data pointers are "near"
 *	_FARDATA: wether or not data pointers are "far"
 *	_HUGEDATA: wether or not data pointers are "huge"
 *	_*CODE: dito for the code pointers
 */

#ifdef _FARDATA
#undef _FARDATA
#endif
#ifdef _HUGEDATA
#undef _HUGEDATA
#endif
#ifdef _NEARDATA
#undef _NEARDATA
#endif
#ifdef _FARCODE
#undef _FARCODE
#endif
#ifdef _HUGECODE
#undef _HUGECODE
#endif
#ifdef _NEARCODE
#undef _NEARCODE
#endif

#ifdef ___MMODEL
#undef ___MMODEL
#endif

#ifdef __TINY__
#define ___MMODEL
#define _NEARDATA
#define _NEARCODE
#endif

#ifdef __SMALL__
#define ___MMODEL
#define _NEARDATA
#define _NEARCODE
#endif

#ifdef __MEDIUM__
#define ___MMODEL
#define _NEARDATA
#define _FARCODE
#endif

#ifdef __COMPACT__
#define ___MMODEL
#define _FARDATA
#define _NEARCODE
#endif

#ifdef __FAR__
#define ___MMODEL
#define _FARDATA
#define _FARCODE
#endif

#ifdef __HUGE__
#define ___MMODEL
#define _HUGEDATA
#define _HUGECODE
#endif

#ifndef ___MMODEL
#error "No macro to identify the current memory model found!"
#endif

#endif
