/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FILELENG.C $
   $Locker:  $	$Name:  $	$State: Exp $

	long filelength(int fd)

	Return the length of the file.

	Input:
		<none>

	Return:
		-1 on failure
		else: length of the file.

	Note:
		<none>

	Conforms to:
		DOS

	See also:
		tell, lseek, open

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:06:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FILELENG.C 1.1 1997/10/13 07:06:59 ska Exp $";
#endif

_CLibFunc long
filelength(const int fd)
{	off_t curpos, length;

	if((curpos = tell(fd)) == _SEEK_FAIL)
		return _SEEK_FAIL;

	length = lseek(fd, (off_t)0, SEEK_END);		/* saves error if any */

	return lseek(fd, curpos, SEEK_SET) == _SEEK_FAIL? _SEEK_FAIL: length;
}
