/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LOCKING.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int locking(int fd, int cmd, long length)

	Lock/unlock a region of the file of length bytes beginning at the
	current filepointer. Under DOS SHARE must be loaded to have
	a locking mechanism on local drives.

	Input:
		length > 0

	Return:
		-1: on failure
		0: on success
		1: already locked

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		lock, unlock, _locking, _lockRetryCount, _lockDelay

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 03:53:28  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LOCKING.C 1.2 1997/10/27 03:53:28 ska Exp $";
#endif

_CLibFunc int
locking(const int fd
       ,const int cmd
       ,const long length)
{	REG off_t curpos;

	assert(length > 0);

	return ((curpos = tell(fd)) == _SEEK_FAIL)
		? -1			/* tell() failed -> lock must fail, too */
		: _locking(fd, cmd, curpos, length);
}
