/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _TOCHAR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int __tochar(int ch)

	Is equal to _tochar() free of side-effects.
	_tochar() returns the digit of the supplied number. ch may
	range from 0..35, where _tochar() returns:
		0 -> '0', 1 -> '1', ..., 9 -> '9',
		10 -> 'A', 11 -> 'B', ..., 35 -> 'Z'

	Input:
		0 <= ch <= 35

	Return:
		character to represent the digit

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_todigit

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:56  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <ctype.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _TOCHAR.C 1.1 1997/11/18 04:24:56 ska Exp $";
#endif

_CLibFunc int
__tochar(int ch)
{	assert(0 <= ch && ch <= 35);

	return ch < 10? ch + '0': ch + 'A';
}
