#!perl -i.bak

# Create update the Makefiles

# command line options:
#	-s				subdirectory match (instead of filenames dirnames)
#	-u				to uppercase matched filenames
#	-l				to lowercase matched filenames
#	-f<Makefile>	sets the name of the Makefile
#	any other argument is interpreted as a file to append to SRC

# If a variable SRC ist defined within the Makefile, its value is updated
#	and the variable OBJ is written in the next lines.
# Any former definition of OBJ is removed.

# Multiple empty lines are compressed into a single one.

# All files that are included within SRC are transformed into object
# filenames and will overwrite OBJS. The contents of OBJS is splitted into
# lines that do not exceed 65 characters; that leaves approx. 65 characters
# for the command to passed to the DOS command line. (Note: The name
# of the command processor and the "/c" switch do count for the command
# line.)

# Those splitted OBJS variables are named:
# OBJS_1, OBJS_2, ..., OBJS_9, OBJS_A, OBJS_B, ..., OBJS_Z, OBJS_10, ...
# These definitions are written behind the OBJ line, the components are
# delimited by a single space.
# Any former definition of OBJS_* is removed.

# Any line that starts with a whitespace and contains any token OBJS_1
# is interpreted as a template and is repeated for all OBJS_*'s.
# Any former definition of such lines except the one with OBJS_1 are
# removed.

# For proper functioning of this script a Makefile must look like this:
#	# Makefile start
#	... any stuff but no target definitions ...
#	SRC=
#	... any stuff ...
#
# At the moment the SRC= line is matched (regardless if there is a value
# of SRC or not) all the OBJS_* variables are generated and the script
# can properly generate the $(OBJS_*) replacements

$[ = 0;

$makefile = 'Makefile';		# default Makefile name
$newfile = 'Makefile.new';	# temporary Makefile
$backup = 'Makefile.old';	# backup Makefile
$cmdline = 65;				# maximal size of the OBJS_* values

$objs = 0;					# number of unique OBJS_* variables
$lower = 0;					# lowercase filenames?
$upper = 0;					# uppercase filenames?
$subdirs = 0;				# dirnames instead of filenames?

@nums = ('0'..'9', 'A'..'Z');
$numBase = $#nums + 1;

sub printLine {
	local($line) = @_;
	local($l);

	if($line =~ /^\s*$/) {		# empty
		$emptyLine = 1;
		return;
	}

	if($emptyLine) {
		print OUT "\n";
		$emptyLine = 0;
	}

	$l = "";
	while(length($line) > 70) {
		$l = substr($line, 0, 70);
		if($l =~ /\s(\S*)$/) {		# break line on whitespace
			print OUT $`;
			$line = $1 . substr($line, 70);
		} else {					# no whitespace found -> dump to the next
			if($line =~ /\s/) {
				print OUT $`;
				$line = $`;
			} else {
				print OUT "$line\n";	# no place to break the line
				return;
			}
		}
		print OUT " \\\n\t";
	}
	print OUT "$line\n";
}

sub genNumber {			# generate OBJS_* numbers from natural, positive number
	local($num) = @_;
	local($val);

	$val = '';
	LOOP: {
		$val = $nums[$num % $numBase] . $val;
		redo LOOP if ($num = int($num / $numBase));
	}

	$val = "0$val" unless $val =~ /^[0-9]/;

	return $val;
}

GETOPT: {
	if($ARGV[0] =~ /^-f/) {
		$makefile = $';
	} elsif($ARGV[0] eq '-l') {
		$lower = 1;
		$upper = 0;
	} elsif($ARGV[0] eq '-u') {
		$lower = 0;
		$upper = 1;
	} elsif($ARGV[0] eq '-s') {
		$subdirs = 1;
	} else {
		last GETOPT;
	}
	shift;
	redo GETOPT;
}

die "Cannot open Makefile $makefile " unless open(MK, $makefile);
die "Cannot create new temporary Makefile $newfile " unless open(OUT, ">$newfile");

$all = $subdirs? 'SUBDIRS' : 'OBJS';
$part = $all . '_';

while(<MK>) {
	chop;

	# Aquire concated lines
	while(/\\$/ && ($h = <MK>)) {
		chop($h);
		$_ = $` . $h;
	}

	# Check for a variable definition that is related to this script
	if(/^([A-Za-z0-9_]+)\s*([!\*:]*=)\s*/) {	# Variable found
		$name = $1;
		$assign = $2;
		$value = $';
		# We have to ignore any definition of OBJ and OBJS_*
		next if $name eq $all || $name =~ /^${part}[0-9]/;
		if($name eq 'SRC') {	# this triggers our replacer
			# First we join the values of the variable with the
			# command line arguments and make sure that no filename
			# is more than once included
			%items = ();
			foreach $file (split(/\s+/, $value . " @ARGV")) {
				next if $file =~ /^\s*$/;
				$file =~ tr/a-z/A-Z/ if $upper;
				$file =~ tr/A-Z/a-z/ if $lower;
				(!$subdirs && !-f $file) && (print STDERR "$0: $file: no such file\n", next);
				($subdirs && !-d $file) && (print STDERR "$0: $file: no such directory\n", next);
				$items{$file} = 1;
			}
			@files = sort keys %items;
			%items = ();

			# First, dump the SRC line
			&printLine("SRC=" . join(' ', @files));

			# Now we generate the OBJ file list and dump OBJS
			if(!$subdirs) {
				foreach $idx (0..$#files) {
					$files[$idx] =~ s/[^\.]+$/obj/ unless $upper;
					$files[$idx] =~ s/[^\.]+$/OBJ/ if $upper;
				}
			}
			&printLine("$all=" . join(' ', @files));

			# Now we generate the OBJS_* lines
			$objs = 0;		# Number of OBJS_* definitions
			$line = '';
			foreach $file (@files) {
				($line .= " $file", next) if length($line) + length($file) <= $cmdline;
				die "Filename too long: $file " if length($file) >= $cmdline;

				print OUT $part . &genNumber(++$objs) . "=" . substr($line,1) . "\n";
				$line = " $file";
			}
			print OUT $part . &genNumber(++$objs) . "=" . substr($line,1) . "\n" if $line;
			next;
		}

		# Else we fall through and emit this line (nearly) unchanged
	} elsif(/^\s/) {		# recipient line -> check for templates
		if(/\$\($part([A-Z0-9]+)\)/) {	# template line found
			$num = $1;
			# all except $(OBJS_1) can be ignored
			next unless $num eq '1';
			# OBJS_1 is to be considered a template
			&printLine($_);
			foreach $num (2..$objs) {
				$onum = &genNumber($num);
				$line = $_;
				$line =~ s/\(${part}1\)/\($part$onum\)/g;
				&printLine($line);
			}
			next;
		}
	} elsif(/^library:/) {		# library target; if no source file
		# exist, we put a dummy rule here!
		$value = <MK>;		# Also zap the next line
		$value = $';
		if($#files >= $[) {		# non-empty library
			if($value =~ /^\s*$/) {
				&printLine("library: \$($all) \$(LIBNAME).lib");
			} else {
				&printLine("library: $value");
			}
			&printLine("\t-echo Library \$(LIBNAME).lib successfully created");
		} else {				# empty library
			&printLine('library: ');
			&printLine("\t-echo No source file(s) present in \$(LIBNAME)");
		}
		$_ = '';		# simulate an empty line
	}

	# we arrive here, if we did not replaced the line
	&printLine($_);
}
close MK;
close OUT;

unlink $backup;
rename($makefile, $backup) || die "Cannot create backup of $makefile";
rename($newfile, $makefile) || die "Cannot rename new Makefile $newfile into $makefile";
