/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: MEMMOVE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void *memmove(void *dst, void *src, size_t length)

	Copy length bytes from src to dst. This function honors if
	both memory area overlap themselves.

	Input:
		dst != NULL
		src != NULL

	Return:
		dst

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		memcpy, strcpy

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MEMMOVE.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

/*	There is already the memcpy() function.
	It handles copying perfectly for non-overlapped areas.
	Also, when dst < src the bytes of src are never overwritten.

	That leaves only the case in which both areas overlap themselves
	and src < dst, in which case the first copied byte will overwrite
	a byte that should have been copied later. That means we simply
	copy from the end to the beginning.
*/
_CLibFunc void ___PTR *memmove(REG void ___PTR *dst
 , void const ___PTR * src, size_t length)
{	 
	assert(dst != NULL);
	assert(src != NULL);

	if(dst != src && length) {

		if(!(src < dst && (byte ___PTR *)src + length >= dst))
			return memcpy(dst, src, length);

		(byte ___PTR *)src += length;
		(byte ___PTR *)dst += length;
		do *--(byte ___PTR *)dst = *--(byte ___PTR *)src;
		while(--length);
	}

	return dst;
}
