/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRDUP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strdup(char_t *str)

	Duplicates the string into the heap. The allocated memory should be
	free()'ed by the programmer, if the duplicate is no longer required.
	strdup() uses malloc().

	Input:
		str may be NULL

	Return:
		NULL if str == NULL
		NULL if malloc() return NULL, thus no memory is available
		pointer to duplicate, otherwise

	Note:
		To duplicate means that an unique copy is created.

	Conforms to:
		ANSI

	See also:
		malloc, calloc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <alloc.h>
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRDUP.C 1.3 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strdup(char_t const ___PTR * const s)
{	REG char_t ___PTR *p;
	REG size_t length;

	if(s == NULL || (p = (char_t ___PTR*)malloc(length = strlen(s) + 1)) == NULL)
		return NULL;

	return memcpy(p, s, length);
}
