/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STREND.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int strend(char_t *s1, char_t *s2)

	Test if s1 ends with s2.

	Input:
		s1 != NULL
		s2 != NULL

	Return:
		0 if s1 does not end with s2
		else: otherwise

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		strbeg, memcmp

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STREND.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc int strend(char_t const ___PTR * const s1
 , char_t const ___PTR * const s2)
{	REG size_t l1, l2;

	assert(s1 != NULL);
	assert(s2 != NULL);

	l1 = strlen(s1);
	l2 = strlen(s2);

	if(l1 >= l2)
		return !memcmp(s1 + l1 - l2, s2, l2);

	return 0;
}
