/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRPTOC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strptoc(char_t *pstr)

	Transform a PString (Pascal string) into a C string.

	Input:
		pstr != NULL

	Return:
		pstr: on success
		else: pointer to the first string if the PString contains NULs

	Note:
		PStrings conforms to this syntax:
			<length><char1><char2>...<charN>
		all are of the type (byte), <char_t?> may be NUL.

	Conforms to:
		<none>

	See also:
		strplen, strpval, strctop

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRPTOC.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strptoc(char_t ___PTR * const pstr)
{	REG pstr_t length;

	assert(pstr != NULL);

	if(memchr(strpval(pstr), NUL, length = strplen(pstr)))
		return strpval(pstr);	/* NULs within PString */
	
	memmove(pstr, strpval(pstr), length);	/* overwrite length byte */
	pstr[length] = NUL;		/* mark the end of the C string */
	return pstr;
}
