/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _STRNLEN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	size_t _strnlen(char_t *s, size_t length)

	Return min(strlen(s) + 1, length) but don't perform strlen(s) directly
	as this could cause a system hang.

	Input:
		s != NULL

	Return:
		min(strlen(s) + 1, length)

	Note:
		This function is designed for the strn*() functions.

	Conforms to:
		<none>

	See also:
		strlen

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _STRNLEN.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

/*
	Problems:
		a) Imagine a 64KB segment full of ' 's. strchr() would never
		return as it would never find any NUL byte.
		b) Imagine _strnlen("12", 4)
			to do:
				c = s[length];
				s[length] = NUL;
				end = _strstop(s);
				s[length] = c;

			would mean to modify _behind_ the string itself, thus, if the
			will of ... made it so that a volatile variable has been placed
			there and is asynchronly accessed by an interrupt routine
				-> bang!

	So there seems to be a single solution left.
*/
_CLibFunc size_t _strnlen(char_t const ___PTR * const s, size_t length)
{	REG size_t i;

	/* Note: The increment in s[i++] ensures that i is the length
		_including_ the NUL byte */
	for(i = 0; i < length && s[i++] != NUL;);

	return i;
}
