/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ERRNO.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int errno;

	Preserves the error of the very last operation that failed.
	The variable may be set/cleared any time the programmer wishes
	as it has no actual meaning to the CLib, except for perror().

	Input:
		<none>

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		POSIX

	See also:
		strerror, perror

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 12:27:29  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <errno.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ERRNO.C 1.1 1997/10/27 12:27:29 ska Exp $";
#endif

_CLibVar int errno = EZERO;
