/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: EXIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void exit(int exitcode)

	Terminate process and return the exit code to the parent process.
	This call will perform any necessary steps to terminate the process
	properly, e.g. invoking atexit() functions, flush pending IO buffers,
	free memory.

	Input:
		0 <= exitcode <= 255

	Return:
		will never return

	Note:
		There is no check if the exitcode exceeds the boundary, the
		really returned exit code is (unsigned)(exitcode & 0xFF).

	Conforms to:
		ANSI

	See also:
		atexit, abort, _exit, _cexit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:09:10  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: EXIT.C 1.1 1997/10/13 07:09:10 ska Exp $";
#endif

_CLibFunc void exit(const int exitcode)
{	_cexit();				/* perform high-level cleanup */
	_exit(exitcode);		/* really terminate process */
}
