/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: SLEEP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void sleep(int seconds)

	Delay process execution for seconds. The accuracy depends on the
	computer's timer interrupt and background tasks, that might interfere
	with that timer.

	If seconds == 0, the functions returns immediately. This might be
	changed in the future.

	Input:
		0 <= seconds <= 4200

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		POSIX

	See also:
		delay

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1997/10/27 12:27:29  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#include <process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: SLEEP.C 1.3 1997/10/27 12:27:29 ska Exp $";
#endif

_CLibFunc void
sleep(int seconds)
{	
	if(!seconds) return;

	assert(seconds >= 0 && seconds <= 4200);

	_delay((uint32)seconds * 1000 * 1000);
}
