   /* ---------- STRFNS.C - string-related functions ------- */
/* 

   Copyright (c) 1996 M. M. Peritsky.  All rights reserved.
   This program is part of the Free-DOS Project.
   See COPY.TXT or XCOPY.TXT for more details.

*/
   /* ---------- include files ----------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "copy.h"

   /* ---------- declaration of symbolic constants --------- */

#define TRUE 1
#define FALSE 0

   /* ---------- start test_heap_err function -------------- */

void test_heap_err(void *p)
{
   if (p == NULL) {
      printf("Insufficient heap space.\n");
      main_exit(1);
   }
}

   /* ---------- end test_heap_err function ---------------- */

   /* ---------- start strcat3 function -------------------- */

char *strcat3(char *a, char *b, char *c)
{
   char *p;
   p = malloc( (size_t) (strlen(a)+strlen(b)+strlen(c)+1) );

   test_heap_err(p);

   strcpy(p,a);
   strcat(p,b);
   strcat(p,c);

   return p;
}

   /* ---------- end strcat3 function ---------------------- */

   /* ---------- start strdup1 function -------------------- */

char *strdup1(char *a)
{
   char *p;
   p = strdup(a);

   test_heap_err(p);

   return p;
}

   /* ---------- end strdup1 function ---------------------- */

   /* ---------- start str_toupper function ---------------- */

char *str_toupper(char *p)
{
   char *q;
   q = p;
   while (*q != '\0') {
      *q = toupper(*q);
      q++;
   }
   return p;
}
   /* ---------- end str_toupper function ------------------ */

   /* ---------- start starts_with_plus function ----------- */

int starts_with_plus(char *p)
{
   return ( (*p) == '+' );
}

   /* ---------- end starts_with_plus function ------------- */

   /* ---------- start ends_with_plus function ------------- */

int ends_with_plus(char *p)
{
   size_t len = strlen(p);
   return (len == 0) ? FALSE : ( *(p+len-1) == '+' );
}

   /* ---------- end ends_with_plus function --------------- */
