/* cls.c */

/* Clears the screen.  No longer will set the colors.  For that, use
   the COLOR program. */

/*
  Copyright (C) 1994-1998 Jim Hall, jhall1@isd.net

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <stdlib.h>				/* for exit() on borland */

#include <conio.h>				/* for conio on borland */

void usage (const char *progname);


int
main (int argc, char **argv)
{
  /* Check command line */

  if (argc > 1)
    {
      usage ("CLS");
      exit (0);
    }

  /* Clear the screen */

  clrscr();					/* borland */

  exit (0);
}

void
usage (const char *progname)
{
  fprintf (stderr, "%s: clear the screen\n", progname);
  fprintf (stderr, "Usage: %s [/?]\n", progname);
}
