/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: MKLIMITS.C 1.1 1998/01/29 07:10:20 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	This program is intented to help to create the values of
	the LIMITS.H file according ISO9899.

	We offer to aquire them by various methods:
		+ via the current compilers settings (HAVE_LIMITS defined)
		+ via the detecting of ranges (HAVE_LIMITS undefined)

	To select between both methods, comment or uncomment the
	#define immediately following this comment header.

	This program is to be compiled using the _compiler's_
	header files and library, DO NOT USE ANY OF THE FILES
	INCLUDED WITHIN THIS LIBRARY!

	While compiling you should see three Warnings:
		1) the useage of function vfct() without prototype,
		2) 2x argument not used in function vfct().
	Those are normal and to be ignored!

	On successful compilation just invoke the program, any passed
	parameters are happily ignored. On successful run, the program
	generates a file called "_local.inc". Copy this file into
	CLib's CONF directory overwriting any existing file.

	File Revision:    Revision 1.1  1998/01/29 07:10:20  ska
*/

//#define HAVE_LIMITS			/* comment out if no LIMITS.H file is available */

#include <stdio.h>		/* IO functions */
#include <stdlib.h>		/* exit() */

#ifdef HAVE_LIMITS
#include <limits.h>
#endif 

FILE *f;			/* _LOCAL.INC file */

char c;
unsigned char uc;
short s;
unsigned us;
long l;
unsigned long ul;
int i;
unsigned int ui;

extern void vfct();				/* Make the compiler believe, that this has
				a fixed-length, but currently unknown argument list */
extern void cfct(char c, int i);

static char buf[128];
char *nega(long min, long max)
{	/* Some compilers do have a problem, if:
			-minimal_negative_number > maximal_positive_number
		This function corrects this.
	*/
	long l;

	if((l = min + max) < 0) {
		/* the minimal number is less than the maximal number */
		sprintf(buf, "-%lu%ld", max, l);
	}
	else {
		/* the minimal number can be savely represanted */
		sprintf(buf, "%ld", min);
	}
	return buf;
}

main(void)
{	
	int cnt;

	puts("Creating file _LOCAL.INC ...");
	if((f = fopen("_local.inc", "wt")) == NULL) {
		puts("Cannot create the file \"_local.inc\"!");
		exit(30);
	}

	puts("Generating LIMITS...");
#ifdef HAVE_LIMITS
	/* Just grab the values from the limits.h */
	fprintf(f, "#define CHAR_BIT\t%d\n", CHAR_BIT);
	fprintf(f, "#define SCHAR_MIN\t(%d)\n", SCHAR_MIN);
	fprintf(f, "#define SCHAR_MAX\t%u\n", SCHAR_MAX);
	fprintf(f, "#define UCHAR_MAX\t%u\n", UCHAR_MAX);
	fprintf(f, "#define SHRT_MIN\t(%s)\n", nega(SHRT_MIN, SHRT_MAX));
	fprintf(f, "#define SHRT_MAX\t%u\n", SHRT_MAX);
	fprintf(f, "#define USHRT_MAX\t%uU\n", us = USHRT_MAX);
	fprintf(f, "#define LONG_MIN\t(%s)\n", nega(LONG_MIN, LONG_MAX));
	fprintf(f, "#define LONG_MAX\t%lu\n", LONG_MAX);
	fprintf(f, "#define ULONG_MAX\t%luUL\n", ULONG_MAX);
	ui = UINT_MAX;
#else
	/* <limits.h> does not exist, we generate the values ourselves! */
	/* 1. CHAR_BIT
		assign "1", then shift it to the left, until the value
		becomes zero. The number of shifts is the number of bits per
		sizeof(char)==1 object. */

	for(cnt = uc = 1; uc <<= 1; ++cnt);
	fprintf(f, "#define CHAR_BIT\t%d\n", cnt);

	/* 2. CHAR_MIN we start at -127 (maximal minimum) and count
		until the result becomes larger */
	c = -127;
	while(c > (char)(c-1)) --c;
	fprintf(f, "#define SCHAR_MIN\t(%d)\n", c);

	/* 3. CHAR_MAX we start at +127 (minimal maximum) and count
		until the result becomes smaller */
	c = 127;
	while(c < (char)(c+1)) ++c;
	fprintf(f, "#define SCHAR_MAX\t%u\n", c);

	/* 4. UCHAR_MAX we start at +255 (minimal maximum) and count
		until the result becomes smaller */
	uc = 255;
	while(uc < (unsigned char)(uc+1)) ++uc;
	fprintf(f, "#define UCHAR_MAX\t%u\n", uc);

	/* 5. SHRT_MAX we start at +32767 (minimal maximum) and count
		until the result becomes smaller */
	s = 32767;
	while(s < (short)(s+1)) ++s;
	fprintf(f, "#define SHRT_MAX\t%u\n", s);
	us = s;

	/* 6. SHRT_MIN we start at -32767 (maximal minimum) and count
		until the result becomes larger */
	s = -32767;
	while(s > (short)(s-1)) --s;
	fprintf(f, "#define SHRT_MIN\t(%s)\n", nega(s, us));

	/* 7. USHRT_MAX we start at +65535 (minimal maximum) and count
		until the result becomes smaller */
	us = 65535;
	while(us < (unsigned short)(us+1)) ++us;
	fprintf(f, "#define USHRT_MAX\t%uU\n", us);

	/* 8. LONG_MAX we start at +2147483647L (minimal maximum) and count
		until the result becomes smaller */
	l = 2147483647L;
	while(l < (long)(l+1)) ++l;
	fprintf(f, "#define LONG_MAX\t%lu\n", l);
	ul = l;

	/* 9. LONG_MIN we start at -2147483647 (maximal minimum) and count
		until the result becomes larger */
	l = -2147483647L;
	while(l > (long)(l-1)) --l;
	fprintf(f, "#define LONG_MIN\t(%s)\n", nega(l, (long)ul));

	/* 10. ULONG_MAX we start at +4294967295 (minimal maximum) and count
		until the result becomes smaller */
	ul = 4294967295UL;
	while(ul < (unsigned long)(ul+1)) ++ul;
	fprintf(f, "#define ULONG_MAX\t%luUL\n", ul);

	/* 11. Generate UINT_MAX for later use, treat as short, as this
		is the minimal maximum. */
	ui = 65535;
	while(ui < (ui+1)) ++ui;

#endif 

	if(ui == us) {
		fputs("#define INT_MIN\tSHRT_MIN\n", f);
		fputs("#define INT_MAX\tSHRT_MAX\n", f);
		fputs("#define UINT_MAX\tUSHRT_MAX\n", f);
	}
	else {
		fputs("#define INT_MIN\tLONG_MIN\n", f);
		fputs("#define INT_MAX\tLONG_MAX\n", f);
		fputs("#define UINT_MAX\tULONG_MAX\n", f);
	}

	puts("Generating variable argument list options...");
	vfct((int)1, (int)2);
	cfct((char)' ', (int)1);

	fflush(f);
	if(ferror(f)) {
		puts("Write failure");
		exit(31);
	}
	fclose(f);
	puts("File _LOCAL.INC successfully created!");
	return 0;
}

void vfct(int arg1, int arg2, int arg3)
{
	fputs((arg2 != 2)? "#define _STDARG_LEFT_TO_RIGHT\n"
	 : "#define _STDARG_RIGHT_TO_LEFT\n", f);
}

void cfct(char c, int i)
{
	if((char*)&i - &c != sizeof(int))
		fputs("#define _STDARG_NO_PROMOTE_CHAR 1\n", f);
}
