/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: INTR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void intr(int intnr, struct REGPACK *rp)

	Performs Intel 80x86 software interrupt #intnr.
	The initial register values are read from *rp, upon exit of the
	interrupt the registers are saved back into *rp.

	The interrupt may change all real mode registers (AX, BX, CX, DX, DI,
	SI, DS, ES, CS, SS, flags) and the topmost four (4) words of the stack.

	The interrupt is called with the lobyte of flags only.

	Input:
		intnr & 0xFF: Number of interrupt to invoke
		special meaning of intnr & 0xFF00:
			== 0x0000: none
			== 0xFF00: none
		
		rp must be != NULL

	Return:
		none

	Note:
		wrapper of _intr()

	Conforms to:
		DOS

	See also:
		_intr(), struct REGPACK, intdos(), intdosx()
		_callDOS()

	Target compilers:
		any


	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/01/29 07:09:32  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: INTR.C 1.2 1998/01/29 07:09:32 ska Exp $";
#endif

#ifndef _FARDATA
_CLibFunc void intr(int intnr, struct REGPACK * const rp)
{	assert(rp != NULL);

	_intr(intnr, (struct REGPACK far * const)rp);
}
#endif
