COMMENT `
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
`
COMMENT `
   $Id: _GETSP.ASM 1.1 1997/10/27 12:27:09 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	void *__getSP(void)

	Returns a pointer to the current position of the stack pointer.
	The size of the return address of the call instruction has been
	added to the stack pointer, so that the return value is valid
	in the caller's stack frame.

	The stack pointer is the upper limit of the local heap.

	Input:
		<none>

	Return:
		stack pointer

	Note:
		<none>

	Conforms to:
		<none>

	See also:

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>


	File Revision:    Revision 1.1  1997/10/27 12:27:09  ska
`

;; Source in the standard definitions
INCLUDE _def.inc

Code_Seg@

DefFunc@	___getSP
	mov ax, sp
IF FCODE			; Remove the current stack frame
	add ax, 4
ELSE		;; FCODE
	add ax, 2
ENDIF		;; FCODE
	ret
___getSP ENDP

Code_End@

END
