/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FPUTS.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int fputs(char *str, FILE *fp)

	Write a string into a stream.

	Input:
		str != NULL
		fp != NULL; a valid FILE pointer

	Return:
		EOF: on failure
		>=0: on success

	Note:
		fputs() returns the number of written characters (non-standard).

	Conforms to:
		ANSI

	See also:
		fputc, fgets, fwrite

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FPUTS.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc int
fputs(const char *str, FILE *fp)
{
   REG int n = 0, ch;

	assert(str != NULL);
	assert(fp != NULL);

   while ((ch = *str++) != '\0') {
      if (putc(ch, fp) == EOF)
		 return EOF;
      ++n;
   }
   return n;
}
