/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: PUTS.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int puts(char *str)

	Write a string into the stdandard output stream and append a
	newline character '\n'.

	Input:
		str != NULL

	Return:
		EOF: on failure
		>=0: on success

	Note:
		puts() returns the number of written characters (non-standard).

	Conforms to:
		ANSI

	See also:
		fputs, fputc, fwrite

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: PUTS.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc int
puts(const char *str)
{	REG int n;

	assert(str != NULL);

	if (((n = fputs(str, stdout)) == EOF)
	 || (putc('\n', stdout) == EOF))
		return EOF;

	return n + 1;
}
