/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LFREE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int free(void *poi)

	deallocate an object allocted via malloc() or an equivalent.
	If poi == NULL, the function returns "success" but performs no action.

	If DEBUG_HEAP was defined at compile time, freed memory is filled
	with dbgHeapFreeCh.

	Input:
		<none>

	Return:
		0: success
		else: failure

	Note:
		Local heap only

	Conforms to:
		ANSI; except the return value: (void) normally

	See also:
		malloc, realloc, calloc, _fmalloc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.5  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>
#ifdef DEBUG_HEAP
#include <string.h>
#endif 

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LFREE.C 1.5 1998/02/11 07:40:34 ska Exp ska $";
#endif

_CLibFunc int 
free(void ___PTR * const poi)
{	REG _pHeapNode thisNode;
	_pHeapNode prevNode;

	if(!poi)
		return HEAP_OK;

	assert(_heap);

	if((thisNode = _heapfind(poi, &prevNode)) == NULL)
		return HEAP_NOTFOUND;

	/* join previous & following unused nodes */
	thisNode = _heapfree(thisNode, prevNode);

#ifdef DEBUG_HEAP		/* zap this node's data area */
	/* Note: thisNode always points to a valid & initialized node,
		regardless if the type is HEAP_UNUSED or HEAP_END actually. */
	if(dbgHeapFreeCh)
		memset(nodeData(thisNode), dbgHeapFreeCh, nodeLength(thisNode));
#endif
#if _IN_ALLOC == 2		/* huge interface */
	/* The huge _heapfree() does not shrink the fragment if possible;
		do it now */
	if(thisNode->type == HEAP_END)
		_frgcompact(thisNode);
#endif 
	
	return HEAP_OK;
}
