/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: DOS.H 1.3 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	DOS semi-standard header file.

*/

#ifndef __DOS_H
#define __DOS_H

#include <stddef.h>

/* far memory <-> segment/offset */
#define MK_FP(segm,ofs) ((void far*)(((unsigned long)(word)(segm) << 16) | (word)(ofs)))
#define FP_SEG(addr) ((word)((unsigned long)((void far*)(addr)) >> 16))
#define FP_OFF(addr) ((word)(unsigned long)(void far*)(addr))

/* Interrupt numbers */
#define INT_VIDEO 0x10		/* BIOS video interface */
#define INT_DISK 0x13		/* BIOS disk interface */
#define INT_SERIAL 0x14		/* BIOD serial port interface */
#define INT_KEYBOARD 0x16	/* BIOS keyboard interface */
#define INT_PRINTER 0x17	/* BIOS parallel port/printer interface */
#define INT_TIME 0x1A		/* BIOS (real) time(r) interface */
#define INT_CLOCK 0x1C		/* System clock timer tick */
#define INT_DOS 0x21		/* DOS API */
#define INT_CBREAK 0x23		/* Control break handler */
#define INT_CRITERR 0x24	/* Critical error handler */
#define INT_ABSREAD 0x25	/* Absolut disk read */
#define INT_ABSWRITE 0x26	/* Absolut disk write */
#define INT_KEEP 0x27		/* Keep & stay resident */
#define INT_DOSIDLE 0x28	/* DOS idle interrupt */
#define INT_FASTPUT 0x29	/* Fast console output */
#define INT_AMIS 0x2D		/* Alternat multiplex interrupt service */
#define INT_SHELL 0x2E		/* Backdoor to shell (COMMAND.COM) */
#define INT_MUX 0x2F		/* Multiplex interrupt */

/* bits in the flag register */
#define FLAG_CARRY		0x0001
#define FLAG_PARITY		0x0004
#define FLAG_AUXCARRY	0x0010
#define FLAG_ZERO		0x0040
#define FLAG_SIGN		0x0080
#define FLAG_TRAP		0x0100
#define FLAG_INTERRUPT	0x0200
#define FLAG_DIRECTION	0x0400
#define FLAG_OVERFLOW	0x0800
#define FLAG_PRIVILEGE	0x3000
#define FLAG_NESTEDTASK	0x4000


struct  dfree
{
    unsigned df_avail;
    unsigned df_total;
    unsigned df_bsec;
    unsigned df_sclus;
};

struct diskfree_t
{
    unsigned total_clusters;
    unsigned avail_clusters;
    unsigned sectors_per_cluster;
    unsigned bytes_per_sector;
};

struct time
{
    byte   ti_min;     /* Minutes */
    byte   ti_hour;    /* Hours */
    byte   ti_hund;    /* Hundredths of seconds */
    byte   ti_sec;     /* Seconds */
};

struct dostime_t
{
    byte hour;         /* Hours */
    byte minute;       /* Minutes */
    byte second;       /* Seconds */
    byte hsecond;      /* Hundredths of seconds */
};

struct date
{
    int     da_year;        /* Year - 1980 */
    char    da_day;     /* Day of the month */
    char    da_mon;     /* Month (1 = Jan) */
};

struct dosdate_t
{
    byte day;      /* 1-31 */
    byte month;    /* 1-12 */
    unsigned int  year;     /* 1980 - 2099 */
    byte dayofweek;/* 0 - 6 (0=Sunday) */
};

struct  fcb
{
    char    fcb_drive;      /* 0 = default, 1 = A, 2 = B */
    char    fcb_name[8];    /* File name */
    char    fcb_ext[3];     /* File extension */
    short   fcb_curblk;     /* Current block number */
    short   fcb_recsize;    /* Logical record size in bytes */
    long    fcb_filsize;    /* File size in bytes */
    short   fcb_date;       /* Date file was last written */
    char    fcb_resv[10];   /* Reserved for DOS */
    char    fcb_currec;     /* Current record in block */
    long    fcb_random;     /* Random record number */
};

struct  xfcb
{
    char       xfcb_flag;    /* Contains 0xff to indicate xfcb */
    char       xfcb_resv[5]; /* Reserved for DOS */
    char       xfcb_attr;    /* Search attribute */
    struct fcb xfcb_fcb;     /* The standard fcb */
};

#if defined(__MSC) && !defined(__cplusplus)
struct  DOSERROR
{
        int     exterror;
        char    class;
        char    action;
        char    locus;
};
#else
struct  DOSERROR
{
        int     de_exterror;
        char    de_class;
        char    de_action;
        char    de_locus;
};
#endif  /* __MSC and not C++ */

struct fatinfo
{
    char     fi_sclus;
    char     fi_fatid;
    unsigned fi_nclus;
    int      fi_bysec;
};

struct WORDREGS
{
    uint16 ax; 
    uint16 bx; 
    uint16 cx; 
    uint16 dx; 
    uint16 si; 
    uint16 di; 
    uint16 cflag;
    uint16 flags;
};

struct BYTEREGS
{
    byte al;
    byte ah; 
    byte bl;
    byte bh; 
    byte cl;
    byte ch; 
    byte dl;
    byte dh;
};

union REGS
{
    struct  WORDREGS  x;
    struct  WORDREGS  w;
    struct  BYTEREGS  h;
};

struct SREGS
{
    uint16 es, cs, ss, ds;
};

struct REGPACK
{
    uint16 r_ax, r_bx, r_cx, r_dx;
    uint16 r_bp, r_si, r_di, r_ds, r_es, r_flags;
};

typedef union {
	struct REGPACK w;
	struct BYTEREGS h;
} DOSREGS;

struct  COUNTRY
{
    short   co_date;
    char    co_curr[5];
    char    co_thsep[2];
    char    co_desep[2];
    char    co_dtsep[2];
    char    co_tmsep[2];
    char    co_currstyle;
    char    co_digits;
    char    co_time;
    long    co_case;
    char    co_dasep[2];
    char    co_fill[10];
};

struct  devhdr
{
    long        dh_next;        /* Next device pointer */
    short       dh_attr;        /* Attributes */
    uint16  dh_strat;   /* Driver strategy routine */
    uint16  dh_inter;   /* Driver interrupt routine */
    char        dh_name[8];     /* Device name */
};

typedef struct
{
    char    ds_drive;          /* do not change    */
    char    ds_pattern [13];   /*  these fields,       */
    char    ds_reserved [7];   /*   Microsoft reserved */
    char    ds_attrib;
    short   ds_time;
    short   ds_date;
    long    ds_size;
    char    ds_nameZ [13];     /* result of the search, asciiz */
}   dosSearchInfo;  /* used with DOS functions 4E, 4F   */

extern void _CLibFunc intr(int intnr, struct REGPACK * const rp);
extern int _CLibFunc _intr(int intnr, struct REGPACK far * const rp);
extern int _CLibFunc _callDOS(struct REGPACK far * const rp);
extern _CLibFunc unsigned __getSP(void);
extern _CLibFunc int _delay(uint32 microseconds);

#include "../dos/prototyp"		/**EXPAND**/
#endif
