/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: STDDEF.H 1.1 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	General purpose macros and types.

*/

#ifndef __STDDEF_H
#define __STDDEF_H

#include <_defs.h>
#include <_config.h>
#include <_null.h>
#include <_wchar_t.h>

/**** Standardize types */
/* size independ types with an "exact" amount of bits */
typedef unsigned char uint8;
typedef unsigned uint16;
typedef unsigned long uint32;
typedef char int8;
typedef int int16;
typedef long int32;

/* DOSish types */
typedef uint8 qword[8];		/* sorry, but no uint64 available */
typedef uint32 dword;
typedef uint16 word;
typedef uint8 byte;

/*	Conversations */
#define LODWORD(q)	(*(uint32*)(q))
#define HIDWORD(q)	(((uint32*)(q))[1])
/* MKQWORD		sorry no integer 64 bit type */
#define HIWORD(l)	((uint16)((uint32)(l) >> 16))
#define LOWORD(l)	((uint16)(l))
#define MKLONG(hi,lo)	(((uint32)(uint16)(hi) << 16) | (uint16)(lo))
#define MKDWORD(hi,lo)	MKLONG(hi,lo)
#define HIBYTE(l)	((uint16)(l) >> 8)
#define LOBYTE(l)	((uint16)(l) & 0xFF)
#define MKWORD(hi,lo)	(((uint16)(uint8)(hi) << 8) | (uint8)(lo))

/*
 * ANSI types
 */
 
/* 'size' of an object, maybe treated signed! */
/* difference of two pointers */
#ifdef _HUGEDATA		/* huge data have no size limit */
#define SIZE_T_MAX ULONG_MAX
typedef unsigned long size_t;
typedef long ptrdiff_t;
#else
#define SIZE_T_MAX UINT_MAX
typedef unsigned size_t;
typedef int ptrdiff_t;
#endif

/* calculates the offset of a member from the beginning of the
	structurre. */
/* Here we make the assumption that the compiler does calcualte
	the address of a normally invalid address, because (structure *)0
	leads to undefined behaviour, as it is a null pointer!

	Reported to work with:
		+ Borland C v5.2

1998-01-27 ska*/
#define offsetof(structure, member)		\
	((size_t)&(  ((structure *)0)->member ))

/* Offset of filepositions */
typedef long off_t;

/* Single Character */
typedef char char_t;
typedef unsigned char uchar_t;

/* at_exit type */
typedef void (*atexit_t)(void);

/* DOS related types */
typedef unsigned long hsize_t;	/* 'size' of huge objects */
typedef long hptrdiff_t;

/**** Future enhancements */
#define _CLibFunc			/* function fromout the CLibrary */
#define _CLibVar			/* variable fromout the CLibrary */

/*********** CLib version strings *********/
extern const char _clib_version[];
extern const char _clib_build[];

#endif
