/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _CONFIG.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Configuration information

*/

#ifndef ___CONFIG_H
#define ___CONFIG_H


/*
 *	For TESTING purpose
 */
#define DEBUG_HEAP				/**COMMENT**//* debug heap support */
//#define NDEBUG				/**COMMENT**//* general debug support */


/*
 *	Compatibilty macros
 */

#define REG register	/* keyword is not strict */


/*
 *	What to compile into CLib
 */

/*	STDIO parameters */
//#define _STDIO_FLOATS		/* support float data types */
			/* Sorry, no float support currently - 1997/11/12 ska*/
#define FIO_PRN		4	/* if to incorporate stdprn,& on which descriptor */
#define FIO_AUX		3	/* if to incorporate stdaux,& on which descriptor */
#define LFN_WIN95		/* support long filename support in win95 style */


/*
 *	Default values
 *	condition in square brackets: assumptions within source or limits due
 *		to some standard
 */

#define MAX_ATEXIT 32	/* atexit slots available for the user [>= 32] */
#define __CHSIZE_BUFFER 128		/* size of block within chsize() [>= 1] */
#define __LOCK_RETRY_COUNT 10	/* retries in "no-block" mode? [>= 1] */
#define __LOCK_DELAY 1			/* sleep between two reties for lock [>= 1] */
#define _ABORT_STD_EXITCODE 3		/* standard exitcode on fatal error */


/*	STDIO parameters */
//#define FIO_NB_STDIN			/* if stdin shall be unbuffered by default */
//#define FIO_NB_STDOUT			/* if stdout shall be unbuffered by default */
#define FIO_NB_STDERR			/* if stderr shall be unbuffered by default */
#define FIO_NB_STDPRN			/* if stdprn shall be unbuffered by default */
#define FIO_NB_STDAUX			/* if stdaux shall be unbuffered by default */


/*
 *	Selection of options of the code
 */

/* HEAP package */

/* Align the data portion of an heap node at an even address; this will
	speed up memory word/dword accesses.
	values:
		0 or undefined: don't align
		any other: address dividable by (2^__HEAP_ALIGN)
	Note: The value __FHEAP_ALIGN is currently ignored for blocks
		larger than (a little less than) 64KB. For such large blocks
		the alignment defaults to 4 (2^4 == 16 bytes == 1 paragraphe).
		This behavior is implementation-depended. */
#define __LHEAP_ALIGN 1					/* alignment of local heap */
#define __FHEAP_ALIGN 1					/* alignment of far heap */

#endif
