/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LSEEK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	off_t lseek(int fd, off_t offset, int whence)

	Set the filepointer of file fd to offset relative to the
	"whence" position.

	whence is a symbolic constant:
		SEEK_SET	from beginning of file
		SEEK_CUR	from current file position
		SEEK_END	form end of file

	Input:
		<none>

	Return:
		-1 on failure
		new position of filepointer on success

	Note:
		<none>

	Conforms to:
		Posix

	See also:
		open, close

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:06:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LSEEK.C 1.1 1997/10/13 07:06:59 ska Exp $";
#endif

_CLibFunc off_t
lseek(const int fd
     ,const off_t offset
     ,const int whence)
{	struct REGPACK r;

	r.r_ax = 0x4200 | (byte)whence;	/* we define them like that */
	r.r_bx = fd;
	r.r_cx = HIWORD(offset);
	r.r_dx = LOWORD(offset);

	return _callDOS(&r)?  _SEEK_FAIL: MKLONG(r.r_dx, r.r_ax);
}
