/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: T.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Test program.

*/

#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <string.h>
#include <sys/stat.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: T.C 1.1 1997/10/27 03:53:28 ska Exp $";
#endif

#define NULL ((void*)0)

void _assert(char const * const condition
       ,char const * const filename
       ,long linenr)
{_abort("Abort.");}

void xwrite(char *s)
{	write(2, s, strlen(s));
	write(2, "\r\n", 2);
}
void err(char *s)
{	xwrite(s);
	exit(30);
}

main(void)
{	int fd, f1;
	char buf[] = "Just a test!!!\r\n";
	char hbuf[300];
	off_t pos, ende;

	if((fd = open("test.file", O_CREAT | O_TRUNC | O_TEXT | O_RDWR, S_IWRITE)) < 0)
		err("Open failed");
	if(write(fd, buf, strlen(buf)) != strlen(buf))
		xwrite("write failed");
	ende = pos = tell(fd);
	if((f1 = dup(1)) == -1)
		xwrite("dup failed");
	if(dup2(fd, 1) == -1)
		xwrite("dup2 failed");
	if(lseek(fd, 5, SEEK_SET) != 5)
		xwrite("seek failed");
	pos = filelength(fd);
	pos = tell(fd);
	if(chsize(fd, 100))
		xwrite("chsize failed");
	pos = tell(fd);
	pos = filelength(fd);
	pos = tell(fd);
	if(lseek(fd, ende, SEEK_SET) != ende)
		xwrite("seek failed");
	if(_truncate(fd))
		xwrite("truncate failed");
	if(lseek(fd, 0, SEEK_SET) != 0)
		xwrite("seek failed");
	if(read(fd, hbuf, 300) == (size_t)-1)
		xwrite("read failed");
	if(strcmp(buf, hbuf))
		xwrite("reread failed!!!!");
	switch(lock(fd, 0, 2)) {
	case -1: xwrite("Lock 0:2 error"); break;
	case  0: xwrite("Lock 0:2 succeeded"); break;
	case  1: xwrite("Lock 0:2 failed, already locked"); break;
	}
	switch(lock(fd, 2, 2)) {
	case -1: xwrite("Lock 2:2 error"); break;
	case  0: xwrite("Lock 2:2 succeeded"); break;
	case  1: xwrite("Lock 2:2 failed, already locked"); break;
	}
	switch(lock(fd, 0, 2)) {
	case -1: xwrite("Lock 0:2 error"); break;
	case  0: xwrite("Lock 0:2 succeeded (previous lock() ignored -> ERROR!!)"); break;
	case  1: xwrite("Lock 0:2 failed, already locked (that's OK!)"); break;
	}
	xwrite(unlock(fd, 0, 2)? "Unlock 0:2 failed": "Unlock 0:2 succeeded");
	switch(lock(fd, 0, 2)) {
	case -1: xwrite("Lock 0:2 error"); break;
	case  0: xwrite("Lock 0:2 succeeded"); break;
	case  1: xwrite("Lock 0:2 failed, already locked"); break;
	}

	close(fd);
	return 0;
}
