/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _ATTRU2D.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _attribu2d(unsigned mode)

	Convert a Unix-style attribute word into a DOS style attribute byte.
	Supported are the lower ten bits (drwxrwxrwx), but the lower nine
	are OR'ed together. Two additional flags are supported: S_ISYSTEM
	and S_IHIDDEN that cause to set the associated bit in the DOS attribute.

	Input:
		<none>

	Return:
		DOS style attribute byte

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		open, chmod

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:50  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>
#include <sys/stat.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _ATTRU2D.C 1.1 1997/11/18 04:24:50 ska Exp $";
#endif

_CLibFunc int
_attribu2d(unsigned mode)
{	int omode;

	/* OR the lower three triples together */
	mode |= (mode >> 3) | (mode >> 6);

	/* DOS style:
		The two upper flags (SYSTEM/HIDDEN) conforms to the bit2 2&1.
		The write permission is converted into READ-ONLY at bit 0.
	*/
	mode &= S_ISYSTEM | S_IHIDDEN | S_IWRITE;	/* mask useful bits */

	return (mode >> 14) | ((mode >> 1) ^ 1);
}
