/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _CTYPE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	_ctype[]

	_ctype[] is an array that provides bitfields to be accessed for
	the <ctype.h> macros/functions.

	Note:
		<none>

	Conforms to:
		Internal

	See also:
		<ctype.h>

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:07:03  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <ctype.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _CTYPE.C 1.1 1997/10/13 07:07:03 ska Exp $";
#endif

/* This array will return false for all values >= 0x80. this is because
	those values are non-standardized and vary from locale to locale.
*/
byte _ctype[256] = {
	/* 000 0x00 */	_IS_CNTRL,
	/* 001 0x01 */	_IS_CNTRL,
	/* 002 0x02 */	_IS_CNTRL,
	/* 003 0x03 */	_IS_CNTRL,
	/* 004 0x04 */	_IS_CNTRL,
	/* 005 0x05 */	_IS_CNTRL,
	/* 006 0x06 */	_IS_CNTRL,
	/* 007 0x07 */	_IS_CNTRL,
	/* 008 0x08 */	_IS_CNTRL,
	/* 009 0x09 */	_IS_CNTRL | _IS_SPACE,
	/* 010 0x0a */	_IS_CNTRL | _IS_SPACE,
	/* 011 0x0b */	_IS_CNTRL,
	/* 012 0x0c */	_IS_CNTRL,
	/* 013 0x0d */	_IS_CNTRL | _IS_SPACE,
	/* 014 0x0e */	_IS_CNTRL,
	/* 015 0x0f */	_IS_CNTRL,
	/* 016 0x10 */	_IS_CNTRL,
	/* 017 0x11 */	_IS_CNTRL,
	/* 018 0x12 */	_IS_CNTRL,
	/* 019 0x13 */	_IS_CNTRL,
	/* 020 0x14 */	_IS_CNTRL,
	/* 021 0x15 */	_IS_CNTRL,
	/* 022 0x16 */	_IS_CNTRL,
	/* 023 0x17 */	_IS_CNTRL,
	/* 024 0x18 */	_IS_CNTRL,
	/* 025 0x19 */	_IS_CNTRL,
	/* 026 0x1a */	_IS_CNTRL,
	/* 027 0x1b */	_IS_CNTRL,
	/* 028 0x1c */	_IS_CNTRL,
	/* 029 0x1d */	_IS_CNTRL,
	/* 030 0x1e */	_IS_CNTRL,
	/* 031 0x1f */	_IS_CNTRL,
	/* 032 0x20 */	_IS_BLANK | _IS_SPACE,
	/* 033 0x21 */	_IS_PUNCT,
	/* 034 0x22 */	_IS_PUNCT,
	/* 035 0x23 */	_IS_PUNCT,
	/* 036 0x24 */	_IS_PUNCT,
	/* 037 0x25 */	_IS_PUNCT,
	/* 038 0x26 */	_IS_PUNCT,
	/* 039 0x27 */	_IS_PUNCT,
	/* 040 0x28 */	_IS_PUNCT,
	/* 041 0x29 */	_IS_PUNCT,
	/* 042 0x2a */	_IS_PUNCT,
	/* 043 0x2b */	_IS_PUNCT,
	/* 044 0x2c */	_IS_PUNCT,
	/* 045 0x2d */	_IS_PUNCT,
	/* 046 0x2e */	_IS_PUNCT,
	/* 047 0x2f */	_IS_PUNCT,
	/* 048 0x30 */	_IS_DIGIT,
	/* 049 0x31 */	_IS_DIGIT,
	/* 050 0x32 */	_IS_DIGIT,
	/* 051 0x33 */	_IS_DIGIT,
	/* 052 0x34 */	_IS_DIGIT,
	/* 053 0x35 */	_IS_DIGIT,
	/* 054 0x36 */	_IS_DIGIT,
	/* 055 0x37 */	_IS_DIGIT,
	/* 056 0x38 */	_IS_DIGIT,
	/* 057 0x39 */	_IS_DIGIT,
	/* 058 0x3a */	_IS_PUNCT,
	/* 059 0x3b */	_IS_PUNCT,
	/* 060 0x3c */	_IS_PUNCT,
	/* 061 0x3d */	_IS_PUNCT,
	/* 062 0x3e */	_IS_PUNCT,
	/* 063 0x3f */	_IS_PUNCT,
	/* 064 0x40 */	_IS_PUNCT,
	/* 065 0x41 */	_IS_UPPER | _IS_HEX,
	/* 066 0x42 */	_IS_UPPER | _IS_HEX,
	/* 067 0x43 */	_IS_UPPER | _IS_HEX,
	/* 068 0x44 */	_IS_UPPER | _IS_HEX,
	/* 069 0x45 */	_IS_UPPER | _IS_HEX,
	/* 070 0x46 */	_IS_UPPER,
	/* 071 0x47 */	_IS_UPPER,
	/* 072 0x48 */	_IS_UPPER,
	/* 073 0x49 */	_IS_UPPER,
	/* 074 0x4a */	_IS_UPPER,
	/* 075 0x4b */	_IS_UPPER,
	/* 076 0x4c */	_IS_UPPER,
	/* 077 0x4d */	_IS_UPPER,
	/* 078 0x4e */	_IS_UPPER,
	/* 079 0x4f */	_IS_UPPER,
	/* 080 0x50 */	_IS_UPPER,
	/* 081 0x51 */	_IS_UPPER,
	/* 082 0x52 */	_IS_UPPER,
	/* 083 0x53 */	_IS_UPPER,
	/* 084 0x54 */	_IS_UPPER,
	/* 085 0x55 */	_IS_UPPER,
	/* 086 0x56 */	_IS_UPPER,
	/* 087 0x57 */	_IS_UPPER,
	/* 088 0x58 */	_IS_UPPER,
	/* 089 0x59 */	_IS_UPPER,
	/* 090 0x5a */	_IS_UPPER,
	/* 091 0x5b */	_IS_PUNCT,
	/* 092 0x5c */	_IS_PUNCT,
	/* 093 0x5d */	_IS_PUNCT,
	/* 094 0x5e */	_IS_PUNCT,
	/* 095 0x5f */	_IS_PUNCT,
	/* 096 0x60 */	_IS_PUNCT,
	/* 097 0x61 */	_IS_LOWER | _IS_HEX,
	/* 098 0x62 */	_IS_LOWER | _IS_HEX,
	/* 099 0x63 */	_IS_LOWER | _IS_HEX,
	/* 100 0x64 */	_IS_LOWER | _IS_HEX,
	/* 101 0x65 */	_IS_LOWER | _IS_HEX,
	/* 102 0x66 */	_IS_LOWER | _IS_HEX,
	/* 103 0x67 */	_IS_LOWER,
	/* 104 0x68 */	_IS_LOWER,
	/* 105 0x69 */	_IS_LOWER,
	/* 106 0x6a */	_IS_LOWER,
	/* 107 0x6b */	_IS_LOWER,
	/* 108 0x6c */	_IS_LOWER,
	/* 109 0x6d */	_IS_LOWER,
	/* 110 0x6e */	_IS_LOWER,
	/* 111 0x6f */	_IS_LOWER,
	/* 112 0x70 */	_IS_LOWER,
	/* 113 0x71 */	_IS_LOWER,
	/* 114 0x72 */	_IS_LOWER,
	/* 115 0x73 */	_IS_LOWER,
	/* 116 0x74 */	_IS_LOWER,
	/* 117 0x75 */	_IS_LOWER,
	/* 118 0x76 */	_IS_LOWER,
	/* 119 0x77 */	_IS_LOWER,
	/* 120 0x78 */	_IS_LOWER,
	/* 121 0x79 */	_IS_LOWER,
	/* 122 0x7a */	_IS_LOWER,
	/* 123 0x7b */	_IS_PUNCT,
	/* 124 0x7c */	_IS_PUNCT,
	/* 125 0x7d */	_IS_PUNCT,
	/* 126 0x7e */	_IS_PUNCT,
	/* 127 0x7f */	_IS_CNTRL,
	/* 128 0x80 */	0,
	/* 129 0x81 */	0,
	/* 130 0x82 */	0,
	/* 131 0x83 */	0,
	/* 132 0x84 */	0,
	/* 133 0x85 */	0,
	/* 134 0x86 */	0,
	/* 135 0x87 */	0,
	/* 136 0x88 */	0,
	/* 137 0x89 */	0,
	/* 138 0x8a */	0,
	/* 139 0x8b */	0,
	/* 140 0x8c */	0,
	/* 141 0x8d */	0,
	/* 142 0x8e */	0,
	/* 143 0x8f */	0,
	/* 144 0x90 */	0,
	/* 145 0x91 */	0,
	/* 146 0x92 */	0,
	/* 147 0x93 */	0,
	/* 148 0x94 */	0,
	/* 149 0x95 */	0,
	/* 150 0x96 */	0,
	/* 151 0x97 */	0,
	/* 152 0x98 */	0,
	/* 153 0x99 */	0,
	/* 154 0x9a */	0,
	/* 155 0x9b */	0,
	/* 156 0x9c */	0,
	/* 157 0x9d */	0,
	/* 158 0x9e */	0,
	/* 159 0x9f */	0,
	/* 160 0xa0 */	0,
	/* 161 0xa1 */	0,
	/* 162 0xa2 */	0,
	/* 163 0xa3 */	0,
	/* 164 0xa4 */	0,
	/* 165 0xa5 */	0,
	/* 166 0xa6 */	0,
	/* 167 0xa7 */	0,
	/* 168 0xa8 */	0,
	/* 169 0xa9 */	0,
	/* 170 0xaa */	0,
	/* 171 0xab */	0,
	/* 172 0xac */	0,
	/* 173 0xad */	0,
	/* 174 0xae */	0,
	/* 175 0xaf */	0,
	/* 176 0xb0 */	0,
	/* 177 0xb1 */	0,
	/* 178 0xb2 */	0,
	/* 179 0xb3 */	0,
	/* 180 0xb4 */	0,
	/* 181 0xb5 */	0,
	/* 182 0xb6 */	0,
	/* 183 0xb7 */	0,
	/* 184 0xb8 */	0,
	/* 185 0xb9 */	0,
	/* 186 0xba */	0,
	/* 187 0xbb */	0,
	/* 188 0xbc */	0,
	/* 189 0xbd */	0,
	/* 190 0xbe */	0,
	/* 191 0xbf */	0,
	/* 192 0xc0 */	0,
	/* 193 0xc1 */	0,
	/* 194 0xc2 */	0,
	/* 195 0xc3 */	0,
	/* 196 0xc4 */	0,
	/* 197 0xc5 */	0,
	/* 198 0xc6 */	0,
	/* 199 0xc7 */	0,
	/* 200 0xc8 */	0,
	/* 201 0xc9 */	0,
	/* 202 0xca */	0,
	/* 203 0xcb */	0,
	/* 204 0xcc */	0,
	/* 205 0xcd */	0,
	/* 206 0xce */	0,
	/* 207 0xcf */	0,
	/* 208 0xd0 */	0,
	/* 209 0xd1 */	0,
	/* 210 0xd2 */	0,
	/* 211 0xd3 */	0,
	/* 212 0xd4 */	0,
	/* 213 0xd5 */	0,
	/* 214 0xd6 */	0,
	/* 215 0xd7 */	0,
	/* 216 0xd8 */	0,
	/* 217 0xd9 */	0,
	/* 218 0xda */	0,
	/* 219 0xdb */	0,
	/* 220 0xdc */	0,
	/* 221 0xdd */	0,
	/* 222 0xde */	0,
	/* 223 0xdf */	0,
	/* 224 0xe0 */	0,
	/* 225 0xe1 */	0,
	/* 226 0xe2 */	0,
	/* 227 0xe3 */	0,
	/* 228 0xe4 */	0,
	/* 229 0xe5 */	0,
	/* 230 0xe6 */	0,
	/* 231 0xe7 */	0,
	/* 232 0xe8 */	0,
	/* 233 0xe9 */	0,
	/* 234 0xea */	0,
	/* 235 0xeb */	0,
	/* 236 0xec */	0,
	/* 237 0xed */	0,
	/* 238 0xee */	0,
	/* 239 0xef */	0,
	/* 240 0xf0 */	0,
	/* 241 0xf1 */	0,
	/* 242 0xf2 */	0,
	/* 243 0xf3 */	0,
	/* 244 0xf4 */	0,
	/* 245 0xf5 */	0,
	/* 246 0xf6 */	0,
	/* 247 0xf7 */	0,
	/* 248 0xf8 */	0,
	/* 249 0xf9 */	0,
	/* 250 0xfa */	0,
	/* 251 0xfb */	0,
	/* 252 0xfc */	0,
	/* 253 0xfd */	0,
	/* 254 0xfe */	0,
	/* 255 0xff */	0
};
