/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: MEMCCPY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void *memccpy(void * dst, void const *src, int ch, size_t length)

	Copy src to dst until either the first character ch or length
	characters have been copied.

	Input:
		src != NULL
		dst != NULL

	Return:
		dst if length == 0
		pointer to last copied byte

	Note:
		<none>

	Conforms to:
		Posix

	See also:
		memcpy

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MEMCCPY.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc void ___PTR *memccpy(void ___PTR * const dst
 , void const ___PTR * const src, const int ch
 , REG size_t length)
{	REG void ___PTR *match;

	assert(dst != NULL);
	assert(src != NULL);

	if((match = memchr(src, ch, length)) != NULL)
		length = (byte ___PTR *)match - (byte ___PTR *)src + 1;

	memcpy(dst, src, length);

	return (void ___PTR*)((byte ___PTR *)dst + length);
}
