/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STPCAT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *stpcat(char_t *dst, char_t *src)

	Appends NUL terminated string from src to dst. dst must point to
	a buffer that must be large enough to hold the concatination of
	both strings.

	Input:
		dst != NULL
		src != NULL

	Return:
		pointer to the NUL terminator of dst after copy

	Note:
		<none>

	Conforms to:
		ANSI C

	See also:
		strncpy, strcpy, strcat, memcpy, memmove

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_defs.h>
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STPCAT.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *stpcat(char_t ___PTR * const dst
 , char_t const ___PTR * const src)
{	
	assert(dst != NULL);
	assert(src != NULL);

	return stpcpy(_strstop(dst), src);
}
