/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRABRK.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char_t **strargbrk(char_t *line, char_t **argv, size_t argc)

	Breaks a line into tokens and saves them into argv. NUL characters
	are placed into line to mark the end of each argument (token). The
	argv array contains only pointers into line, that means, if the
	contents of line is modified, the argv array will point to invalid
	strings.

	The last used entry of the array is followed by a NULL entry.

	line is assumed to be a list of tokens delimited by whitespaces. If
	an argument contains a whitespace, it can be surrounded by single
	or double quotes. The quotes will be removed from the argument, if
	the argument starts and finishes with the same quote.

	Input:
		line != NULL
		if argv == NULL, the array is allocated dynamically
		if argc != 0, the number of entries of the array
		if argc == 0, the array is assumed to be large enough

	Return:
		NULL: malloc() failed or too few entries
		else: argv or pointer to malloc()'ed array

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		strargtoken

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.4  1998/02/11 07:40:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>
#include <alloc.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRABRK.C 1.4 1998/02/11 07:40:01 ska Exp ska $";
#endif

_CLibFunc char_t ___PTR * ___PTR *strargbrk(char_t ___PTR * line
 , char_t ___PTR * ___PTR * argv
 , size_t argc)
{	char_t ___PTR * ___PTR *av;		/* internally used pointer */
	size_t ac;							/* counter */
	char_t ___PTR *end;				/* end of current argument */

	ac = 0;
	if(!argv) {
		av = (char_t ___PTR * ___PTR *)malloc(argc? argc * sizeof(char_t ___PTR *)
		 : sizeof(char_t ___PTR*));
		if(!av) return NULL;
	}
	else av = argv;

	while((end = strargtoken(&line, " \t\n\r", NULL, "\"'", "\"'")) != NULL) {
		if(!argc) {
			if(!argv) {		/* dynamic grow of the array */
				char_t ___PTR * ___PTR *h;

				if((h = (char_t ___PTR * ___PTR *)realloc(
				 (void ___PTR*)av, (ac + 2) * sizeof(char_t ___PTR *)))
				 == NULL) {
				 	free(av);
				 	return NULL;
				}

				av = h;
			}
		}
		else if(ac >= argc) {
			if(!argv) free(av);
			return NULL;
		}
		av[ac++] = line;
		if(!*end) break;			/* end of line reached */
		*end = NUL;
		line = end + 1;
	}
	av[ac] = NULL;

	return av;
}
