/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRCMP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int strcmp(char_t const *s1, char_t const *s2)

	Determine the lexical order of both strings.

	Input:
		s1 != NULL
		s2 != NULL

	Return:
		 <0: if s1 < s2
		==0: if s1 == s2
		 >0: if s1 > s2

	Note:
		The characters of the strings are interpreted (unsigned)

	Conforms to:
		ANSI C

	See also:

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRCMP.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc int strcmp(char_t const ___PTR *s1, char_t const ___PTR *s2)
{	REG int d;

	assert(s1 != NULL);
	assert(s2 != NULL);

	/* This loop terminates if both characters differ or *s1 == NUL.
		If *s2 == NUL but *s1 != NUL, the loop terminates, too, because
		in this case both characters differ
	*/
	while((d = *(uchar_t const ___PTR *)s1
	   - *(uchar_t const ___PTR *)s2++) != 0
	 && *s1++);

	return d;
}
