/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRICMP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int stricmp(char_t const *s1, char_t const *s2)

	Determine the lexical order of both strings ignoring the case of the
	letters a-z and A-Z.

	Note: This function ignores the currently set locale; it assumes
	that a-z is 0x61..0x7a and A-Z is 0x40..0x5a.

	Input:
		s1 != NULL
		s2 != NULL

	Return:
		 <0: if s1 < s2
		==0: if s1 == s2
		 >0: if s1 > s2

	Note:
		The characters of the strings are interpreted (unsigned)

	Conforms to:
		ANSI C

	See also:
		strcmp, memcmpi

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRICMP.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc int stricmp(char_t const ___PTR *s1, char_t const ___PTR *s2)
{
	assert(s1 != NULL);
	assert(s2 != NULL);

	return memcmpi(s1, s2, strlen(s1) + 1);
}
