# MSDOS DMAKE startup file.  Customize to suit your needs.
# Assumes MKS toolkit for the tool commands, and Turbo-C.  Change as req'd.
# See the documentation for a description of internally defined macros.
#
# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT !:= $(.SILENT)
.SILENT   !:= yes

# Configuration parameters for DMAKE startup.mk file
# Set these to NON-NULL if you wish to turn the parameter on.
_HAVE_RCS	:= yes		# yes => RCS  is installed.
_HAVE_SCCS	:= 		# yes => SCCS is installed.

# Applicable suffix definitions
A := .lib	# Libraries
E := .exe	# Executables
C := .com	# Plain executables 
F := .for	# Fortran
O := .obj	# Objects
P := .pas	# Pascal
S := .asm	# Assembler sources
V := 		# RCS suffix

# See if these are defined
#
# TMPDIR, TEMP,& TMP to determine the temporary directory
# SHELL,& COMSPEC to determine the current shell
# USEMC to differ Micro-C from standard-C usage
# NDEBUG to disable debugging
# MODEL as the default model (if Micro-C is used, defaults to y)
#
.IMPORT .IGNORE : TMPDIR SHELL COMSPEC TEMP TMP NDEBUG MODEL COMPILER MAKESTARTUP MCDIR

.IF $(MCDIR) == $(NULL)
	MCDIR := C:\MC
.ENDIF

# default compiler is Micro-C
_COMPILER = $(null,$(COMPILER) MC $(COMPILER:u))
# Compiler type (Compiler without numbers and dots)
_COMPTYPE = $(_COMPILER:s/0//:s/1//:s/2//:s/3//:s/4//:s/5//:s/6//:s/7//:s/8//:s/9//:s/.//:)

.IF $(_COMPTYPE) == MC					# Micro-C has only Small/Tiny
_MODEL := $(eq,$(MODEL),t t s)
.ELSE
_MODEL := $(null,$(MODEL) s $(MODEL:l))		# default model is small
.ENDIF

# source in different types of "temporary directory" variables
# the result is $(TMPDIR)
.IF $(TMPDIR) != $(NULL)
.ELIF $(TEMP) != $(NULL)
TMPDIR := $(TEMP)
.ELIF $(TMP) != $(NULL)
TMPDIR := $(TMP)
.ELSE
TMPDIR := $(ROOTDIR)/tmp
.ENDIF

# Recipe execution configurations
# First set SHELL, If it is not defined, use COMSPEC, otherwise
# it is assumed to be MKS Korn SHELL.
.IF $(SHELL) == $(NULL)
.IF $(COMSPEC) == $(NULL)
   SHELL := $(ROOTDIR)/bin/sh$E
.ELSE
   SHELL := $(COMSPEC)
.END
.END
GROUPSHELL := $(SHELL)

# Now set remaining arguments depending on which SHELL we
# are going to use.  COMSPEC (assumed to be command.com) or
# MKS Korn Shell.
.IF $(SHELL)==$(COMSPEC)
   SHELLFLAGS  := $(SWITCHAR)c
   GROUPFLAGS  := $(SHELLFLAGS)
   SHELLMETAS  := *"?<>
   GROUPSUFFIX := .bat
   DIRSEPSTR   := \\
   DIVFILE      = $(TMPFILE:s,/,\)
   GROUPPROLOG := @ECHO OFF
   GROUPEPILOG := :ende
.ELSE
   SHELLFLAGS  := -c
   GROUPFLAGS  := 
   SHELLMETAS  := *"?<>|()&][$$\#`'
   GROUPSUFFIX := .ksh
   .MKSARGS    := yes
   DIVFILE      = $(TMPFILE:s,/,${DIVSEP_shell_${USESHELL}})
   DIVSEP_shell_yes := \\
   DIVSEP_shell_no  := \\
.END

#
# Standard C-language command names and flags
#

# Propagate the common macros to compiler specific macros
#	Each macro (*) is defined that it can be qualified by three strings
#	depending on $(_COMPILER).
#	1) If $(*_$(_COMPILER)) is not $(NULL), this definition is used.
#	2) Otherwise, if $(*_$(_COMPTYPE)) is not $(NULL), this definition is used.
#	3) Otherwise, a default definition will be used.
#	The idea behind this way it that some macros will never vary through
#	different compilers, e.g. the librarian, [that's class 3)], that some
#	macros will not	vary through different version of the same compiler,
#	e.g. the name of the configuration file, [that's class 2)], and that
#	other macros are unique to one particular compiler [class 1)].
#
#	All common macros are defined in the form:
#		* = $(*_$(_COMPILER):?$(CC_(_COMPTYPE)):?...)
#	This asures that, if the class 1) definition exists, it is used;
#	if not, class 2) definition is used; and if the one does also not
#	exist, the class 3) definition "..." is used.
#	For each compiler can be defined the special macros overwrite the
#	all purpose class 3) definition.

#		The C compiler itself
	# Compiling .C files _DBG with debug information; _NDBG without
	CFLAGS		= $(CFLAGS_$(null,$(NDEBUG) DBG NDBG)) $(MYCFLAGS)

    # Librarian
	AR		= $(AR_$(_COMPILER):?$(AR_$(_COMPTYPE)):?LIB$E)
    # Librarian flags (case-sensitive)
	ARFLAGS		= $(ARFLAGS_$(_COMPILER):?$(ARFLAGS_$(_COMPTYPE)):?/SCW)

# Common macros for general utilities
	AS_TASM		= tasm
	ASFLAGS_TASM	= /ml $(!null,$(NDEBUG) /DNDEBUG)

	AS_AS86		= as86
	ASFLAGS_AS86		= $(AS_AS86_$(null,$(NDEBUG) DBG NDBG))
	ASFLAGS_AS86_NDBG	= -X
	ASFLAGS_AS86_DBG	= -Q -C

	LD_TLINK	= tlink
	LDFLAGS_TLINK	= /c $(null,$(NDEBUG) /v)
	LDCOMFLAG_TLINK	= /Tdc

	LD_VAL		= $(MCDIR)\VAL$E
    LDFLAGS_VAL	= /NCI
	LDCOMFLAG_VAL	= /COM

	LD_HLINK	= hlink
	LDFLAGS_HLINK	= -8 -M$(@:db).map -H$(@:db).sym
	LDCOMFLAG_HLINK = -NO_COM_WITH_HLINK

.IF $(_COMPTYPE) == BC
# Class 2) macros for Borland C/C++
.INCLUDE : $(MAKESTARTUP:db).bc
.ENDIF


.IF $(_COMPTYPE) == PAC
# Class 2) macros for Pacific C
.INCLUDE : $(MAKESTARTUP:db).pac
.ENDIF


.IF $(_COMPTYPE) == MC
# Class 2) Macros for Micro-C
.INCLUDE : $(MAKESTARTUP:db).mc
.ENDIF


#
# Definition of $(MAKE) macro for recursive makes.
#
   MAKE = $(MAKECMD) -S $(MFLAGS)

# Language and Parser generation Tools and their flags
   YACC	  := byacc		# standard yacc
   YFLAGS +=
   YTAB	  := ytab		# yacc output files name stem.

   LEX	  := flex		# standard lex
   LFLAGS +=
   LEXYY  := lex_yy		# lex output file

# Other Compilers, Tools and their flags
   PC	:= tpc			# pascal compiler
   RC	:= anyf77		# ratfor compiler
   FC	:= anyf77		# fortran compiler

   CO	   := co		# check out for RCS
   COFLAGS += -q

   RM	   := rm		# remove a file command
   RMFLAGS += -sf		# a dash instead of a slash, for compatibly purpose 


# lex and yacc rules
   %.c .SWAP: %.y ; $(YACC)  $(YFLAGS) $<; mv $(YTAB).c $@
   %.c .SWAP: %.l ; $(LEX)   $(LFLAGS) $<; mv $(LEXYY).c $@

# RCS support
.IF $(_HAVE_RCS)
   % : $$(@:d)RCS/$$(@:f)$V;- $(CO) $(COFLAGS) $@
   .NOINFER : $$(@:d)RCS/$$(@:f)$V
.END

# SCCS support
.IF $(_HAVE_SCCS)
   % : s.% ; get $<
   .NOINFER : s.%
.END

# Recipe to make archive files.
%$A .SWAP .GROUP :
#	$(AR) $(ARFLAGS) $@ $?
	$(AR) $@ $(ARFLAGS) @$(mktmp +- $(?:t" \\\n+- ")\n), $*.lst
	$(RM) $(RMFLAGS) /l=1 1$(mktmp $?\n)

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) $(SWITCHAR)fr $<

# AUGMAKE extensions for SYSV compatibility
"@B" = $(@:b)
"@D" = $(@:d)
"@F" = $(@:f)
"*B" = $(*:b)
"*D" = $(*:d)
"*F" = $(*:f)
"<B" = $(<:b)
"<D" = $(<:d)
"<F" = $(<:f)
"?B" = $(?:b)
"?F" = $(?:f)
"?D" = $(?:d)

# Turn warnings back to previous setting.
.SILENT !:= $(__.SILENT)

# Local init file if any, gets parsed before user makefile
.INCLUDE .IGNORE: "_startup.mk"
