#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <math.h>

//Returns size of a file
long filesize(FILE *stream);

//Reads a line from an ascii file
char* ReadLine(FILE *fp);

//converts a single char to a null terminated string
char* chr2str(char c);

//displays help message
void helpmessage();

//scan arguments for switches and files
void ScanArguments(int argc, char *argv[]);

//Binary compare two files
void BinaryCompare();

//Ascii compare two files
void AsciiCompare();

//Global Variables
int noexpand=0,trim=0,firstlast=0,nocase=0,showlines=0,max=100,comparemode=2;

//file pointers
FILE *fptr[2];
//file names
char *files[2];

void main(int argc, char *argv[])
{
ScanArguments(argc,argv);
switch (comparemode)
	{
	case 1:BinaryCompare();
		break;
	case 2:AsciiCompare();
	}
}

void helpmessage()
	{
	printf("Compares two files or sets of files and displays the differences between them.\n");
	printf("\nFC [/A] [/C] [/L] [/LBn] [/N] [/T] [/W] [/nnnn] [drive1:][path1]filename1\n  [drive2][path2]filename2\n");
	printf("FC /B [drive1][path1]filename1 [drive2:][path2]filename2\n");
	printf("\n /A    Displays only first and last lines for each set of differences.");
	printf("\n /B    Performs a binary comparison.");
	printf("\n /C    Disregards the case of letters.");
	printf("\n /L    Compares files as ASCII text.");
	printf("\n /LBn  Sets the maximum consecutive mismatches to the specified number of \n       lines.");
	printf("\n /N    Displays the line numbers on an ASCII comparison.");
	printf("\n /T    Does not expand tabs to spaces.");
	printf("\n /W    Compress white space (tabs and spaces) for comparison.\n");
	exit(1);
	}

void ScanArguments(int argc, char *argv[])
{
int f=0;
//scan through arguments
for(int i=1;i<argc;i++)
{
if (strchr(argv[i],'/')==NULL)  files[f++]=strdup(argv[i]);
else if((strcmp("/B",strupr(argv[i])))==0) comparemode=1;
else if ((strcmp("/L",strupr(argv[i])))==0) comparemode=2;
else if ((strcmp("/A",strupr(argv[i])))==0) firstlast=1;
else if ((strcmp("/C",strupr(argv[i])))==0) nocase=1;
else if ((strcmp("/N",strupr(argv[i])))==0) showlines=1;
else if ((strcmp("/T",strupr(argv[i])))==0) noexpand=1;
else if ((strcmp("/W",strupr(argv[i])))==0) trim=1;
else if ((strcmp("/?",strupr(argv[i])))==0) helpmessage();
else if ((argv[i][0]=='/')&&(argv[i][1]=='L') && (argv[i][2]=='B'))
	{
	char* temp=new char;
	*temp=0;
	for (int j = 3;j<strlen(argv[i]);j++)
		strcat(temp,chr2str(argv[i][j]));
	max=atol(temp);
	}
}
if (f<2){printf("FC: Insufficient number of filespecs \n");exit(1);}
}

void BinaryCompare()
{
unsigned char a,b;
int i;
long int loc=1,size1;
for (i=0;i<2;i++)
if ((fptr[i]=fopen(files[i],"rb"))==NULL)
	{printf("Error opening file %s ! \n",files[i]);exit(1);}
printf("Comparing files %s and %s \n",files[0],files[1]);
for (size1=filesize(fptr[0]);loc<=size1;loc++)
	{
	fread(&a,1,1,fptr[0]);
	fread(&b,1,1,fptr[1]);
	if (a!=b)
	{
	for (i=8-(log10(loc)/log10(16));i>0;i--) printf("0");
	printf("%X:%c",loc-1);
	if (a<16) printf("0%X ",a);
	else printf("%X ",a);
	if (b<16) printf("0%X\n",b);
	else printf("%X\n",b);
	}
	}
}

void AsciiCompare()
{
	char* st[2];
	int show=1;
	int result;
	int different=0;
	int linenumber;
	printf("Comparing files %s and %s \n",files[0],files[1]);
	for(int i=0;i<2;i++)
	{
		linenumber=1;
		for (int j=0;j<2;j++)
			if ((fptr[j]=fopen(files[j],"rb"))==NULL)
				{printf("Error opening file %s ! \n",files[j]);exit(1);}
		printf("****** %s\n",files[i]);
		while (! (feof(fptr[0])||feof(fptr[1])) )
			{
				if (nocase==0) result=(strcmp(st[1]=ReadLine(fptr[0]),st[0]=ReadLine(fptr[1]))!=0);
				else result=(strcmp(strupr(st[1]=ReadLine(fptr[0])), strupr(st[0]=ReadLine(fptr[1]))) !=0 );
				if (result!=0)
					{
					different++;
					if (different>max)
					{
					printf("******\nFC: Too many differences encountered.\n(Use /LBn to reset maximum)\n");
					exit(1);
					}
					if (show==1)
						{
						if (showlines==1) printf("%d:",linenumber++);
						printf("%s",st[i]);
						}
					if (firstlast==1) show=0;
					}
				else show=1;
			}
		printf("******\n");
		fcloseall();
	}
	if (different==0) printf("FC: No differences encountered\n");
}

char* ReadLine(FILE *fp)
{
int l=1,j;
int space=0;
char* c=new char[2];
char* output=new char[100];
*output=0;
c[0]=0;
c[1]=0;
while (c[0]!='\n' && c[0]!=EOF)
	{
	c[0]=fgetc(fp);
	if (trim==0)
	{
	if ((noexpand==0)&&(c[0]=='\t'))
			for (j=8-(l%8);j>0;j--) {strcat(output," ");l++;}
	else {strcat(output,c);l++;}
	}
	else
		{
		if ((c[0]==' ')||(c[0]=='\t'))
			{if (space==0) {strcat(output," ");space=1;}}
		else {space=0;strcat(output,c);}
		}
	}
return output;
}

long filesize(FILE *stream)
{
   long curpos, length;
   curpos = ftell(stream);
   fseek(stream, 0L, SEEK_END);
   length = ftell(stream);
   fseek(stream, curpos, SEEK_SET);
   return length;
}

char* chr2str(char c)
{
char* temp=new char[2];
temp[0]=c;
temp[1]=0;
return temp;
}
