/* unz.c - wrapper to the info-unzip API */

/* Copyright (C) 1998-1999 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>				/* for system(), free() */
#include "dir.h"				/* header for DIR_CHAR */
#include "unzip.h"				/* for UzpMain() */


#define PATH_LEN 128				/* length of dir path */


int
unzip_file (const char *zipfile, const char *fromdir, char *destdir)
{
  char full_zipfile[PATH_LEN];			/* path to a zipfile */
  int ret;

  /* -d will extract into a given path.  -o will force overwrite if
     the files already exist */

  /* set 3=full_zipfile and 5=destdir */

  char *argv[7] = {"unz.c", "-qq", "-o", "full_zipfile", "-d", "destdir", NULL};

  /* .zip extension not needed as Unzip will add it if not there.  The
     DAT file may also have the .zip extension anyway. */

  sprintf (full_zipfile, "%s%c%s", fromdir, DIR_CHAR, zipfile);

  /* set 3=full_zipfile and 5=destdir */

  argv[3] = full_zipfile;			/* pointer assignment */
  argv[5] = destdir;				/* pointer assignment */
  ret = UzpMain (7, argv);			/* the Unzip code */

  /* Done */

  return (ret);
}
