/*  CPY_MOVE.C  Copy and Move routines
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <string.h>
#include <dir.h>
#include <direct.h>
#include <ctype.h>
#include <time.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define DIRECTORYBEZEICHNUNG  "> DIR <"
#define FESTANW               20
#define UNSICHTBAR            2
#define NOREVERSE             0
#define KOPIEREN              0
#define VERSCHIEBEN           1
#define UMBENENNEN            2
#define MARKIEREN             0
#define RENAME                1
#define MAX_PATH_TAB_ENTRY    5
#define MIN_X_LEFT_DIR        12
#define MAX_X_LEFT_DIR        349
#define MIN_Y_LEFT_DIR        99
#define MAX_Y_LEFT_DIR        322
#define X_LEFT_DIR_TASTEN     354
#define MIN_X_RIGHT_DIR       386
#define MAX_X_RIGHT_DIR       606
#define MIN_Y_RIGHT_DIR       99
#define MAX_Y_RIGHT_DIR       322
#define X_RIGHT_DIR_TASTEN    611
#define X_TO_DIRANF_L         3
#define X_TO_DIREND_L         335
#define X_TO_TASTANF_L        342
#define X_TO_DIRANF_R         3
#define X_TO_DIREND_R         215
#define X_TO_TASTANF_R        225
#define DIRBEZEICHNUNGS_POS   14
#define FILEEXT_POS           10
#define SYS_ATTRIBUT_POS      25
#define SYS_FILE              10
#define XREF_DATEIAUSWFENSTER 17
#define YREF_DATEIAUSWFENSTER 100
#define ENTRY_LENGTH          42

#define ANWAHL                0

#define NICHT_BEARBEITEN      '@'
#define ABGEWAEHLT            0
#define ANGEWAEHLT            1

extern char newbaum[];
extern char *MakeShowPath( char *, char *, int);
extern long Get_Datsize( char *);
extern BYTE Get_Call_mode( void);
extern char *Path_to_Dir( char *, char *);
extern BOOL _Filter( char *, char *, int);
extern char *Get_Filter( char *, char *);
extern char *Paste_Filter_to_Dir( char *, char *);

int _rmdir( const char *path)
{
   int ret_val;
   char p_curdir[ MAXDIR], *tmp_ptr;

   if(( ret_val= rmdir( path))== -1)
   {
      if( strncmp( path+ 1, ":\\", 2)== 0)
      {
	 if(( _getdcwd( *path- 64, p_curdir, MAXDIR))!= NULL)
	 {
	    if( stricmp( path, p_curdir)== 0)
	    {
	       if( *( stpcpy( p_curdir, path)- 1)!= '\\')
	       {
		  if(( tmp_ptr= strrchr( p_curdir, '\\'))!= NULL)
		  {
		     if( tmp_ptr> ( p_curdir+ 2))
			*tmp_ptr= '\0';
		     else
			*( tmp_ptr+ 1)= '\0';
		     if( chdir( p_curdir)== 0)
			ret_val= rmdir( path);
		  }
	       }
	    }
	 }
      }
   }
   return( ret_val);
}

typedef struct ffblk ffblk;
typedef struct dfree dfree;

#define _X             *( int *)arg_ptr[  0]
#define _Y             *( int *)arg_ptr[  1]
#define _TMP_ARRAY     ( char *)arg_ptr[  2]
#define _QUELLE        ( char *)arg_ptr[  3]
#define _QUELLE_END    ( char *)arg_ptr[  4]
#define _ZIEL          ( char *)arg_ptr[  5]
#define _ZIEL_END      ( char *)arg_ptr[  6]
#define _KOP_VERS     *( BYTE *)arg_ptr[  7]
#define _ALLES        *( BOOL *)arg_ptr[  8]
#define _XSP            ( int *)arg_ptr[  9]
#define _DFREE     ( *( dfree *)arg_ptr[ 10])
#define _STATUS        *( int *)arg_ptr[ 11]

void _del_dirs( void **arg_ptr)
{
   int lastentry;
   struct ffblk ffblk;

   lastentry= findfirst( "*.*", &ffblk, FA_DIREC);
   while( !lastentry)
   {
      if(( ffblk.ff_attrib& FA_DIREC)&& strcmp( ffblk.ff_name, ".")&& strcmp( ffblk.ff_name, ".."))
      {
	 if( _rmdir( ffblk.ff_name))
	 {
	    sprintf( _TMP_ARRAY, "Directory %s\\%s could not be erased", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 11), ffblk.ff_name);
	    ErrorMsg( _TMP_ARRAY);
	 }
      }
      lastentry= findnext( &ffblk);
   }
}

int del_entrys( void **arg_ptr, ffblk *ffblk_ptr)
{
   setcolor( datcolor);
   ShowMouse( AUS);
   ClearTextN( _X+ 23, _Y+ 48, 12);
   outtextxy(  _X+ 23, _Y+ 48, ffblk_ptr->ff_name);
   ShowMouse( AN);
   getcwd( _QUELLE, MAXDIR);
   if( Get_Call_mode()== FILE_SEARCH)
   {
      Paste_Filter_to_Dir( _QUELLE, ffblk_ptr->ff_name);
      if( !access( _QUELLE, 0))
      {
	 if( _chmod( _QUELLE, 0)& FA_RDONLY)
	 {
	    sprintf( _TMP_ARRAY, "%s\nis write protected.\nErase anyway?", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 22));
	    switch( Info_Frage( 300, 250, _TMP_ARRAY, FRAGE))
	    {
	       case 0:                                             /* ja */
		  chmod( _QUELLE, S_IWRITE);
		  break;
	       case 1:                                           /* nein */
		  return( 0);
	       case 2:                                   /* ESC, Abbruch */
		  return( -1);
	    }
	 }
	 if( unlink( _QUELLE))
	 {
	    sprintf( _TMP_ARRAY, "%s could not be erased", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 30));
	    ErrorMsg( _TMP_ARRAY);
	 }
      }
   }
   else
   {
      _del_dirs( arg_ptr);
   }
   return( 0);
}

int _DelTree( int X, int Y, char *S_path)
{
   int status;
   void *arg_ptr[ 4];
   char S_path_sp[ MAXPATH], tmp_array[ 180];

   arg_ptr[ 0]= &X;
   arg_ptr[ 1]= &Y;
   arg_ptr[ 2]= tmp_array;
   arg_ptr[ 3]= S_path_sp;
   status= TREE_Funktion( S_path, "*.*", del_entrys, arg_ptr, DIR_SEARCH_NACH| FILE_SEARCH);
   if( _rmdir( S_path))
   {
      sprintf( tmp_array, "Directory %s could not be erased", MakeShowPath( S_path, tmp_array+ 140, 24));
      ErrorMsg( tmp_array);
   }
   return( status);
}

int _Loeschen( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   DATWINStruct *q_DW, *z_DW;
   char **q_tab, **z_tab;
   int status= 0, ret, l= 0, anz_bearb= 0, attrib, xsp= 0;
   long gesbyte_mark, byte= 0L;
   char pfad[ MAXPATH], q_dir[ MAXDIR], tmp_array[ 180];
   WORD mauspos[]= { BUTTON| FRAME| KEY,              5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY| DEFBUTTON,  17, 156, 110, 135, RETURN,
		     BUTTON| FRAME| KEY,            164, 302, 110, 135, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 320, 154, 4, INIT, NULL, AUS};

   if( Quelle== LEFT)
   {
      q_DW= l_DW;
      z_DW= r_DW;
      q_tab= path_tab_ptr_l;
      z_tab= path_tab_ptr_r;
   }
   else
   {
      q_DW= r_DW;
      z_DW= l_DW;
      q_tab= path_tab_ptr_r;
      z_tab= path_tab_ptr_l;
   }
   if( q_DW->anz_mark== 0)
   {
      Hinweis( "No file(s) selected for erasing      ");
   }
   else
   {
      if( q_DW->gesbyte_mark== 0)
	 gesbyte_mark= q_DW->anz_mark;
      else
	 gesbyte_mark= q_DW->gesbyte_mark;
      MS.x= &loeschx;
      MS.y= &loeschy;
      MS.mauspos= mauspos;
      PCX_Window( MS.x, MS.y, PCX_LOESCHEN, &MS.sa, SHADOW);
      ShowMouse( AUS);
      ShowDrive( *MS.x+ 214, *MS.y+ 52, Laufwerksart( toupper( *q_DW->verzeichnis)- 'A'));
      setcolor( EGA_BLACK);
      ClearTextN( *MS.x+ 239, *MS.y+ 55, 2);
      sprintf( tmp_array, "%c:", toupper( *q_DW->verzeichnis));
      outtextxy( *MS.x+ 239, *MS.y+ 55, tmp_array);
      ShowMouse( AN);
      while(( status= __CheckMousepos( &MS))== -1)
	 ;
      if( status== 1)                                             /* Return */
      {
	 Path_to_Dir( q_dir, q_DW->verzeichnis);
	 for( l= 0, ret= 0; ( l< q_DW->RB->max)&& !ret; l++)
	 {
	    if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
	    {
	       MakePfad( q_dir, pfad, q_DW->dir_entrys, l);
	       setcolor( datcolor);
	       ShowMouse( AUS);
	       ClearTextN( *MS.x+ 23, *MS.y+ 48, 12);
	       outtextxy(  *MS.x+ 23, *MS.y+ 48, strrchr( pfad, '\\')+ 1);
	       ShowMouse( AN);
	       if( Break( 250, 275, "Really end the\ncurrent process?"))
		  break;
	       if(( attrib= _chmod( pfad, 0))& FA_DIREC)
	       {
		  if( _rmdir( pfad))
		  {
		     sprintf( tmp_array, "%s\nis a directory\nwhich still contains\nfiles.  Really\nerase directory?", MakeShowPath( pfad, tmp_array+ 140, 22));
		     switch( Info_Frage( 300, 250, tmp_array, FRAGE))
		     {
			case 1:                                     /* nein */
			   goto ProzentAnz;
			case 2:                             /* ESC, Abbruch */
			   ret= 1;
			   continue;
		     }
		     switch( _DelTree( *MS.x, *MS.y, pfad))
		     {
			case -2:                                 /* Abbruch */
			   ret= 1;
			   newbaum[ toupper( pfad[ 0])- 'A']= 1;
			   continue;
			default:
			   anz_bearb++;
			   break;
		     }
		  }
		  else
		     anz_bearb++;
		  byte++;
		  newbaum[ toupper( pfad[ 0])- 'A']= 1;
		  goto ProzentAnz;
	       }
	       if( attrib& FA_RDONLY)
	       {
		  sprintf( tmp_array, "%s\nis write protected.\nErase anyway?", MakeShowPath( pfad, tmp_array+ 140, 22));
		  switch( Info_Frage( 300, 250, tmp_array, FRAGE))
		  {
		     case 0:                              /* ja */
			chmod( pfad, S_IWRITE);
			break;
		     case 1:                            /* nein */
			goto ProzentAnz;
		     case 2:                    /* ESC, Abbruch */
			ret= 1;
			continue;
		  }
	       }
	       if( unlink( pfad))
		  ErrorMsg( "Erasing could not be completed");
	       else
		  anz_bearb++;
	       ProzentAnz:
	       ;
	       ShowMouse( AUS);
	       Balken( *MS.x+ 18, *MS.y+ 83, 283, 10, byte+= Get_Datsize( q_DW->dir_entrys[ l]), gesbyte_mark, &xsp);
	       ShowMouse( AN);
	    }
	 }
      }
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   if( anz_bearb> 0)
   {
      LoescheVar( d_MS, q_DW, q_tab);
      LoescheVar( d_MS, z_DW, z_tab);
   }
   return( anz_bearb);
}

int findentrys( void **arg_ptr, ffblk *ffblk_ptr)
{
   getcwd( _QUELLE, MAXDIR);
   if( Get_Call_mode()!= DIR_SEARCH_NACH)
   {
      setcolor( datcolor);
      ShowMouse( AUS);
      ClearTextN( _X+ 23, _Y+ 110, 12);
      outtextxy(  _X+ 23, _Y+ 110, ffblk_ptr->ff_name);
      ShowMouse( AN);
      strcpy( _ZIEL_END, _QUELLE_END);
      if( ffblk_ptr->ff_attrib& FA_DIREC)
      {
	 if( access( _ZIEL, 0))
	 {
	    if( mkdir( _ZIEL))
	    {
	       sprintf( _TMP_ARRAY, "Could not create directory %s", ffblk_ptr->ff_name);
	       ErrorMsg( _TMP_ARRAY);
	       return( -1);
	    }
	    else
	    {
	       *_XSP= 0;
	       Balken( _X+ 18, _Y+ 145, 283, 8, 1L, 1L, _XSP);
	    }
	 }
      }
      else
      {
	 Paste_Filter_to_Dir( _QUELLE, ffblk_ptr->ff_name);
	 Paste_Filter_to_Dir( _ZIEL, ffblk_ptr->ff_name);
	 if( !access( _ZIEL, 0))
	 {
	    if( !_ALLES)
	    {
	       sprintf( _TMP_ARRAY, "%s already exists\nin the target directory.\nShould it be replaced?", ffblk_ptr->ff_name);
	       switch( K_V_Frage( 330, 250, _TMP_ARRAY))
	       {
		  case 0:                                            /* ESC */
		     return( -1);
		  case 3:                                           /* alle */
		     _ALLES= AN;
		     break;
		  case 4:                               /* alle auer diese */
		     _ALLES= AN;
		  case 2:                                           /* nein */
		     return( 0);
	       }
	    }
	    if( _chmod( _ZIEL, 0)& FA_RDONLY)
	    {
	       sprintf( _TMP_ARRAY, "%s\nis write protected.\nReplace anyway?", MakeShowPath( _ZIEL, _TMP_ARRAY+ 140, 22));
	       switch( Info_Frage( 300, 250, _TMP_ARRAY, FRAGE))
	       {
		  case 0:                                             /* ja */
		     chmod( _ZIEL, S_IWRITE);
		     break;
		  case 1:                                           /* nein */
		     return( 0);
		  case 2:                                   /* ESC, Abbruch */
		     return( -1);
	       }
	    }
	 }
	 if(( _KOP_VERS== VERSCHIEBEN)&& ( *_QUELLE== *_ZIEL))  /* Quell- und Ziellaufwerk identisch */
	 {
	    if( rename( _QUELLE, _ZIEL))
	    {
	       sprintf( _TMP_ARRAY, "%s cannot be moved", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 30));
	       ErrorMsg( _TMP_ARRAY);
	    }
	    else
	    {
	       *_XSP= 0;
	       Balken( _X+ 18, _Y+ 145, 283, 8, 1L, 1L, _XSP);
	    }
	 }
	 else
	 {
	    if(( _STATUS= Copy( _X+ 18, _Y+ 145, 283, 8, _QUELLE, _ZIEL))!= 0)
	    {
	       if( _STATUS!= -3)          /* nicht CREAT_ERROR der Zieldatei */
	       {
		  getdfree( toupper( *_QUELLE)- 64, &_DFREE);
		  if(( ( long)_DFREE.df_avail* ( long)_DFREE.df_bsec* ( long)_DFREE.df_sclus)< ffblk_ptr->ff_fsize)
		  {
		     ErrorMsg( "Insufficient free disk space");
		     return( -1);
		  }
	       }
	       MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 30);
	       if( _KOP_VERS== KOPIEREN)
		  sprintf( _TMP_ARRAY, "%s could not be copied", _TMP_ARRAY+ 140);
	       else
		  sprintf( _TMP_ARRAY, "%s could not be moved", _TMP_ARRAY+ 140);
	       ErrorMsg( _TMP_ARRAY);
	    }
	    else
	    {
	       if( _KOP_VERS== VERSCHIEBEN)
	       {
		  if( _chmod( _QUELLE, 0)& FA_RDONLY)
		  {
		     sprintf( _TMP_ARRAY, "%s\nis write protected.\nErase anyway?", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 22));
		     switch( Info_Frage( 300, 250, _TMP_ARRAY, FRAGE))
		     {
			case 0:                                       /* ja */
			   chmod( _QUELLE, S_IWRITE);
			   break;
			case 1:                                     /* nein */
			   return( 0);
			case 2:                             /* ESC, Abbruch */
			   return( -1);
		     }
		  }
		  if( unlink( _QUELLE))
		  {
		     sprintf( _TMP_ARRAY, "%s could not be erased", MakeShowPath( _QUELLE, _TMP_ARRAY+ 140, 30));
		     ErrorMsg( _TMP_ARRAY);
		  }
	       }
	    }
	 }
      }
   }
   else
   {
      if( _KOP_VERS== VERSCHIEBEN)
      {
	 _del_dirs( arg_ptr);
      }
   }
   return( 0);
}

int _TreeKopie( BYTE k_v, int X, int Y, char *q_path, char *z_path, BOOL *alles)
{
   struct dfree dfree;
   int xsp, status, Status;
   void *arg_ptr[ 12];
   char q_path_sp[ MAXPATH], z_path_sp[ MAXPATH], tmp_array[ 180], *tmp_ptr;

   arg_ptr[  0]= &X;
   arg_ptr[  1]= &Y;
   arg_ptr[  2]= tmp_array;
   arg_ptr[  3]= q_path_sp;
   arg_ptr[  4]= strrchr( strcpy( q_path_sp, q_path), '\\');
   if( *(( tmp_ptr= stpcpy( z_path_sp, z_path))- 1)!= '\\')
      *tmp_ptr= '\\';
   else
      tmp_ptr--;
   arg_ptr[  5]= z_path_sp;
   arg_ptr[  6]= tmp_ptr;
   arg_ptr[  7]= &k_v;
   arg_ptr[  8]= alles;
   arg_ptr[  9]= &xsp;
   arg_ptr[ 10]= &dfree;
   arg_ptr[ 11]= &Status;
   status= TREE_Funktion( q_path, "*.*", findentrys, arg_ptr, DIR_SEARCH_VOR| DIR_SEARCH_NACH| FILE_SEARCH);
   if( k_v== VERSCHIEBEN)
   {
      if( _rmdir( q_path))
      {
	 sprintf( tmp_array, "Directory %s could not be erased", MakeShowPath( q_path, tmp_array+ 140, 24));
	 ErrorMsg( tmp_array);
      }
   }
   return( status);
}

int K_V_Frage( int x, int y, char *Msg)
{
   int iy, anzzeilen= 0, status= -1;
   char *Msg_dup, *Msg_ptr;
   void *old_maus_cursor= last_maus_cursor;
   char *msg[]= { "only this file ",
		  "not this file    ",
		  "all selected files     ",
		  "all selected files except this one  " };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     BUTTON|      FRAME| KEY| DEFBUTTON| MSG,  11, 134,  76, 101, 'j',
		     BUTTON|      FRAME| KEY|            MSG, 144, 265,  76, 101, 'n',
		     BUTTON|      FRAME| KEY|            MSG,  11, 134, 106, 131, 'l',
		     BUTTON|      FRAME| KEY|            MSG, 144, 265, 106, 131, 'e',
		     BUTTON|      FRAME| KEY,             11, 265, 144, 169, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 278, 180, 7, INIT, NULL, AN};

   MS.x= &x;
   MS.y= &y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   if(( Msg_ptr= Msg_dup= strdup( Msg))== NULL)
   {
      ErrorMsg( KEIN_SPEICHER);
   }
   else
   {
      PCX_Window( MS.x, MS.y, PCX_KOP_VERS_FRAGE, &MS.sa, SHADOW);
      ShowMouse( AUS);
      while(( Msg_ptr= strchr( Msg_ptr, '\n'))!= NULL)
      {
	 Msg_ptr++;
	 anzzeilen++;
      }
      anzzeilen++;
      Msg_ptr= strtok( Msg_dup, "\n");
      for( iy= *MS.y+ 32+ ((( double)( 3- anzzeilen)/ ( double)2.0)* 14); ( iy< ( *MS.y+ 95))&& Msg_ptr; iy+= 12)
      {
	 OutTextN( *MS.x+ 35, iy, Msg_ptr, 29);
	 Msg_ptr= strtok( NULL, "\n");
      }
      ShowMouse( AN);
      free( Msg_dup);
      MouseArt( maus_pfeil);
      while(( status= __CheckMousepos( &MS))== -1)
	 ;
      MouseArt( old_maus_cursor);
      if( status== 5)                                            /* Abbruch */
	 status= 0;
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   return( status);  /* 0= ESC; 1= ja, 2= nein, 3= alles, 4= alles auer diese */
}

int _Kop_Vers( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle, char *InputDefault, char K_V)
{
   struct dfree free;
   DATWINStruct *q_DW, *z_DW;
   int X_Tree= 330, status= 1, ret= 0, l, xsp= 0, xsp2= 0, anz_bearb= 0;
   long gesbyte_mark, byte= 0L;
   char Ziel_path[ MAXPATH], tmp_array[ 180], *tmp_ptr, kop_ren= KOPIEREN,
	*zptr, filter[ 30], pfad2[ MAXPATH], Quell_path[ MAXPATH], Q_path[ MAXPATH],
	*q_datei, **q_tab, **z_tab;
   BOOL alleskop= AUS;
   void *arg_ptr[ 2];
   char *msg[]= { "Enter the target directory or a new filename here                " };
   WORD mauspos[]= { BUTTON|    FRAME| KEY,                   5,  27,   5,  21, ESC,
		     DIRINPUT| IGN_CASE|  FRAME| KEY|            MSG,  17,  43, 233, MAXPATH- 1, 256,  33, LWAUSWAHL, 'i',
		     BUTTON|    FRAME| KEY| DEFBUTTON,       17, 156, 193, 218, RETURN,
		     BUTTON|    FRAME| KEY,                 164, 302, 193, 218, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 320, 230, 5, INIT, NULL, AN};

   if( Quelle== LEFT)
   {
      q_DW= l_DW;
      z_DW= r_DW;
      q_tab= path_tab_ptr_l;
      z_tab= path_tab_ptr_r;
   }
   else
   {
      q_DW= r_DW;
      z_DW= l_DW;
      q_tab= path_tab_ptr_r;
      z_tab= path_tab_ptr_l;
   }
   if( q_DW->anz_mark== 0)
   {
      if( K_V== KOPIEREN)
	 Hinweis( "No file(s) selected for copying    ");
      else
	 Hinweis( "No file(s) selected for moving         ");
   }
   else
   {
      arg_ptr[ 0]= Ziel_path;
      arg_ptr[ 1]= &X_Tree;
      if( K_V== KOPIEREN)
      {
	 MS.x= &kopiex;
	 MS.y= &kopiey;
      }
      else
      {
	 MS.x= &verschx;
	 MS.y= &verschy;
      }
      MS.msg= msg;
      MS.mauspos= mauspos;
      MS.arg_ptr= arg_ptr;
      if( K_V== KOPIEREN)
	 PCX_Window( MS.x, MS.y, PCX_KOPIEREN, &MS.sa, SHADOW);
      else
	 PCX_Window( MS.x, MS.y, PCX_VERSCHIEBEN, &MS.sa, SHADOW);
      if( InputDefault!= NULL)
	 strcpy( Ziel_path, InputDefault);
      else
	 Path_to_Dir( Ziel_path, z_DW->verzeichnis);
      Path_to_Dir( Quell_path, q_DW->verzeichnis);
      if( q_DW->gesbyte_mark== 0L)
	 gesbyte_mark= ( long)q_DW->anz_mark;
      else
	 gesbyte_mark= q_DW->gesbyte_mark;
      do
      {
	 do
	 {
	    if(( status== 1)&& isalpha( Ziel_path[ 0])&& ( Ziel_path[ 1]== ':')) /* Eingabezeile */
	    {
	       ShowMouse( AUS);
	       ShowDrive( *MS.x+ 169, *MS.y+ 106, Laufwerksart( toupper( Quell_path[ 0])- 'A'));
	       ShowDrive( *MS.x+ 243, *MS.y+ 106, Laufwerksart( toupper( Ziel_path[ 0])- 'A'));
	       setcolor( EGA_BLACK);
	       ClearTextN( *MS.x+ 194, *MS.y+ 109, 2);
	       sprintf( tmp_array, "%c:", toupper( Quell_path[ 0]));
	       outtextxy( *MS.x+ 194, *MS.y+ 109, tmp_array);
	       ClearTextN( *MS.x+ 268, *MS.y+ 109, 2);
	       sprintf( tmp_array, "%c:", toupper( Ziel_path[ 0]));
	       outtextxy( *MS.x+ 268, *MS.y+ 109, tmp_array);
	       ShowMouse( AN);
	    }
	 }while((( status= __CheckMousepos( &MS))== -1)|| ( status== 1));
	 if(( status== 0)|| ( status== 3))                  /* ESC, Abbruch */
	    break;
	 if( isalpha( *Ziel_path)&& ( *( Ziel_path+ 1)== ':'))
	 {
	    if( *( Ziel_path+ 2)!= '\\')
	    {
	       strcpy( tmp_array, Ziel_path+ 2);
	       if( _getdcwd( *Ziel_path- 64, Ziel_path, MAXPATH)!= NULL)
	       {
		  strcat( Ziel_path, tmp_array);
		  ReinitWindow( &MS);
		  ret= 1;
	       }
	       else
	       {
		  ErrorMsg( "That drive does not exist in your system");
		  continue;
	       }
	    }
	    if(( *( tmp_ptr= ( stpcpy( tmp_array, Ziel_path)- 1))== '\\')&& ( tmp_ptr> &tmp_array[ 2]))
	       ErrorMsg( "Only the root directory has a backslash (\\) at the end");
	    else
	    {
	       if(( tmp_ptr= strrchr( tmp_array, '\\'))> tmp_array+ 2)
		  *tmp_ptr= '\0';
	       else
		  *( tmp_ptr+ 1)= '\0';
	       if( access( tmp_array, 0))
		  ErrorMsg( "The (parent) directory of the target does not exist");
	       else
	       {
		  if( !strcmp( Quell_path, Ziel_path))
		     ErrorMsg( "Source and target are identical");
		  else
		  {
		     if( access( Ziel_path, 0)|| !( _chmod( Ziel_path, 0)& FA_DIREC))
			kop_ren= UMBENENNEN;
		     ret= 1;
		  }
	       }
	    }
	 }
	 else
	 {
	    kop_ren= UMBENENNEN;
	    ret= 1;
	 }
      }while( !ret);
      if( ret)                                     /* kein ESC oder Abbruch */
      {
	 zptr= stpcpy( pfad2, Ziel_path);
	 if( kop_ren== KOPIEREN)
	 {
	    if( *( zptr- 1)!= '\\')
	       strcpy( zptr++, "\\");
	 }
	 else
	 {
	    if(( zptr= strrchr( pfad2, '\\'))== NULL)
	    {
	       strcpy( filter, pfad2);
	       if( *(( zptr= stpcpy( pfad2, Quell_path))- 1)!= '\\')
		  strcpy( zptr++, "\\");
	    }
	    else
	       strcpy( filter, ++zptr);
	 }
	 *( strcpy( Q_path, Ziel_path)+ (( zptr- 1)- pfad2))= '\0';
	 q_datei= Q_path+ ( status= strlen( Quell_path))+ ( *( Quell_path+ status- 1)!= '\\');  /* +1 wenn letztes Zeichen nicht '\\' */
	 for( l= 0, ret= 0; ( l< q_DW->RB->max)&& !ret; l++)
	 {
	    if( q_DW->dir_entrys[ l][ 0]== ANGEWAEHLT)
	    {
	       status= MakePfad( Quell_path, Q_path, q_DW->dir_entrys, l);
	       setcolor( datcolor);
	       ShowMouse( AUS);
	       ClearTextN( *MS.x+ 23, *MS.y+ 110, 12);
	       outtextxy(  *MS.x+ 23, *MS.y+ 110, strcpy( zptr, q_datei));
	       ShowMouse( AN);
	       if( status== DIR)
	       {
		  if( access( Ziel_path, 0))
		  {
		     MakeShowPath( Ziel_path, Q_path, 24);
		     sprintf( tmp_array, "The target directory %s does not exist", Q_path);
		     ErrorMsg( tmp_array);
		  }
		  else
		  {
		     if( !( _chmod( Ziel_path, 0)& FA_DIREC))
		     {
			MakeShowPath( Ziel_path, Q_path, 35);
			sprintf( tmp_array, "%s is not a directory", Q_path);
			ErrorMsg( tmp_array);
		     }
		     else
		     {
			if( strstr( Ziel_path, Q_path)== Ziel_path)
			   ErrorMsg( "Target directory is inside the source directory");
			else
			{
			   status= _TreeKopie( K_V, *MS.x, *MS.y, Q_path, Ziel_path, &alleskop);
			   newbaum[ Ziel_path[ 0]- 'A']= 1;
			   byte++;
			   switch( status)
			   {
			      case -2:                           /* Abbruch */
				 ret= 1;
				 continue;
			      default:
				 q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
				 anz_bearb++;
				 break;
			   }
			}
		     }
		  }
	       }
	       else
	       {
		  if( Break( 250, 275, "Really end the\ncurrent process?"))
		     break;
		  if( kop_ren== UMBENENNEN)
		     _Filter( zptr, filter, RENAME);
		  if(( K_V== VERSCHIEBEN)&& ( _chmod( Q_path, 0)& FA_SYSTEM))
		  {
		     sprintf( tmp_array, "%s\nis a system file.\nDOS.SYS, IO.SYS, etc\nmust not be moved.\nMove anyway?", MakeShowPath( Q_path, filter, 22));
		     switch( Info_Frage( 300, 250, tmp_array, FRAGE))
		     {
			case 1:                                     /* nein */
			   goto ProzentAnz;
			case 2:                             /* ESC, Abbruch */
			   ret= 1;
			   continue;
		     }
		  }
		  if( !access( pfad2, 0))
		  {
		     if( alleskop== AUS)
		     {
			sprintf( tmp_array, "%s already exists\nin the target directory.\nShould it be replaced?", zptr);
			switch( K_V_Frage( 330, 250, tmp_array))
			{
			   case 0:                                   /* ESC */
			      ret= 1;
			      continue;
			   case 3:                                  /* alle */
			      alleskop= AN;
			      break;
			   case 4:                      /* alle auer diese */
			      alleskop= AN;
			   case 2:                                  /* nein */
			      goto ProzentAnz;
			}
		     }
		     if( _chmod( pfad2, 0)& FA_RDONLY)
		     {
			sprintf( tmp_array, "%s\nis write protected.\nReplace anyway?", MakeShowPath( pfad2, filter, 22));
			switch( Info_Frage( 300, 250, tmp_array, FRAGE))
			{
			   case 0:                                       /* ja */
			      chmod( pfad2, S_IWRITE);
			      break;
			   case 1:                                     /* nein */
			      goto ProzentAnz;
			   case 2:                             /* ESC, Abbruch */
			      ret= 1;
			      continue;
			}
		     }
		     if( K_V== VERSCHIEBEN)
			unlink( pfad2);
		  }
		  if(( K_V== VERSCHIEBEN)&& ( Q_path[ 0]== pfad2[ 0]))  /* Quell- und Ziellaufwerk identisch */
		  {
		     if( rename( Q_path, pfad2))
		     {
			sprintf( tmp_array, "Moving of %s could not be completed", zptr);
			ErrorMsg( tmp_array);
		     }
		     else
		     {
			anz_bearb++;
			xsp2= 0;
			Balken( *MS.x+ 18, *MS.y+ 145, 283, 8, 1L, 1L, &xsp2);
		     }
		  }
		  else
		  {
		     if(( status= Copy( *MS.x+ 18, *MS.y+ 145, 283, 8, Q_path, pfad2))!= 0)
		     {
			if( status!= -3) /* nicht CREAT_ERROR der Zieldatei */
			{
			   getdfree( toupper( pfad2[ 0])- 64, &free);
			   if(( ( long)free.df_avail* ( long)free.df_bsec* ( long)free.df_sclus)< Get_Datsize( q_DW->dir_entrys[ l]))
			   {
			      ErrorMsg( "Insufficient free disk space");
			      break;
			   }
			}
			if( K_V== KOPIEREN)
			   sprintf( tmp_array, "Copying of %s could not be completed", zptr);
			else
			   sprintf( tmp_array, "Moving of %s could not be completed", zptr);
			ErrorMsg( tmp_array);
		     }
		     else
		     {
			anz_bearb++;
			if( K_V== KOPIEREN)
			   q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
			else
			{
			   if( _chmod( Q_path, 0)& FA_RDONLY)
			   {
			      sprintf( tmp_array, "%s\nis write protected.\nErase anyway?", MakeShowPath( Q_path, filter, 22));
			      switch( Info_Frage( 300, 250, tmp_array, FRAGE))
			      {
				 case 0:                              /* ja */
				    chmod( Q_path, S_IWRITE);
				    break;
				 case 1:                            /* nein */
				    goto ProzentAnz;
				 case 2:                    /* ESC, Abbruch */
				    ret= 1;
				    continue;
			      }
			   }
			   if( unlink( Q_path))
			   {
			      sprintf( tmp_array, "Erasing of %s could not be completed", zptr);
			      ErrorMsg( tmp_array);
			   }
			}
		     }
		  }
	       }
	       ProzentAnz:
	       ;
	       ShowMouse( AUS);
	       Balken( *MS.x+ 18, *MS.y+ 175, 283, 10, byte+= Get_Datsize( q_DW->dir_entrys[ l]), gesbyte_mark, &xsp);
	       ShowMouse( AN);
	    }
	 }
      }
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   if( anz_bearb> 0)
   {
      LoescheVar( d_MS, q_DW, q_tab);
      LoescheVar( d_MS, z_DW, z_tab);
   }
   return( anz_bearb);
}

#define VE_ATTRIBUTE  0
#define VE_RENAME     1

#define LOESCHEN       0
#define SETZEN         1
#define UNVERAENDERT   2
#define ALLE           0
#define EINZELN        1

void _Attribute_Rename_Voreinstellung( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle, BYTE att_ren)
{
   DATWINStruct *q_DW, *z_DW;
   char **q_tab, **z_tab;
   int ret= 0, status;
   BOOL Tree= 1, Dir_work= 0, nachfragen= 0;
   BYTE mark= EINZELN;
   void *arg_ptr[ 4];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     RADIOBUTTON| FRAME| KEY,             30,  48, ALLE,    'l',
		     RADIOBUTTON| FRAME| KEY,             30,  67, EINZELN, 'j',
		     CHECKBOX|    FRAME| KEY,             24,  80, 'v',
		     CHECKBOX|    FRAME| KEY,             24,  99, 'e',
		     BUTTON|      FRAME| KEY| DEFBUTTON, 227, 296,  51, 103, RETURN,
		     BUTTON|      FRAME| KEY,            303, 372,  51, 103, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 393, 136, 8, INIT, NULL, AUS};

   if( Quelle== LEFT)
   {
      q_DW= l_DW;
      z_DW= r_DW;
      q_tab= path_tab_ptr_l;
      z_tab= path_tab_ptr_r;
   }
   else
   {
      q_DW= r_DW;
      z_DW= l_DW;
      q_tab= path_tab_ptr_r;
      z_tab= path_tab_ptr_l;
   }
   if( q_DW->anz_mark== 0)
   {
      if( att_ren== VE_ATTRIBUTE)
	 Hinweis( "No file(s) selected for changing attributes   ");
      else
	 Hinweis( "No file(s) selected for renaming       ");
   }
   else
   {
      for( status= 0; status< q_DW->RB->max; status++)
      {
	 if( *q_DW->dir_entrys[ status]== ANGEWAEHLT)
	 {
	    if( strncmp( q_DW->dir_entrys[ status]+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1)== 0)
	       nachfragen= 1;
	    break;
	 }
      }
      if(( q_DW->anz_mark> 1)|| nachfragen)
      {
	 arg_ptr[ 0]= arg_ptr[ 1]= &mark;
	 arg_ptr[ 2]= &Tree;
	 arg_ptr[ 3]= &Dir_work;
	 MS.x= &X_att_ren_vorein;
	 MS.y= &Y_att_ren_vorein;
	 MS.mauspos= mauspos;
	 MS.arg_ptr= arg_ptr;
	 PCX_Window( MS.x, MS.y, ( att_ren== VE_ATTRIBUTE) ? PCX_ATTRIBUTE_VOREINSTELLUNG : PCX_RENAME_VOREINSTELLUNG, &MS.sa, SHADOW);
	 do
	 {
	    switch( status= __CheckMousepos( &MS))
	    {
	       case 0:                                                  /* ESC */
	       case 6:                                              /* Abbruch */
	       case 5:                                                   /* OK */
		  ShowMouse( AUS);
		  BigScreenRestore( &MS.sa, *MS.x, *MS.y);
		  ShowMouse( AN);
		  if( status== 5)
		     _Attribute_Rename_gesammt( d_MS, q_DW, z_DW, q_tab, z_tab, Tree, Dir_work, mark, att_ren);
		  ret= 1;
		  break;
	    }
	 }while( !ret);
      }
      else
	 _Attribute_Rename_gesammt( d_MS, q_DW, z_DW, q_tab, z_tab, 0, 0, EINZELN, att_ren);
   }
}

void _Attribute( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   _Attribute_Rename_Voreinstellung( d_MS, l_DW, r_DW, path_tab_ptr_l, path_tab_ptr_r, Quelle, VE_ATTRIBUTE);
}

void _Rename( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   _Attribute_Rename_Voreinstellung( d_MS, l_DW, r_DW, path_tab_ptr_l, path_tab_ptr_r, Quelle, VE_RENAME);
}

typedef struct ftime ftime;

#define _ARCHIV                      ( *( BYTE *)t_arg_ptr[ 0])
#define _HIDDEN                      ( *( BYTE *)t_arg_ptr[ 1])
#define _RDONLY                      ( *( BYTE *)t_arg_ptr[ 2])
#define _SYSTEM                      ( *( BYTE *)t_arg_ptr[ 3])

#pragma warn -dup /* WARNUNG: 'Redefinition of 'macro' is not identical' unterdrcken */

#define _TMP_ARRAY                      ( char *)t_arg_ptr[ 4]

#pragma warn +dup /* WARNUNG: 'Redefinition of 'macro' is not identical' erlauben */

#define _DIR_WORK                    ( *( BOOL *)t_arg_ptr[ 5])
#define _MSG                            ( char *)t_arg_ptr[ 6]
#define _ZEIT                        ( *( BOOL *)t_arg_ptr[ 7])

#define _ATTRIBUT                    ( *( BOOL *)t_arg_ptr[ 8])
#define _DATE_TIME                    (( ftime *)t_arg_ptr[ 9])

#define _NEW_PATH                       ( char *)t_arg_ptr[ 8]
#define _TMP_2                          ( char *)t_arg_ptr[ 9]

#define _ATTRIB                         ( BYTE *)t_arg_ptr[ 10]
#define _EINZELN_ALLE                ( *( BYTE *)t_arg_ptr[ 11])
#define _REN_FILTER          ( char *)(( void **)t_arg_ptr[ 12])[ 0]
#define _ATT_REN                     ( *( BYTE *)t_arg_ptr[ 14])
#define _FFBLK                        (( ffblk *)t_arg_ptr[ 15])

#define _TAG                       ( *( unsigned *)arg_ptr[  1])
#define _MONAT                     ( *( unsigned *)arg_ptr[  3])
#define _JAHR                      ( *( unsigned *)arg_ptr[  5])
#define _STUNDE                    ( *( unsigned *)arg_ptr[  7])
#define _MINUTE                    ( *( unsigned *)arg_ptr[  9])
#define _SEKUNDE                   ( *( unsigned *)arg_ptr[ 11])

int _Attribute_Einzeln( char *pfad, int *attribut, void **t_arg_ptr, void **arg_ptr, MAUSStruct *MS)
{
   BOOL work= 0;
   int status= 0, i= 0;

   if( *attribut!= -1)
   {
      _ARCHIV= (( *attribut& FA_ARCH)!= 0);
      _HIDDEN= (( *attribut& FA_HIDDEN)!= 0);
      _RDONLY= (( *attribut& FA_RDONLY)!= 0);
      _SYSTEM= (( *attribut& FA_SYSTEM)!= 0);
      if( findfirst( pfad, _FFBLK, *attribut)== 0)
      {
	 _SEKUNDE= ( _FFBLK->ff_ftime& 0x1F)* 2;
	 _MINUTE = ( _FFBLK->ff_ftime& 0x07E0)>> 5;
	 _STUNDE = ( _FFBLK->ff_ftime& 0xF800)>> 11;
	 _TAG    =   _FFBLK->ff_fdate& 0x001F;
	 _MONAT  = ( _FFBLK->ff_fdate& 0x01E0)>> 5;
	 _JAHR   = (( _FFBLK->ff_fdate& 0xFE00)>> 9)+ 1980;

	 work= 1;
	 setcolor( datcolor);
	 ShowMouse( AUS);
	 ClearTextN( *MS->x+ 25, *MS->y+ 244, 46);
	 outtextxy(  *MS->x+ 25, *MS->y+ 244, MakeShowPath( pfad, _TMP_ARRAY, 46));
	 ShowMouse( AN);
	 do
	 {
	    switch( __CheckMousepos( MS))
	    {
	       case 11:                             /* OK */
		  _DATE_TIME->ft_tsec = _SEKUNDE/ 2;
		  _DATE_TIME->ft_min  = _MINUTE;
		  _DATE_TIME->ft_hour = _STUNDE;
		  _DATE_TIME->ft_day  = _TAG;
		  _DATE_TIME->ft_month= _MONAT;
		  _DATE_TIME->ft_year = _JAHR- 1980;
		  status= 1;
	       case 0:
	       case 12:
		  i= 1;
		  break;
	    }
	 }while( !i);
	 MS->statsp= REINIT;
      }
   }
   if( !work)
      ErrorMsg( "Error reading attributes/creation time");
   if( !work|| !status)
      return( 1);
   return( 0);
}

int _Rename_Einzeln( char *pfad, void **t_arg_ptr, MAUSStruct *MS)
{
   char tmp_array[ 35];

   setcolor( datcolor);
   ShowMouse( AUS);
   ClearTextN( *MS->x+ 29, *MS->y+ 52, 12);
   outtextxy(  *MS->x+ 29, *MS->y+ 52, Get_Filter( _REN_FILTER, pfad));
   ClearTextN( *MS->x+ 22, *MS->y+ 97, 33);
   outtextxy(  *MS->x+ 22, *MS->y+ 97, MakeShowPath( Path_to_Dir( _MSG, pfad), tmp_array, 33));
   ShowMouse( AN);
   if( MS->statsp!= INIT)
      MS->statsp= REINIT;
   while( TRUE)
   {
      switch( __CheckMousepos( MS))
      {
	 case 2:                             /* OK */
	    return( 0);
	 case 0:
	 case 3:
	    return( 1);
      }
   }
}

int _Attrib_Rename_Tree( void **t_arg_ptr, ffblk *ffblk_ptr)
{
   BOOL work= 0;
   int i, _cd;

   if(( Get_Call_mode()== FILE_SEARCH)|| _DIR_WORK)
   {
      getcwd( _TMP_ARRAY, MAXDIR);
      if( Get_Call_mode()== FILE_SEARCH)
	 Paste_Filter_to_Dir( _TMP_ARRAY, ffblk_ptr->ff_name);
      if( _ATT_REN== VE_ATTRIBUTE)
      {
	 if( _EINZELN_ALLE== EINZELN)
	 {
	    i= ffblk_ptr->ff_attrib;
	    MouseArt( maus_pfeil);
	    if( _Attribute_Einzeln( _TMP_ARRAY, &i, t_arg_ptr, ( void **)t_arg_ptr[ 12], ( MAUSStruct *)t_arg_ptr[ 13]))
	       return( -1);
	    MouseArt( maus_sanduhr);
	    ffblk_ptr->ff_attrib= i;
	 }
	 if( _ZEIT&& !( ffblk_ptr->ff_attrib& FA_DIREC))
	 {
	    if(( i= _open( _TMP_ARRAY, O_RDONLY))!= -1)
	    {
	       if( setftime( i, _DATE_TIME)== 0)
		  work= 1;
	       _close( i);
	    }
	    if( !work)
	    {
	       sprintf( _MSG, "Time of '%s' could not be changed", ffblk_ptr->ff_name);
	       ErrorMsg( _MSG);
	    }
	 }
	 if( _ATTRIBUT)
	 {
	    ( ffblk_ptr->ff_attrib)&= ~FA_DIREC;
	    for( i= 0; i< 4; i++)
	    {
	       if( *( BYTE *)t_arg_ptr[ i]== SETZEN)
		  ( ffblk_ptr->ff_attrib)|= *( _ATTRIB+ i);
	       if( *( BYTE *)t_arg_ptr[ i]== LOESCHEN)
		  ( ffblk_ptr->ff_attrib)&= ~*( _ATTRIB+ i);
	    }
	    if( _chmod( _TMP_ARRAY, 1, ffblk_ptr->ff_attrib)== -1)
	    {
	       sprintf( _MSG, "Attributes of '%s' could not be changed", ffblk_ptr->ff_name);
	       ErrorMsg( _MSG);
	    }
	 }
      }
      else
      {
	 if( _EINZELN_ALLE== EINZELN)
	 {
	    MouseArt( maus_pfeil);
	    if( _Rename_Einzeln( _TMP_ARRAY, t_arg_ptr, ( MAUSStruct *)t_arg_ptr[ 13]))
	       return( -1);
	    MouseArt( maus_sanduhr);
	 }
	 _Filter( strrchr( strcpy( _NEW_PATH, _TMP_ARRAY), '\\')+ 1, _REN_FILTER, RENAME);
	 i= 0;
	 if( stricmp( _TMP_ARRAY, _NEW_PATH))
	 {
	    work= 1;
	    if( access( _NEW_PATH, 0)== 0)
	    {
	       sprintf( _MSG, "%s\nalready exists.\nShould it be\nreplaced?", MakeShowPath( _NEW_PATH, _TMP_2, 22));
	       switch( Info_Frage( 230, 250, _MSG, FRAGE))
	       {
		  case 0:                                             /* ja */
		     if( _chmod( _NEW_PATH, 0)& FA_RDONLY)
		     {
			sprintf( _MSG, "%s\nis write protected.\nReplace anyway?", _TMP_2);
			switch( Info_Frage( 250, 275, _MSG, FRAGE))
			{
			   case 0:                                    /* ja */
			      chmod( _NEW_PATH, S_IWRITE);
			      break;
			   case 1:                                  /* nein */
			      work= 0;
			      break;
			   case 2:                          /* ESC, Abbruch */
			      return( -1);
			}
		     }
		     if( work)
			unlink( _NEW_PATH);
		     break;
		  case 1:                                           /* nein */
		     work= 0;
		     break;
		  case 2:                                   /* ESC, Abbruch */
		     return( -1);
	       }
	    }
	    if( work)
	    {
	       if( ffblk_ptr->ff_attrib& FA_DIREC)
		  _cd= chdir( "..");
	       i= rename( _TMP_ARRAY, _NEW_PATH);
	       if(( ffblk_ptr->ff_attrib& FA_DIREC)&& ( _cd== 0))
		  chdir( Get_Filter( _MSG, _NEW_PATH));

	    }
	 }
	 if( i)
	 {
	    sprintf( _MSG, "'%s' could not be renamed", ffblk_ptr->ff_name);
	    ErrorMsg( _MSG);
	 }
      }
   }
   return( 0);
}

int _Attribute_Rename_gesammt( MAUSStruct *d_MS, DATWINStruct *q_DW, DATWINStruct *z_DW, char **q_tab, char **z_tab, BOOL Tree, BOOL Dir_work, BYTE einzeln_alle, BYTE att_ren)
{
   struct ftime ft;
   struct ffblk ffblk;
   struct dostime_t t;
   struct dosdate_t d;
   char tmp_array[ MAXPATH], q_dir[ MAXDIR], pfad[ MAXPATH], msg[ 80], new_path[ MAXPATH], ren_filter[ 13]= "", tmp_2[ 25];
   int status, ret= 0, anz_bearb= 0, l, i, attribut, attribut_sp, Art;
   unsigned stunde, minute, sekunde, tag, monat, jahr;
   BOOL Zeit= 0, Attribut= 0, work;
   BYTE Archiv= UNVERAENDERT, Hidden= UNVERAENDERT, RD_only= UNVERAENDERT, System= UNVERAENDERT,
	attrib[]= { FA_ARCH, FA_HIDDEN, FA_RDONLY, FA_SYSTEM};
   void *arg_ptr[ 26], *t_arg_ptr[ 16];
   WORD att_a_mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
			   LAUFLEISTE|  FRAME| KEY,             25,  51, 202,    1,   31,   1, CURSOR_LEFT, CURSOR_RIGHT,
			   LAUFLEISTE|  FRAME| KEY,             25,  79, 202,    1,   12,   1, 'e', 'r',
			   LAUFLEISTE|  FRAME| KEY,             25, 107, 202, 1980, 1999,   1, 'd', 'f',
			   LAUFLEISTE|  FRAME| KEY,             25, 135, 202,    0,   23,   1, 't', 'z',
			   LAUFLEISTE|  FRAME| KEY,             25, 163, 202,    0,   59,   1, 'g', 'h',
			   LAUFLEISTE|  FRAME| KEY,             25, 191, 202,    0,   59,   1, 'b', 'n',
			   RADIOBUTTON| FRAME,                 271,  77, SETZEN,
			   RADIOBUTTON| FRAME,                 271,  96, UNVERAENDERT,
			   RADIOBUTTON| FRAME,                 271, 115, LOESCHEN,
			   RADIOBUTTON| FRAME,                 383,  77, SETZEN,
			   RADIOBUTTON| FRAME,                 383,  96, UNVERAENDERT,
			   RADIOBUTTON| FRAME,                 383, 115, LOESCHEN,
			   RADIOBUTTON| FRAME,                 271, 158, SETZEN,
			   RADIOBUTTON| FRAME,                 271, 177, UNVERAENDERT,
			   RADIOBUTTON| FRAME,                 271, 196, LOESCHEN,
			   RADIOBUTTON| FRAME,                 383, 158, SETZEN,
			   RADIOBUTTON| FRAME,                 383, 177, UNVERAENDERT,
			   RADIOBUTTON| FRAME,                 383, 196, LOESCHEN,
			   CHECKBOX|    FRAME| KEY,               25, 238, 's',
			   CHECKBOX|    FRAME| KEY,               25, 257, 'i',
			   BUTTON|      FRAME| KEY| DEFBUTTON, 294, 363, 226, 278, RETURN,
			   BUTTON|      FRAME| KEY,            370, 439, 226, 278, 'a',
			   MOVEWINDOW };
   WORD att_e_mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
			   LAUFLEISTE|  FRAME| KEY,             25,  51, 202,    1,   31,   1, CURSOR_LEFT, CURSOR_RIGHT,
			   LAUFLEISTE|  FRAME| KEY,             25,  79, 202,    1,   12,   1, 'e', 'r',
			   LAUFLEISTE|  FRAME| KEY,             25, 107, 202, 1980, 1999,   1, 'd', 'f',
			   LAUFLEISTE|  FRAME| KEY,             25, 135, 202,    0,   23,   1, 't', 'z',
			   LAUFLEISTE|  FRAME| KEY,             25, 163, 202,    0,   59,   1, 'g', 'h',
			   LAUFLEISTE|  FRAME| KEY,             25, 191, 202,    0,   59,   1, 'b', 'n',
			   CHECKBOX|    FRAME| KEY,              262,  52, 'v',
			   CHECKBOX|    FRAME| KEY,              262,  71, 'u',
			   CHECKBOX|    FRAME| KEY,              262,  90, 'l',
			   CHECKBOX|    FRAME| KEY,              262, 109, 'm',
			   BUTTON|      FRAME| KEY| DEFBUTTON, 256, 325, 158, 210, RETURN,
			   BUTTON|      FRAME| KEY,            332, 401, 158, 210, 'a',
			   MOVEWINDOW };
   WORD ren_a_mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
			   INPUT|       FRAME| KEY| DEFBUTTON,  28, 126, 142,  12, 'f',
			   BUTTON|      FRAME| KEY,             18, 150, 172, 197, RETURN,
			   BUTTON|      FRAME| KEY,            160, 291, 172, 197, 'a',
			   MOVEWINDOW };
   WORD ren_e_mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
			   INPUT|       FRAME| KEY| DEFBUTTON, 148,  52, 142,  12, 'n',
			   BUTTON|      FRAME| KEY,             18, 150, 132, 157, RETURN,
			   BUTTON|      FRAME| KEY,            160, 291, 132, 157, 'a',
			   MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT, INIT, NULL, AUS};

   MS.arg_ptr= arg_ptr;
   if( att_ren== VE_ATTRIBUTE)
   {
      ( char *)arg_ptr[  0]= "%d Days";
      arg_ptr[  1]= &tag;
      ( char *)arg_ptr[  2]= "%d Months";
      arg_ptr[  3]= &monat;
      ( char *)arg_ptr[  4]= "%d Years";
      arg_ptr[  5]= &jahr;
      ( char *)arg_ptr[  6]= "%d Hours  ";
      arg_ptr[  7]= &stunde;
      ( char *)arg_ptr[  8]= "%d Minutes";
      arg_ptr[  9]= &minute;
      ( char *)arg_ptr[ 10]= "%d Seconds ";
      arg_ptr[ 11]= &sekunde;
      if( einzeln_alle== ALLE)
      {
	 arg_ptr[ 12]= arg_ptr[ 13]= arg_ptr[ 14]= &Archiv;
	 arg_ptr[ 15]= arg_ptr[ 16]= arg_ptr[ 17]= &Hidden;
	 arg_ptr[ 18]= arg_ptr[ 19]= arg_ptr[ 20]= &RD_only;
	 arg_ptr[ 21]= arg_ptr[ 22]= arg_ptr[ 23]= &System;
	 arg_ptr[ 24]= &Zeit;
	 arg_ptr[ 25]= &Attribut;
	 MS.x= &X_attribute;
	 MS.y= &Y_attribute;
	 MS.xlength= 505;
	 MS.ylength= 296;
	 MS.spotanz= 24;
	 MS.mauspos= att_a_mauspos;
	 PCX_Window( MS.x, MS.y, PCX_ATTRIBUTE, &MS.sa, SHADOW);
      }
      else
      {
	 Zeit= 1;
	 Attribut= 1;
	 arg_ptr[ 12]= &Archiv;
	 arg_ptr[ 13]= &Hidden;
	 arg_ptr[ 14]= &RD_only;
	 arg_ptr[ 15]= &System;
	 MS.x= &X_attribute_einzeln;
	 MS.y= &Y_attribute_einzeln;
	 MS.xlength= 427;
	 MS.ylength= 275;
	 MS.spotanz= 14;
	 MS.mauspos= att_e_mauspos;
	 PCX_Window( MS.x, MS.y, PCX_ATTRIBUTE_EINZELN, &MS.sa, SHADOW);
	 goto BEGINN;
      }
      _dos_gettime( &t);
      _dos_getdate( &d);
      stunde = t.hour;
      minute = t.minute;
      sekunde= t.second;
      tag    = d.day;
      monat  = d.month;
      jahr   = d.year;
   }
   else
   {
      arg_ptr[ 0]= ren_filter;
      MS.xlength= 310;
      MS.spotanz= 5;
      if( einzeln_alle== ALLE)
      {
	 MS.x= &X_rename;
	 MS.y= &Y_rename;
	 MS.ylength= 216;
	 MS.mauspos= ren_a_mauspos;
	 PCX_Window( MS.x, MS.y, PCX_RENAME, &MS.sa, SHADOW);
      }
      else
      {
	 MS.x= &X_rename_einzeln;
	 MS.y= &Y_rename_einzeln;
	 MS.ylength= 176;
	 MS.mauspos= ren_e_mauspos;
	 PCX_Window( MS.x, MS.y, PCX_RENAME_EINZELN, &MS.sa, SHADOW);
	 goto BEGINN;
      }
   }
   do
   {
      switch( status= __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	 case 3:                                             /* REN_Abbruch */
	    if( att_ren== VE_ATTRIBUTE)
	       break;
	 case 22:                                            /* ATT_Abbruch */
	    ret= 1;
	    break;
	 case 2:                                                  /* REN_OK */
	    if( att_ren== VE_ATTRIBUTE)
	       break;
	 case 21:                                                 /* ATT_OK */
	    BEGINN:
	    ;
	    Path_to_Dir( q_dir, q_DW->verzeichnis);
	    ft.ft_tsec = sekunde/ 2;
	    ft.ft_min  = minute;
	    ft.ft_hour = stunde;
	    ft.ft_day  = tag;
	    ft.ft_month= monat;
	    ft.ft_year = jahr- 1980;
	    t_arg_ptr[ 0]= &Archiv;
	    t_arg_ptr[ 1]= &Hidden;
	    t_arg_ptr[ 2]= &RD_only;
	    t_arg_ptr[ 3]= &System;
	    t_arg_ptr[ 4]= tmp_array;
	    t_arg_ptr[ 5]= &Dir_work;
	    t_arg_ptr[ 6]= msg;
	    t_arg_ptr[ 7]= &Zeit;
	    if( att_ren== VE_ATTRIBUTE)
	    {
	       t_arg_ptr[ 8]= &Attribut;
	       t_arg_ptr[ 9]= &ft;
	    }
	    else
	    {
	       t_arg_ptr[ 8]= new_path;
	       t_arg_ptr[ 9]= tmp_2;
	    }
	    t_arg_ptr[ 10]= attrib;
	    t_arg_ptr[ 11]= &einzeln_alle;
	    t_arg_ptr[ 12]= arg_ptr;
	    t_arg_ptr[ 13]= &MS;
	    t_arg_ptr[ 14]= &att_ren;
	    t_arg_ptr[ 15]= &ffblk;
	    for( l= 0; ( l< q_DW->RB->max); l++)
	    {
	       if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
	       {
		  if( Break( 250, 275, "Really end the\ncurrent process?"))
		     break;
		  if((( Art= MakePfad( q_dir, pfad, q_DW->dir_entrys, l))== DIR)&& Tree)
		  {
		     switch( status= TREE_Funktion( pfad, "*.*", _Attrib_Rename_Tree, t_arg_ptr, DIR_SEARCH_VOR| FILE_SEARCH))
		     {
			case -3:
			case -4:
			   ErrorMsg( "Error changing directory");
			   break;
		     }
		     if(( att_ren== VE_RENAME)&& Dir_work)
			newbaum[ toupper( *q_DW->verzeichnis)- 'A']= 1;
		     q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
		     anz_bearb++;
		     if(( status== -2)|| ( status== -1))           /* Break */
			break;
		  }
		  else
		  {
		     if(( Art!= DIR)|| Dir_work)
		     {
			if( att_ren== VE_ATTRIBUTE)
			{
			   if( einzeln_alle== EINZELN)
			   {
			      attribut= _chmod( pfad, 0);
			      if( _Attribute_Einzeln( pfad, &attribut, t_arg_ptr, arg_ptr, &MS))
				 break;
			   }
			   if( Zeit&& ( Art!= DIR))
			   {
			      work= 0;
			      if(( i= _open( pfad, O_RDONLY))!= -1)
			      {
				 if( setftime( i, &ft)== 0)
				    work= 1;
				 _close( i);
			      }
			      if( work)
			      {
				 q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
				 anz_bearb++;
			      }
			      else
			      {
				 sprintf( msg, "Time of '%s' could not be changed", strrchr( pfad, '\\')+ 1);
				 ErrorMsg( msg);
			      }
			   }
			   if( Attribut)
			   {
			      work= 0;
			      if( einzeln_alle== ALLE)
				 attribut= _chmod( pfad, 0);
			      if( attribut!= -1)
			      {
				 attribut&= ~FA_DIREC;
				 for( i= 0; i< 4; i++)
				 {
				    if( *( BYTE *)t_arg_ptr[ i]== SETZEN)
				       attribut|= attrib[ i];
				    if( *( BYTE *)t_arg_ptr[ i]== LOESCHEN)
				       attribut&= ~attrib[ i];
				 }
				 if( _chmod( pfad, 1, attribut)!= -1)
				    work= 1;
			      }
			      if( work)
			      {
				 q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
				 anz_bearb++;
			      }
			      else
			      {
				 sprintf( msg, "Attributes of '%s' could not be changed", strrchr( pfad, '\\')+ 1);
				 ErrorMsg( msg);
			      }
			   }
			}
			else
			{
			   if( einzeln_alle== EINZELN)
			   {
			      if( _Rename_Einzeln( pfad, t_arg_ptr, &MS))
				 break;
			   }
			   if(( Art!= DIR)|| Dir_work)
			   {
			      _Filter( strrchr( strcpy( new_path, pfad), '\\')+ 1, ren_filter, RENAME);
			      status= 0;
			      if( stricmp( pfad, new_path))
			      {
				 work= 1;
				 if( access( new_path, 0)== 0)
				 {
				    sprintf( msg, "%s\nexists already.\nShould it be\nreplaced?", MakeShowPath( new_path, tmp_2, 22));
				    switch( Info_Frage( 230, 250, msg, FRAGE))
				    {
				       case 0:                        /* ja */
					  if( _chmod( new_path, 0)& FA_RDONLY)
					  {
					     sprintf( msg, "%s\nis write protected.\nReplace anyway?", tmp_2);
					     switch( Info_Frage( 250, 275, msg, FRAGE))
					     {
						case 0:               /* ja */
						   chmod( new_path, S_IWRITE);
						   break;
						case 2:     /* ESC, Abbruch */
						   status= 1;
						case 1:             /* nein */
						   work= 0;
						   break;
					     }
					  }
					  if( work)
					     unlink( new_path);
					  break;
				       case 2:              /* ESC, Abbruch */
					  status= 1;
				       case 1:                      /* nein */
					  work= 0;
					  break;
				    }
				    if( status== 1)
				       break;
				 }
				 if( work)
				 {
				    status= rename( pfad, new_path);
				    if( Art== DIR)
				       newbaum[ toupper( *q_DW->verzeichnis)- 'A']= 1;
				 }
			      }
			      if( status== 0)
			      {
				 q_DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
				 anz_bearb++;
			      }
			      else
			      {
				 sprintf( msg, "'%s' could not be renamed", strrchr( pfad, '\\')+ 1);
				 ErrorMsg( msg);
			      }
			   }
			}
		     }
		  }
	       }
	    }
	    ret= 1;
	    break;
	 default:
	    if( att_ren== VE_ATTRIBUTE)
	    {
	       if(( status>= 1)&& ( status<= 6))
	       {
		  Zeit= 1;
		  MS.statsp= REINIT;
	       }
	       if(( status>= 7)&& ( status<= 18))
	       {
		  Attribut= 1;
		  MS.statsp= REINIT;
	       }
	    }
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( anz_bearb> 0)
   {
      LoescheVar( d_MS, q_DW, q_tab);
      LoescheVar( d_MS, z_DW, z_tab);
   }
   return( anz_bearb);
}
