/*  FILE_WIN.C  Separate file browser
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <io.h>
#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <direct.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define GROSS                 1

#define YREF_DATEIAUSWFENSTER 100

#define UNSICHTBAR            2
#define NOREVERSE             0
#define MAX_PATH_TAB_ENTRY    5
#define DIRBEZEICHNUNGS_POS   14
#define FILEEXT_POS           10
#define MAX_PATH_TAB_ENTRY    5

#define NICHT_BEARBEITEN      '@'
#define ABGEWAEHLT            0
#define ANGEWAEHLT            1
#define GELOESCHT             2
#define NEU_DAZU              3

extern void BalkenShow_L( int, int, int, char);
extern char *Paste_Filter_to_Dir( char *, char *);
extern char *Path_to_Dir( char *, char *);

extern view_filter_struct l_DATWIN_VF;

int LwBox_Exec( char *ret_path, DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[], int status)
{
   char filter_sp[ DW_MAXFILTER], name[ 13];

   if( AnztoDatei( DW, name, status)== DIR)
   {
      Get_Filter( filter_sp, DW->verzeichnis);
      Path_to_Dir( DW->verzeichnis, DW->verzeichnis);
      Paste_Filter_to_Dir( DW->verzeichnis, name);
      Paste_Filter_to_Dir( DW->verzeichnis, filter_sp);
      LoescheVar( MS, DW, path_tab_ptr);
   }
   else
   {
      if( *DW->dir_entrys[ status]!= NICHT_BEARBEITEN)
      {
	 Paste_Filter_to_Dir( Path_to_Dir( ret_path, DW->verzeichnis), name);
	 return( 0);
      }
   }
   return( 1);
}

int LwBox( int *X, int *Y, int LW, char *filter, char *ret_path)  /* DEFAULT, 'A', 'B', ... */
{
   RBalken RB= { 359, 87, 342, VERT_DIR, 1, 16, 0L};
   DATWINStruct DW= { DEFAULT, DEFAULT, 0, 0L, GROSS, SORT_FILE, -1, DW_BEWEGLICH, ""};
   int ret= 0, i, status, LW_x= 100, LW_y= 300, Baum_X= 300, X_sort= 200, Y_sort= 150;
   char typ,
	Path_Table[ MAX_PATH_TAB_ENTRY][ MAXDIR+ DW_MAXFILTER]= { "", "", "", "", ""},
	*Table_ptr[ MAX_PATH_TAB_ENTRY], path[ MAXDIR+ DW_MAXFILTER];
   BOOL View_sp= l_DATWIN_VF.aktiv;
   void *arg_ptr[ 3];
   char *msg[]= { "Adjust path for the file window       ",
		  "Select new drive for the file window         ",
		  "Display the drive's main directory (root directory)              ",
		  "Show the drive's parent directory (DOS command CD..)     ",
		  "Display the drive's directory tree and possibly select directory    ",
		  "Adjust sort criterion for the file window      ",
		  "Search for file (mask) on drive shown in file window    ",
		  "Select part of the file window to be viewed   ",
		  "Select file or change directory      " };
   WORD mauspos[]= { BUTTON|           FRAME| KEY,                   5,  27,   5,  21, ESC,
		     FILE_INPUT_TABLE| IGN_CASE| FRAME| KEY|       MSG,  12,  42, 368, MAXDIR+ DW_MAXFILTER- 2, MAX_PATH_TAB_ENTRY, 's',
		     BUTTON3|          FRAME| KEY|       MSG,  12,  73,  61,  83,  F1,
		     BUTTON3|          FRAME| KEY|       MSG,  74, 135,  61,  83,  F2,
		     BUTTON3|          FRAME| KEY|       MSG, 136, 197,  61,  83,  F3,
		     BUTTON3|          FRAME| KEY|       MSG, 198, 257,  61,  83,  F4,
		     BUTTON3|          FRAME| KEY|       MSG, 258, 319,  61,  83,  F5,
		     BUTTON3|          FRAME| KEY|       MSG, 320, 380,  61,  83,  F6,
		     ROLLBALKEN|              KEY|       MSG, CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     DOUBLE_KLICKAREA|                   MSG,  17, 354, 100, 323,
		     KLICKAREA,                                42,  78,  85,  97,
		     KLICKAREA,                               102, 127,  85,  97,
		     KLICKAREA,                               139, 177,  85,  97,
		     KLICKAREA,                               250, 290,  85,  97,
		     KLICKAREA,                               316, 343,  85,  97,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 393, 358, 16, INIT, NULL, AN};

   l_DATWIN_VF.aktiv= AUS;
   if( LW!= DEFAULT)
      LW-= 64;
   DW.verzeichnis= Paste_Filter_to_Dir( _getdcwd( LW, path, MAXDIR), filter);
   strcpy( Path_Table[ 0], DW.verzeichnis);
   for( i= 0; i< MAX_PATH_TAB_ENTRY; i++)
      Table_ptr[ i]= Path_Table[ i];
   arg_ptr[ 0]= Table_ptr;
   arg_ptr[ 1]= DW.RB= &RB;
   ( void (*)())arg_ptr[ 2]= BalkenShow_L;
   DW.X= MS.x= X;
   DW.Y= MS.y= Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_DATEIAUSWAHLBOX, &MS.sa, SHADOW);
   if( Read_DirEntrys( &DW)== FATAL_MEMORY)
      ExitMsg( MEMORY_EXIT);
   DirEntry( &DW);
   ShowSortFrame( &DW, &MS, 10, 10+ DW.Sort_Typ, AN);
   do
   {
      switch( status= __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	    ret= 2;
	    break;
	 case 1:                                      /* kompletter Suchweg */
	    newPath_Enter( &DW, &MS, Table_ptr);
	    break;
	 case 2:                                        /* Laufwerksauswahl */
	    newLW( &LW_x, &LW_y, &DW, &MS, Table_ptr);
	    break;
	 case 3:                                                     /* CD\ */
	    Root( &DW, &MS, Table_ptr);
	    break;
	 case 4:                                                    /* CD.. */
	    VaterVerzeichnis( &DW, &MS, Table_ptr);
	    break;
	 case 5:                                         /* Verzeichnisbaum */
	    Tree( &Baum_X, &DW, &MS, Table_ptr);
	    break;
	 case 6:                                        /* Sortierkriterium */
	    if( Sort_Krit( &X_sort, &Y_sort, &DW, &typ))
	       SortFrame( &DW, &MS, 10, 10+ typ);
	    break;
	 case 7:                                            /* Datei suchen */
	    _FindFile( &DW, &MS, Table_ptr);
	    break;
	 case 8:                                              /* Rollbalken */
	    switch( RB.ret_val)
	    {
	       case ONE_ELEMENT_UP:
		  Dir_Up_Down( &DW, DOWN, !NOREVERSE);
		  break;
	       case ONE_ELEMENT_DOWN:
		  Dir_Up_Down( &DW, UP, !NOREVERSE);
		  break;
	       case ELEMENT_RANDOM:
		  DirEntry( &DW);
		  break;
	       case POINTER_RETURN:
		  if( !LwBox_Exec( ret_path, &DW, &MS, Table_ptr, DW.RB->Zeiger_pos))
		     ret= 1;
		  break;
	    }
	    break;
	 case 9:
	    status= ( MStat.y- ( *DW.Y+ YREF_DATEIAUSWFENSTER))/ 14;
	    if(( status>= 0)&& ( status< ( DW.RB->max- DW.RB->proz)))
	    {
	       if( !LwBox_Exec( ret_path, &DW, &MS, Table_ptr, status))
		  ret= 1;
	    }
	    break;
	 case 10:
	 case 11:
	 case 12:
	 case 13:
	 case 14:
	    SortFrame( &DW, &MS, 10, status);
	    break;
      }
   }while( !ret);
   FreeArray( &DW);
   l_DATWIN_VF.aktiv= View_sp;
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( --ret);                                       /* 0= O.K., 1= ESC */
}
