/*  MAIN.C  Program entry point
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define NDEBUG        /* Prprozessor entfernt smtliche Aufrufe von assert */
#include <assert.h>

#include <dos.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <sys\stat.h>
#include <alloc.h>
#include <fcntl.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>
#include <errno.h>
#include "pal_op.h"
#include "mouse_op.h"
#include "defines.h"
#include "xms.h"
#include "msg.h"

#define HGRPFILENAME     "HGRPDSK.DG2"

#define Y_ICON_PUSHAREA  63    /* mu verndert werden, wenn etwas an der mauspos-Struktur des Programmanagers gendert wird */

#define MEMAVAIL         55000L    /* min. Bytes freier Speicher beim Start */
extern unsigned _stklen= 30000U;                         /* Stackdeklaration */

struct REGPACK RP;

WORD *scrbuffer= NULL, Anz_Words, Cursor_Position;

char dmanager_path1[ MAXDIR+ DW_MAXFILTER+ 50], dmanager_path2[ MAXDIR+ DW_MAXFILTER+ 50];

void *GRP_ICO_ptr, *GRP_struct_ptr;      /* Zeiger auf die Daten des GruppenIcons */
void *OwnerButtonICO_ptr;                /* Zeiger auf Daten des AnwButtonIcons */

Alarm_struct Alarmdaten[ MAX_ANZ_ALARME]= { { AUS, "", 0, 0, 1, 1},
					    { AUS, "", 0, 0, 1, 1},
					    { AUS, "", 0, 0, 1, 1} };

char prgexe_path[ MAXPATH], *prgexe_ptr;       /* Verzeichnis des Programms */

char uhrsp= -1, screensp= 0;
BOOL msg_to_Klick= 0, _ShowStatus= 1, globalmaus= 0, install= 0, showclock= 1;

int verschiebenx= 0, verschiebeny= 0;

extern void SCR_move( WORD Xq, WORD Yq, WORD Spalten, WORD Lines, WORD Xz, WORD Yz);
extern char *MakeShowPath( char *, char *, int);
extern WORD Is_Window_EXE( char *file);
extern void far _CritHandler();
extern int BreakHandler();
extern BOOL XMSInit( void);
extern BOOL _Filter( char *file, char *filter, int r_a);
extern int Cpy_ICO_mem( void *Ico_ptr, char *file);
extern BOOL MakeIni( GRP_struct *GRP);
extern BOOL Gruppe( GRP_struct *GRP);
int PMArtofMarkedEntry( GRP_struct *GRP);

void DelAllTmp( void)
{
   int i;
   char *tmp_s[]= { "~DSK##20.BAT",
		    "DB2_EINS.TMP",
		    "~LDM##20.SAV",
		    "~RDM##20.SAV",
		    "~DKO##20.SAV"};

   for( i= 0; i< ( sizeof( tmp_s)/ sizeof( char *)); i++)
      if( ExistDatei( tmp_s[ i]))
	 unlink( prgexe_path);
}

int Is_VGA( void)
{
   union REGS Regs;

   Regs.x.ax= 0x1A00;
   int86( 0x10, &Regs, &Regs);
   if( Regs.h.al== 0x1A)
      return( 0);
   return( -1);
}

unsigned Text_Imagesize( void)
{
   return( ( WORD)( peek( 0x0040, 0x004A)* ( peekb( 0x0040, 0x0084)+ 1))<< 1);
}

void _Get_Text_Screen( void)                                 /* Nur fr VGA */
{
   int i;
   WORD Video_Seg, *ptr_sp;

   Anz_Words= Text_Imagesize();
   Cursor_Position=    peek( 0x0040, 0x0050+ ( peekb( 0x0040, 0x0062)<< 1));
   Video_Seg=  0xB800+ peek( 0x0040, 0x004E);
   if(( ptr_sp= scrbuffer= malloc( Anz_Words))!= NULL)
   {
      for( i= 0; i< Anz_Words; i+= 2)
	 *( ptr_sp++)= peek( Video_Seg, i);
   }
}

void Show_Text_Screen( void)
{
   int i;
   WORD Video_Seg, *ptr_sp= scrbuffer;

   if( scrbuffer!= NULL)
   {
      Video_Seg= 0xB800+ peek( 0x0040, 0x004E);
      for( i= 0; i< Anz_Words; i+= 2)
	 poke( Video_Seg, i, *( ptr_sp++));
   }
}

void _Put_Text_Screen( void)                                 /* Nur fr VGA */
{
   union REGS RG;

   if( scrbuffer!= NULL)
   {
      Show_Text_Screen();
      free( scrbuffer);
      RG.h.ah= 0x02;
      RG.h.bh= peekb( 0x0040, 0x0062);
      RG.h.dh= HI( Cursor_Position);
      RG.h.dl= LO( Cursor_Position);
      int86( VIDEO_INT, &RG, &RG);
   }
}

void GRP_freeResourcen( GRP_struct *GRP)
{
   if( GRP->File_handle> 0)
   {
      close( GRP->File_handle);                    /* alte Gruppe schlieen */
      GRP->File_handle= 0;
   }
   if( GRP->XMS_handle> 0)
   {
      XMSFreeMem( GRP->XMS_handle);                  /* alten XMS freigeben */
      GRP->XMS_handle= 0;
   }
}

void Free_All_Resourcen( void)
{
   ShowMouse( AUS);
   FreeFlexLibrary();
   FreeKommandoRes( FALSE);
   GRP_freeResourcen( GRP_struct_ptr);
   close_resource_ICO( GRP_ICO_ptr);
   _voc_deinstall_driver();
   closegraph();
   _Put_Text_Screen();
}

void ExitMsg( int status)
{
   if(( status!= 255)|| ( SaveSysDial()!= 1))       /* Abbruch */
   {
      Free_All_Resourcen();
      switch( status)
      {
	 case MEMORY_EXIT:
	    puts( "Not enough memory available!\n");
	    break;
	 case 250:
	    puts( "DESKTOP V"DESKTOP_VERSION" only runs on VGA or higher!\n");
	    break;
	 case 0:
	    saveSystem( "DB2_EINS.TMP");
	    exit( 0);
      }
      DelAllTmp();
      exit( 255);
   }
}

void Draw_Tal_Berg( int x1, int y1, int x2, int y2, char t_b)
{
   if( t_b== TAL)
      setcolor( EGA_WHITE);
   else
      setcolor( EGA_DARKGRAY);
   line( x1, y2, x2, y2);
   line( x2, y2, x2, y1);
   if( t_b== TAL)
      setcolor( EGA_DARKGRAY);
   else
      setcolor( EGA_WHITE);
   line( x1, y1, x2, y1);
   line( x1, y1, x1, y2);
}

void DrawTal( int x1, int y1, int x2, int y2)
{
   Draw_Tal_Berg( x1, y1, x2, y2, TAL);
}

void RecRelief( int x1, int y1, int x2, int y2)
{
   Draw_Tal_Berg( x1- 2, y1- 2, x2+ 2, y2+ 2, BERG);
   Draw_Tal_Berg( x1+ 2, y1+ 2, x2- 2, y2- 2, TAL);
}

void OutLineTextxy( int x, int y, char *text, int ausw)
{
   int linex;

   outtextxy( x, y, text);
   if( ausw)
   {
      linex= x+ (( ausw- 1)<< 3)- 1;
      line( linex, y+ 9, linex+ 8, y+ 9);
   }
}

void Fensterschatten( int Xlo, int Ylo, int Xru, int Yru)
{
   setcolor( 0x08);
   setwritemode( XOR_PUT);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   line( Xru+ 2, Ylo+ 3, Xru+ 2, Yru+ 3);
   line( Xlo+ 3, Yru+ 2, Xru   , Yru+ 2);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

void PutPaper( int pap1x, int pap1y, int pap2x, int pap2y, int fillcolor, int balken, int icon, char *text)
{
   int color, textx, lxend;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( pap1x+ 1, pap1y+ 1, pap2x- 1, pap1y+ 3);
   bar( pap1x+ 1, pap1y+ 1, pap1x+ 3, pap2y- 1);
   bar( pap1x+ 1, pap2y- 3, pap2x- 1, pap2y- 1);
   bar( pap2x- 3, pap1y+ 1, pap2x- 1, pap2y- 1);
   setfillstyle( SOLID_FILL, fillcolor);
   bar( pap1x+ 5, pap1y+ 5, pap2x- 5, pap2y- 5);
   setcolor( EGA_DARKGRAY);
   line( pap2x, pap1y, pap2x, pap2y);
   line( pap2x, pap2y, pap1x, pap2y);
   line( pap1x+ 4, pap1y+ 4, pap2x- 4, pap1y+ 4);
   line( pap1x+ 4, pap1y+ 4, pap1x+ 4, pap2y- 4);
   setcolor( EGA_WHITE);
   line( pap1x, pap1y, pap2x, pap1y);
   line( pap1x, pap1y, pap1x, pap2y);
   line( pap2x- 4, pap1y+ 4, pap2x- 4, pap2y- 4);
   line( pap2x- 4, pap2y- 4, pap1x+ 4, pap2y- 4);
   setcolor( EGA_DARKGRAY);
   if( balken== AN)
   {
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      bar( pap1x+ 4, pap1y+ 4, pap2x- 4, pap1y+ 21);
      line( pap1x+ 5, pap1y+ 22, pap2x- 5, pap1y+ 22);
      if( text[ 0]!= '#')
      {
	 textx= ( pap1x+(( pap2x- pap1x)>> 1)- ( strlen( text)<< 2));
	 lxend= textx+( strlen( text)<< 3);
	 setcolor( EGA_DARKGRAY);
	 line( textx- 5, pap1y+ 5, lxend+ 3, pap1y+ 5);
	 line( textx- 5, pap1y+ 5, textx- 5, pap1y+ 18);
	 setcolor( EGA_WHITE);
	 line( textx- 5, pap1y+ 18, lxend+ 3, pap1y+ 18);
	 line( lxend+ 3, pap1y+ 18, lxend+ 3, pap1y+ 5);
	 setcolor( EGA_BLACK);
	 outtextxy( textx, pap1y+ 8, text);
      }
      setcolor( EGA_DARKGRAY);
      if( icon== AN)
      {
	 Button( pap1x+ 4, pap1y+ 4, pap1x+ 24, pap1y+ 19, "", 0);
	 setcolor( EGA_BLACK);
	 putpixel( pap1x+ 12, pap1y+ 9, EGA_BLACK);
	 line( pap1x+ 11, pap1y+ 10, pap1x+ 16, pap1y+ 10);
	 line( pap1x+ 10, pap1y+ 11, pap1x+ 16, pap1y+ 11);
	 line( pap1x+ 11, pap1y+ 12, pap1x+ 16, pap1y+ 12);
	 putpixel( pap1x+ 12, pap1y+ 13, EGA_BLACK);
      }
   }
   Fensterschatten( pap1x, pap1y, pap2x, pap2y);
   setcolor( color);
}

void Clock( void)
{
   int i;
   char uhr[ 6], color;
   struct time t;
   struct date d;
   struct textsettingstype text;

   gettime( &t);
   if( t.ti_min!= uhrsp)
   {
      if( showclock== AN)
      {
	 color= getcolor();
	 setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
	 gettextsettings( &text);
	 settextjustify( CENTER_TEXT, text.vert);
	 sprintf( uhr, "%d.%02d", t.ti_hour, t.ti_min);
	 ShowMouse( AUS);
	 bar( 581, 5, 631, 19);
	 setcolor( EGA_BLACK);
	 outtextxy( 606, 9, uhr);
	 ShowMouse( AN);
	 settextjustify( text.horiz, text.vert);
	 setcolor( color);
      }
      if( uhrsp>= 0)
	 screensp++;
      uhrsp= t.ti_min;
      getdate( &d);
      for( i= 0; i< MAX_ANZ_ALARME; i++)
      {
	 if(( Alarmdaten[ i].alarm== AN)&& ( d.da_day== Alarmdaten[ i].tag)&& ( d.da_mon== Alarmdaten[ i].monat)&& ( t.ti_hour>= Alarmdaten[ i].stunde)&& ( t.ti_min>= Alarmdaten[ i].minute))
	    Alarm( i);
      }
      if( screensp== ssaver_time)
	 ScreenSaver();
   }
}

void LoschTbuf( void)
{
   disable();
   *( int far *)MK_FP( 0x40, 0x1A)= *( int far *)MK_FP( 0x40, 0x1C);
   enable();
}

void ClearTextN( int x, int y, int anz)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x- 1, y- 1, x+ 1+ ( anz<< 3), y+ 8);
}

int Break( int x, int y, char *Msg)
{
   void *old_maus_cursor= last_maus_cursor;
   int Taste= 0;

   if( kbhit()&& (( Taste= getch())!= ESC))
   {
      if( Taste)
	 ungetch( Taste);
      else
	 extended_ungetch( getch());
   }
   if(( MouseStat()!= NOTHING)|| ( Taste== ESC))
   {
      MouseArt( maus_pfeil);
      switch( Info_Frage( x, y, Msg, FRAGE))
      {
	 case 0:                                       /* Vorgang abbrechen */
	    return( -1);
	 case 2:                                            /* ESC, Abbruch */
	    return( 1);
      }
      MouseArt( old_maus_cursor);
   }
   return( 0);
}

void *ptr_to_GRP( GRP_struct *GRP, int *ret_val, BOOL check_for_noentrys)
{
   void *GRP_ptr;

   if( GRP->XMS_handle== 0)    /* Gruppeninhalt wurde nicht im XMS abgelegt */
   {
      if(( GRP->RB->max> 0)|| ( !check_for_noentrys)) /* sind berhaupt Eintrge in der Gruppe */
      {
	 if( lseek( GRP->File_handle, GRP->seek_pos, SEEK_SET)!= -1L) /* Dateizeiger auf ersten Eintrag stellen */
	 {
	    if(( GRP_ptr= malloc( GRP->mem_len))!= NULL)
	    {
	       if( _read( GRP->File_handle, GRP_ptr, GRP->mem_len)!= -1)
	       {
		  if( XMSTreiber)
		  {
		     if(( GRP->XMS_handle= XMSGetMem( ( GRP->mem_len+ 1023L)>> 10))!= 0)
			XMSCopy( 0, ( DWORD)(( void *)GRP_ptr), GRP->XMS_handle, 0L, ( GRP->mem_len+ 1)>> 1);
		  }
		  else
		     GRP->XMS_handle= 0;
	       }
	       else
	       {
		  free( GRP_ptr);
		  ErrorMsg( READ_ERROR": Group file");
		  *ret_val= -1;
	       }
	    }
	    else
	    {
	       ErrorMsg( KEIN_SPEICHER);
	       *ret_val= NOT_MEMORY;
	    }
	 }
	 else
	 {
	    ErrorMsg( READ_ERROR": Group file");
	    *ret_val= -1;
	 }
      }
      else
      {
	 Hinweis( "This group has no entries          ");
	 *ret_val= -1;
      }
   }
   else
   {
      if(( GRP_ptr= malloc( GRP->mem_len))!= NULL)
      {
	 XMSCopy( GRP->XMS_handle, 0L, 0, ( DWORD)(( void *)GRP_ptr), ( GRP->mem_len+ 1)>> 1);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 *ret_val= NOT_MEMORY;
      }
   }
   return( GRP_ptr);
}

typedef struct
	{
	   BOOL ready;
	   char *PRG_name,
		*PRG_path,
		*ICO_path;
	   BYTE workdir_ID,
		GRP_offset;
	}FindPRG_struct;

#define INST_MAXGRUPPEN   17
#define INST_MAXPROGRAMME 50
#define INST_DEFAULT_DIR  0
#define INST_PRG_DIR      1
#define ICO_INTERN        0

typedef struct ffblk ffblk;

#define _TMP_ARRAY              ( char *)arg_ptr[  0]
#define _FIND_PRG   ( ( FindPRG_struct *)arg_ptr[  1])
#define _ANZ_PRG                *( int *)arg_ptr[  2]
#define _FOUND                  *( int *)arg_ptr[  3]

int PRG_tree( void **arg_ptr, ffblk *ffblk_ptr)
{
   int i;

   for( i= 0; i< _ANZ_PRG; i++)
   {
      if( _Filter( ffblk_ptr->ff_name, ( _FIND_PRG[ i]).PRG_path, 0)&& !( _FIND_PRG[ i]).ready)
      {
	 Paste_Filter_to_Dir( getcwd( ( _FIND_PRG[ i]).PRG_path, MAXPATH), ffblk_ptr->ff_name);
	 sprintf( _TMP_ARRAY, "Program '%s' found  ", ( _FIND_PRG[ i]).PRG_name);
	 PrintStatus( _TMP_ARRAY);
	 ( _FIND_PRG[ i]).ready= 1;
	 ( _FOUND)++;
	 break;
      }
   }
   return( 0);
}

int SearchPRG( char lw[], int anzlw, FindPRG_struct *FindPRG, int Anz_PRG, int *Found)
{
   int status, i;
   void *arg_ptr[ 4];
   char tmp_array[ 40];

   arg_ptr[ 0]= tmp_array;
   arg_ptr[ 1]= FindPRG;
   arg_ptr[ 2]= &Anz_PRG;
   arg_ptr[ 3]= Found;
   for( i= 0; i< anzlw; i++)
   {
      if(( status= LW_TREE_Funktion( lw[ i], "*.*", PRG_tree, arg_ptr, FILE_SEARCH))!= 0)
	 break;
   }
   return( status);
}

int Sort_FindPRG( FindPRG_struct **elem1, FindPRG_struct **elem2)
{
   int ret;

   if(( ret= ( *elem2)->ready- ( *elem1)->ready)== 0)
      ret= strcmp( ( *elem1)->PRG_name, ( *elem2)->PRG_name);
   return( ret);
}

int LoadINSTALL_DB2( FindPRG_struct *FindPRG, char *Gruppen[], int *Anz_GRP, int *Anz_PRG)
{
   int ret_val= 0, handle, f_length, i;
   BYTE *mem_ptr, *tmp_ptr;

   if(( handle= _resource_open( DAT_INSTALLATIONSDATEN))!= -1)
   {
      if(( mem_ptr= malloc( f_length= _resource_length( DAT_INSTALLATIONSDATEN)))!= NULL)
      {
	 if( _read( handle, mem_ptr, f_length)!= -1)
	 {
	    *Anz_GRP= *( WORD *)( mem_ptr);
	    *Anz_PRG= *( WORD *)( mem_ptr+ sizeof( WORD));
	    assert( *Anz_GRP<= INST_MAXGRUPPEN);
	    assert( *Anz_PRG<= INST_MAXPROGRAMME);

	    tmp_ptr= mem_ptr+ sizeof( WORD)* 2;

	    for( i= 0; i< *Anz_GRP; i++)
	    {
	       if(( Gruppen[ i]= strdup( tmp_ptr+ 1))== NULL)
	       {
		  for( *Anz_GRP= 0; *Anz_GRP< i; *Anz_GRP++)
		     free( Gruppen[ *Anz_GRP]);
		  ErrorMsg( KEIN_SPEICHER);
		  ret_val= -1;
		  break;
	       }
	       tmp_ptr+= *tmp_ptr;
	    }
	    if( !ret_val)                              /* kein Fehler */
	    {
	       for( i= 0; i< *Anz_PRG; i++)
	       {
		  ( FindPRG+ i)->workdir_ID= *( tmp_ptr+ 2);
		  ( FindPRG+ i)->GRP_offset= *( tmp_ptr+ 3);
		  if((( ( FindPRG+ i)->PRG_name= malloc( GRP_MAXGRUPPENNAME))== NULL)|| (( ( FindPRG+ i)->PRG_path= malloc( MAXPATH))== NULL)|| (( ( FindPRG+ i)->ICO_path= strdup( tmp_ptr+ 7+ *( tmp_ptr+ 4)+ *( tmp_ptr+ 5)))== NULL))
		  {
		     for( *Anz_PRG= 0; *Anz_PRG< i; *Anz_PRG++)
		     {
			if( ( FindPRG+ *Anz_PRG)->PRG_name!= NULL)
			   free( ( FindPRG+ *Anz_PRG)->PRG_name);
			if( ( FindPRG+ *Anz_PRG)->PRG_path!= NULL)
			   free( ( FindPRG+ *Anz_PRG)->PRG_path);
			if( ( FindPRG+ *Anz_PRG)->ICO_path!= NULL)
			   free( ( FindPRG+ *Anz_PRG)->ICO_path);
		     }
		     for( i= 0; i< *Anz_GRP; i++)
			free( Gruppen[ i]);
		     ErrorMsg( KEIN_SPEICHER);
		     ret_val= -1;
		     break;
		  }
		  else
		  {
		     strcpy( ( FindPRG+ i)->PRG_name, tmp_ptr+ 7);
		     strcpy( ( FindPRG+ i)->PRG_path, tmp_ptr+ 7+ *( tmp_ptr+ 4));
		  }
		  tmp_ptr+= *( WORD *)tmp_ptr;
	       }
	    }
	 }
	 else
	 {
	    ErrorMsg( READ_ERROR"INSTALL.DB2");
	    ret_val= -1;
	 }
	 free( mem_ptr);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 ret_val= -1;
      }
      _dos_close( handle);
   }
   else
   {
      ErrorMsg( OPEN_ERROR"RESOURCE.DB2");
      ret_val= -1;
   }
   return( ret_val);                                 /* 0= O.K., -1= Fehler */
}

void Anwendungen_Balken( int X, int Y, int Zeiger_pos, char an_aus)
{
   int y;

   y= Y+ 55+ ( Zeiger_pos* 14);
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   if( an_aus== AN)
      setcolor( datcolor);
   else
      setcolor( EGA_LIGHTGRAY);
   ShowMouse( AUS);
   rectangle( X+ 45, y, X+ 177, y+ 12);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
}

void PRGAusw_Up_Down( int X, int Y, FindPRG_struct **FindPRG, RBalken *RB, char Richtung)
{
   ShowMouse( AUS);
   if( Richtung== UP)
   {
      ScrollUpWindow( X+ 39, Y+ 65, X+ 181, Y+ 211, 14);
      setcolor( datcolor);
      outtextxy( X+ 48, Y+ 198, ( *( FindPRG+ RB->proz+ 10L))->PRG_name);
   }
   else
   {
      ScrollDownWindow( X+ 39, Y+ 51, X+ 181, Y+ 197, 14);
      setcolor( datcolor);
      outtextxy( X+ 48, Y+ 58, ( *( FindPRG+ RB->proz))->PRG_name);
   }
   ShowMouse( AN);
}

void PRGAuswEntry( int X, int Y, FindPRG_struct **FindPRG, RBalken *RB)
{
   int ypos, i;

   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( X+ 39, Y+ 51, X+ 181, Y+ 211);
   setcolor( datcolor);
   for( i= RB->proz, ypos= Y+ 58; ( i< ( RB->proz+ 11L))&& ( i< RB->max); i++, ypos+= 14)
      outtextxy( X+ 48, ypos, ( *( FindPRG+ i))->PRG_name);
   ShowMouse( AN);
   if( RB->Zeiger_pos>= RB->max)
   {
      if( RB->max>= 1)
	 RB->Zeiger_pos= RB->max- 1;
      else
	 RB->Zeiger_pos= 0;
   }
}

int Sort_FindPRG_nachGRP( FindPRG_struct **elem1, FindPRG_struct **elem2)
{
   int ret;

   if(( ret= ( *elem1)->GRP_offset- ( *elem2)->GRP_offset)== 0)
      ret= strcmp( ( *elem1)->PRG_name, ( *elem2)->PRG_name);
   return( ret);
}

BYTE *_Add_PRG( GRP_struct *, BYTE *, char *, char *, char *, BYTE *, char *, BOOL, BOOL *, int *);
BYTE *__CreatGRP( GRP_struct *, BYTE *, char *, BYTE *, BOOL *, int *);
char *Path_to_Dir( char *, char *);
void ProgAnz( GRP_struct *);
void Mark_of_pos( GRP_struct *, int);
void *open_resource_ICO( BYTE);

void Install_HGRP( GRP_struct *GRP)
{
   *GRP->gruppendir= *GRP->gruppe= HGRP_ID;
   GRP->Neu= GRP_AUTOINSTALL;
   ProgAnz( GRP);
}

BOOL _Install_FindPRGs( GRP_struct *GRP, FindPRG_struct **FindPRG, char *Gruppen[], RBalken *RB)
{
   typedef int ( *fcmp) ( const void *, const void *);
   int ret= 0, i, GRP_check= -1, Anz_Icons;
   BYTE *GRP_ptr, ICO_daten[ GRP_MAXICONBYTES];
   BOOL ini_aenderung= 0, not_First= 0;
   char *ptr, *mem_ptr, icon_path[ MAXPATH], _workdir[ MAXDIR];

   GRP_freeResourcen( GRP);                /* jetzt aktive Gruppe schlieen */
   EraseAllGRP();                                   /* alte Gruppen lschen */
   Install_HGRP( GRP);                        /* leere Hauptgruppe erzeugen */
   PrintStatus( "Installing programs ...         ");
   if( *(( ptr= stpcpy( icon_path, default_icon_path))- 1)!= '\\')
      strcpy( ptr++, "\\");
   GRP_ptr= ptr_to_GRP( GRP, &ret, NO_CHECK);
   if( !ret)
   {
      qsort( FindPRG, RB->max, sizeof( FindPRG_struct *), ( fcmp)Sort_FindPRG_nachGRP);
      for( i= 0; ( i< RB->max)&& !ret; i++)
      {
	 if(( GRP_check!= ( *( FindPRG+ i))->GRP_offset)&& ( ( *( FindPRG+ i))->GRP_offset!= HGRP_ID))
	 {
	    if( not_First)
	    {
	       Write_DG2( GRP, GRP_ptr, &ini_aenderung);
	       Install_HGRP( GRP);
	       GRP_ptr= ptr_to_GRP( GRP, &ret, NO_CHECK);
	    }
	    not_First= 1;
	    GRP_ptr= __CreatGRP( GRP, GRP_ptr, Gruppen[ ( *( FindPRG+ i))->GRP_offset], NULL, &ini_aenderung, &ret);
	    Write_DG2( GRP, GRP_ptr, &ini_aenderung);
	    GRP_check= ( *( FindPRG+ i))->GRP_offset;
	    strcpy( GRP->gruppe, Gruppen[ ( *( FindPRG+ i))->GRP_offset]);
	    GRP->Neu= GRP_AUTOINSTALL;
	    ProgAnz( GRP);
	    GRP_ptr= ptr_to_GRP( GRP, &ret, NO_CHECK);
	 }
	 if(( GRP_check== ( *( FindPRG+ i))->GRP_offset)|| ( ( *( FindPRG+ i))->GRP_offset== HGRP_ID))
	 {
	    if( *( ( *( FindPRG+ i))->ICO_path)== ICO_INTERN)
	    {
	       Anz_Icons= 0;
	       if(( Is_Window_EXE( ( *( FindPRG+ i))->PRG_path)< 0x0300)|| WinEXEIcons( ( *( FindPRG+ i))->PRG_path, icon_path, &Anz_Icons)|| ( Anz_Icons== 0))  /* min. WINDOWS 3.x Programm ? */
		  *ptr= '\0';    /* -> 'Cpy_ICO_mem()!= 0' */
	    }
	    else
	       strcpy( ptr, ( *( FindPRG+ i))->ICO_path);
	    if( Cpy_ICO_mem( ICO_daten, icon_path)!= 0)
	    {
	       if(( mem_ptr= open_resource_ICO( ICO_FR))!= NULL)
	       {
		  memcpy( ICO_daten, mem_ptr, 640);
		  close_resource_ICO( mem_ptr);
	       }
	    }
	    GRP_ptr= _Add_PRG( GRP, GRP_ptr, ( *( FindPRG+ i))->PRG_name, ( *( FindPRG+ i))->PRG_path, ( ( *( FindPRG+ i))->workdir_ID== INST_DEFAULT_DIR) ? ( GRP_DEFAULTDIR) : ( Path_to_Dir( _workdir, ( *( FindPRG+ i))->PRG_path)), ICO_daten, "", GRP_NOPARAWIN, &ini_aenderung, &ret);
	 }
      }
      if( !ret)
      {
	 Write_DG2( GRP, GRP_ptr, &ini_aenderung);
	 Install_HGRP( GRP);
      }
   }
   ClearStatus();
   return( ini_aenderung== 1);            /* TRUE -> nderung */
}

BOOL FindProgs( GRP_struct *GRP)
{
   struct ffblk ffblk;
   typedef int ( *fcmp) ( const void *, const void *);
   RBalken RB= { 188, 48, 214, VERT_DIR, 1, 11, 0L};
   FindPRG_struct FindPRG[ INST_MAXPROGRAMME]= { 0}, *FindPRG_ptr[ INST_MAXPROGRAMME];
   int status, ret= 0, X_win= 50, Y_win= 60, X_fbox= 300, Y_fbox= 100,
       X_lw= 190, Y_lw= 80, anzlw, Anz_GRP, Anz_PRG, Found= 0;
   char lw[ 26]= { 0}, *Gruppen[ INST_MAXGRUPPEN]= { NULL};
   BOOL _autoinstall= 0;
   void *arg_ptr[ 9];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     KLICKAREA,                           38, 182,  55, 207,
		     ROLLBALKEN|         KEY,            CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     INPUT|       FRAME| KEY,            222,  61, 169, GRP_MAXGRUPPENNAME- 1, 'n',
		     KLICK_TABLE| FRAME| KEY,            222,  96, 169, INST_MAXGRUPPEN, NORM_TEXT, 'p',
		     FILEINPUT| IGN_CASE|   FRAME| KEY,            222, 131, 250, MAXPATH- 1, 426, 88, DEFAULT, 's',
		     BUTTON|      FRAME| KEY,            236, 302, 164, 214, DELETE,
		     BUTTON|      FRAME| KEY| DEFBUTTON, 314, 380, 164, 214, 'i',
		     BUTTON|      FRAME| KEY,            392, 458, 164, 214, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 509, 381, 10, INIT, NULL, AUS};

   strcpy( prgexe_ptr, HGRPFILENAME);
   if( !findfirst( prgexe_path, &ffblk, FA_NORMAL)&& ( ffblk.ff_fsize> 234L))
   {
      if( !Info_Frage( 200, 200, "All old groups will\nbe erased during\ninstallation.\nContinue?", FRAGE))
	 _autoinstall= 1;
   }
   else
      _autoinstall= 1;
   if( _autoinstall)
   {
      for( Anz_PRG= 0; Anz_PRG< INST_MAXPROGRAMME; Anz_PRG++)
	 FindPRG_ptr[ Anz_PRG]= &FindPRG[ Anz_PRG];
      arg_ptr[ 0]= &RB;
      arg_ptr[ 1]= Anwendungen_Balken;
      arg_ptr[ 3]= Gruppen;
      arg_ptr[ 6]= &X_fbox;
      arg_ptr[ 7]= &Y_fbox;
      arg_ptr[ 8]= "*.EXE;*.COM;*.BAT";
      MS.x= &X_win;
      MS.y= &Y_win;
      MS.mauspos= mauspos;
      MS.arg_ptr= arg_ptr;
      PCX_Window( MS.x, MS.y, PCX_AUTOINSTALLATION, &MS.sa, SHADOW);
      if(( anzlw= LW_Anwahl( &X_lw, &Y_lw, lw, "Select all drives to be searched                          ", A_FESTPLATTE| A_DOUBLEDENSITY| A_NETZWERK, SPEZ_DRIVES))> 0)
      {
	 if( !LoadINSTALL_DB2( FindPRG, Gruppen, &Anz_GRP, &Anz_PRG))
	 {
	    if( !SearchPRG( lw, anzlw, FindPRG, Anz_PRG, &Found))
	    {
	       if( Found> 0)
	       {
		  qsort( FindPRG_ptr, Anz_PRG, sizeof( FindPRG_struct *), ( fcmp)Sort_FindPRG);
		  RB.max= Found;
		  PRGAuswEntry( *MS.x, *MS.y, FindPRG_ptr, &RB);
		  arg_ptr[ 2]= FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->PRG_name;
		  arg_ptr[ 4]= &FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->GRP_offset;
		  arg_ptr[ 5]= FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->PRG_path;
		  do
		  {
		     switch( __CheckMousepos( &MS))
		     {
			case 1:                             /* direkt geklickt */
			   if((( status= ( MStat.y- ( *MS.y+ 55))/ 14)>= 0)&& ( status< 11)&& ( status< ( RB.max- RB.proz)))
			   {
			      Anwendungen_Balken( *MS.x, *MS.y, RB.Zeiger_pos, AUS);
			      RB.Zeiger_pos= status;
			      ANZEIGE:
			      ;
			      arg_ptr[ 2]= FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->PRG_name;
			      arg_ptr[ 4]= &FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->GRP_offset;
			      arg_ptr[ 5]= FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->PRG_path;
			      MS.statsp= REINIT;
			   }
			   break;
			case 2:                                  /* Rollbalken */
			   switch( RB.ret_val)
			   {
			      case ONE_ELEMENT_UP:
				 PRGAusw_Up_Down( *MS.x, *MS.y, FindPRG_ptr, &RB, DOWN);
				 break;
			      case ONE_ELEMENT_DOWN:
				 PRGAusw_Up_Down( *MS.x, *MS.y, FindPRG_ptr, &RB, UP);
				 break;
			      case ELEMENT_RANDOM:
				 PRGAuswEntry( *MS.x, *MS.y, FindPRG_ptr, &RB);
				 break;
			      case POINTER_RETURN:
				 goto ANZEIGE;
			   }
			   break;
			case 3:                                /* Programmname */
			   PRGAuswEntry( *MS.x, *MS.y, FindPRG_ptr, &RB);
			   MS.statsp= REINIT;
			   break;
			case 6:                                   /* Entfernen */
			   if( RB.max>= 1)
			   {
			      FindPRG_ptr[ RB.proz+ RB.Zeiger_pos]->ready= 0;
			      qsort( FindPRG_ptr, RB.max--, sizeof( FindPRG_struct *), ( fcmp)Sort_FindPRG);
			      PRGAuswEntry( *MS.x, *MS.y, FindPRG_ptr, &RB);
			      Anwendungen_Balken( *MS.x, *MS.y, RB.Zeiger_pos, AN);
			   }
			   break;
			case 7:                                /* Installieren */
			   if( RB.max> 0)
			   {
			      ShowMouse( AUS);
			      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
			      ShowMouse( AN);
			      return( _Install_FindPRGs( GRP, FindPRG_ptr, Gruppen, &RB));
			   }
			case 8:                                     /* Abbruch */
			case 0:                                         /* ESC */
			   ret= 1;
			   break;
		     }
		  }while( !ret);
	       }
	       else
		  ErrorMsg( "No known programs found");
	    }
	 }
      }
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   return( FALSE);                           /* TRUE -> nderung */
}

int Mark_of_Entry( GRP_struct *GRP)
{
   if( GRP->RB->max> 0L)
      return(((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)+ ((( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY)<< 2))- 1);
   else
      return( -1);
}

static void Markierer( GRP_struct *GRP, BOOL a_e)
{
   int stlen;

   stlen= GRP->IconNamelen[ Mark_of_Entry( GRP)]<< 2;
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   ShowMouse( AUS);
   if( a_e== AUS)
      setcolor( menubackround);
   else
      setcolor( menuink);
   rectangle( GRP->balkenx- stlen- 5, GRP->balkeny, GRP->balkenx+ stlen+ 4, GRP->balkeny+ 12);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
}

int WriteHGRP( void)
{
   struct{ BYTE  ID[ sizeof( GRP_DATEIID)- 1];
	   WORD  Anz_Eintraege;
	   char  GRP_Vaterverz[ GRP_MAXGRUPPENDIR],
		 GRP_name[ GRP_MAXGRUPPENNAME];
	   DWORD GRP_Offset;
	 }GRP_Header= { GRP_DATEIID, 0, "", "", GRP_LASTENTRY};
   int handle= -1;

   strcpy( prgexe_ptr, HGRPFILENAME);
   if(( handle= _creat( prgexe_path, 0))!= -1)
   {
      if( _write( handle, &GRP_Header, sizeof( GRP_Header))!= -1)
      {
	 lseek( handle, 0L, SEEK_SET);
      }
      else
      {
	 _close( handle);
	 unlink( prgexe_path);
	 handle= -1;
      }
   }
   return( handle);
}

void ProgAnz( GRP_struct *GRP)
{
   struct ffblk ffblk;
   struct textsettingstype text;
   int ret_val= 0, x, ypos, y, handle, done, marki= 0, spalten, X_gruppe= 0,
       Y_gruppe= 94, i;
   WORD readlen, Anz_Eintraege;
   BOOL flag= 0;
   char tmp_array[ 80];
   BYTE *GRP_ptr, *tmp_ptr, ID_gruppendir, GRP_gefiltert, *Icon_ptr;

   ( *GRP->gruppe== HGRP_ID) ? ( y= MARKY) : ( y= MARKYWIN);
   ID_gruppendir= *GRP->gruppendir;
   GRP_gefiltert= GRP->Neu| GRP_DRAW;
   if(( GRP_gefiltert== GRP_NEU)|| ( GRP_gefiltert== GRP_JUMPDIR))  /* soll eine neue Gruppe angezeigt werden ? */
   {
      do
      {
	 ret_val= 0;
	 if( *GRP->gruppe== HGRP_ID)
	    strcpy( prgexe_ptr, HGRPFILENAME);
	 else
	 {
	    *( strncpy( prgexe_ptr, GRP->gruppe, 6)+ 6)= '\0';
	    strcat( prgexe_ptr, "??.DG2");
	 }
	 if(( done= findfirst( prgexe_path, &ffblk, FA_NORMAL))!= -1)
	 {
	    while( !done&& !ret_val)
	    {
	       strcpy( prgexe_ptr, ffblk.ff_name);
	       if(( handle= _open( prgexe_path, O_RDWR))!= -1)
	       {
		  GRP_OPEN_FILE:
		  ;
		  if(( GRP_ptr= malloc( readlen= ( 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME)))!= NULL)
		  {
		     if( _read( handle, GRP_ptr, readlen)!= -1)
		     {
			if( !strncmp( GRP_ptr, GRP_DATEIID, sizeof( GRP_DATEIID)- 1)&& !strcmp( GRP_ptr+ 13, GRP->gruppendir)&& !strcmp( GRP_ptr+ 13+ GRP_MAXGRUPPENDIR, GRP->gruppe))    /* ist es eine Gruppendatei ?, ist es die richtige Gruppe ? */
			{
			   GRP_freeResourcen( GRP);
			   GRP->balkenx= MARKX;    /* Markierer neu positionieren */
			   GRP->ymerk= GRP->balkeny= y+ Y_ICON_MARK_ABST;
			   GRP->File_handle= handle;
			   GRP->seek_pos= 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME;
			   GRP->mem_len= filelength( handle)- GRP->seek_pos;
			   GRP->RB->max= *( WORD *)( GRP_ptr+ 11); /* Anzahl Eintrge in der Gruppe */
			   GRP->RB->proz= 0L;
			   if( GRP->MS->statsp!= INIT)
			      GRP->MS->statsp= REINIT;
			   if( *GRP->gruppendir!= HGRP_ID)
			      strcat( GRP->gruppendir, "\\");
			   strcat( GRP->gruppendir, GRP->gruppe);
			   free( GRP_ptr);
			   break;
			}
		     }
		     else
		     {
			ErrorMsg( READ_ERROR": Group file");
			ret_val= -1;
		     }
		     free( GRP_ptr);
		  }
		  else
		  {
		     ErrorMsg( KEIN_SPEICHER);
		     ret_val= -1;
		  }
		  _close( handle);
	       }
	       else
	       {
		  sprintf( tmp_array, OPEN_ERROR"%s (read/write)", prgexe_ptr);
		  ErrorMsg( tmp_array);
		  ret_val= -1;
	       }
	       done= findnext( &ffblk);
	    }
	 }
	 else
	 {
	    if(( errno== ENOENT)&& ( *GRP->gruppe== HGRP_ID))
	    {
	       if(( handle= WriteHGRP())!= -1)
		  goto GRP_OPEN_FILE;
	       else
		  ret_val= -1;
	    }
	    else
	    {
	       sprintf( tmp_array, "The file of the group '%s' not found", GRP->gruppe);
	       ErrorMsg( tmp_array);
	       ID_gruppendir= *GRP->gruppendir= *GRP->gruppe= HGRP_ID;
	       y= MARKY;
	       veraendert= 1;
	       ret_val= -2;
	    }
	 }
      }while( ret_val== -2);
   }
   if( !ret_val&& ( GRP->Neu& GRP_DRAW))
   {
      setfillstyle( SOLID_FILL, menubackround);
      ShowMouse( AUS);
      if( *GRP->gruppe== HGRP_ID)                   /* Hauptgruppe gewnscht ? */
      {
	 bar( 5, 94, 612, 454);
	 GRP->RB->maxstep= MAX_HAUPTGRPICONS;
	 GRP->MS->mauspos[ Y_ICON_PUSHAREA]= 94;  /* oberen Rand des IconFensters festlegen */
      }
      else
      {
	 if(( ID_gruppendir== HGRP_ID)|| ( GRP_gefiltert== GRP_REDRAW)|| ( GRP_gefiltert== GRP_JUMPDIR)) /* war vorher die Hauptgruppe aktiv */
	    PCX_Window( &X_gruppe, &Y_gruppe, PCX_GRUPPE, NULL, NO_SHADOW);
	 if(( GRP_gefiltert== GRP_REDRAW)|| ( GRP_gefiltert== GRP_NEU)|| ( GRP_gefiltert== GRP_JUMPDIR))
	 {
	    setcolor( menuink);
	    putpixel( 122, 105, menuink);    /* sonst funktioniert bar() nicht ??? */
	    bar( 122, 105, 601, 119);
	    outtextxy( 127, 108, MakeShowPath( GRP->gruppendir, tmp_array, 59));
	 }
	 bar( 5, 131, 612, 454);
	 GRP->RB->maxstep= MAX_GRPICONS;
	 GRP->MS->mauspos[ Y_ICON_PUSHAREA]= 131; /* oberen Rand des IconFensters festlegen */
      }
      ShowMouse( AN);
      GRP_ptr= ptr_to_GRP( GRP, &ret_val, CHECK);
      if( !ret_val)
      {
	 tmp_ptr= GRP_ptr;
	 for( i= 0; ( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)&& ( i< GRP->RB->proz); i++)
	    tmp_ptr+= *( DWORD *)tmp_ptr;        /* folgenden Eintrag auswerten */
	 if( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)      /* gltiger Eintrag ? */
	 {
	    gettextsettings( &text);
	    settextjustify( CENTER_TEXT, text.vert);
	    setcolor( menuink);
	    for( i= 0, ypos= y; tmp_ptr&& ( i< GRP->RB->maxstep); ypos+= ICONABSTANDY)
	    {
	       for( spalten= 0, x= MARKX- 16; tmp_ptr&& ( x<= 540); x+= ICONABSTANDX)
	       {
		  if( *( DWORD *)tmp_ptr!= GRP_LASTENTRY) /* ist noch ein Eintrag vorhanden ? */
		  {
		     GRP->IconNamelen[ i++]= strlen( tmp_ptr+ 10);
		     ShowMouse( AUS);
		     if( *( tmp_ptr+ 8)== GRP_PROGRAMM)
			Icon_ptr= tmp_ptr+ 16+ *( tmp_ptr+ 9);
		     else
		     {
			if( *( DWORD *)( tmp_ptr+ 4)& GRP_ICONMASK)
			   Icon_ptr= tmp_ptr+ 10+ *( tmp_ptr+ 9);
			else
			   Icon_ptr= GRP_ICO_ptr;
		     }
		     DrawIcon( x, ypos- 4, Icon_ptr);  /* Icon des Eintrags ausgeben */
		     outtextxy( x+ 15, ypos+ 33, tmp_ptr+ 10);  /* Eintragsnamen ausgeben */
		     ShowMouse( AN);
		     spalten++;
		     flag= 1;
		     tmp_ptr+= *( DWORD *)tmp_ptr;  /* folgenden Eintrag auswerten */
		  }
		  else
		     tmp_ptr= NULL;
	       }
	       if( flag)
	       {
		  GRP->mark[ marki++]= spalten;
		  flag= 0;
	       }
	    }
	    settextjustify( text.horiz, text.vert);
	    Markierer( GRP, AN);
	 }
	 free( GRP_ptr);
      }
   }
   GRP->mark[ marki]= 0;
}

int WriteStartBAT( void)
{
   FILE *bat;
   int ret_val= 0;

   strcpy( prgexe_ptr, "~DSK##20.BAT");
   if(( bat= fopen( prgexe_path, "wt"))!= NULL)
      fclose( bat);
   else
   {
      ErrorMsg( CREAT_ERROR"~DSK##20.BAT");
      ret_val= -1;
   }
   return( ret_val);
}

void VaterGruppe( GRP_struct *GRP)
{
   char *tmp_ptr;

   if(( tmp_ptr= strrchr( GRP->gruppendir, '\\'))!= NULL)
   {
      *tmp_ptr= '\0';
      while(( tmp_ptr> GRP->gruppendir)&& ( *--tmp_ptr!= '\\'))
	 ;
      if( tmp_ptr== GRP->gruppendir)
      {
	 strcpy( GRP->gruppe, tmp_ptr);
	 *tmp_ptr= HGRP_ID;
      }
      else
      {
	 strcpy( GRP->gruppe, tmp_ptr+ 1);
	 *tmp_ptr= '\0';
      }
   }
   else
      *GRP->gruppendir= *GRP->gruppe= HGRP_ID;
   veraendert= 1;
   GRP->Neu= GRP_NEU;
   ProgAnz( GRP);
}

void HauptGruppe( GRP_struct *GRP)
{
   *GRP->gruppendir= *GRP->gruppe= HGRP_ID;
   veraendert= 1;
   GRP->Neu= GRP_NEU;
   ProgAnz( GRP);
}

int Get_Parameter( char *Parameter, char *Icon_ptr)
{
   int ret_val= 0, ret= 0, LW, X_dateiauswahlbox= 120, Y_dateiauswahlbox= 30, X_verzeichnisbaum= 100, X_lwausw= 130, Y_lwausw= 200;
   void *arg_ptr[ 4];
   char *msg[]= { "File selector is available      ",
		  "Directory tree can be used         ",
		  "Drive can be selected          " };
   WORD mauspos[]= { BUTTON|    FRAME| KEY,                   5,  27,   5,  21, ESC,
		     FILEINPUT| IGN_CASE| FRAME| KEY| DEFBUTTON| MSG,  59,  51, 240, GRP_MAXPARAMETER- 1, 307,  38, DEFAULT, 'n',
		     BUTTON|    FRAME| KEY|            MSG, 357, 403,  38,  72, 'p',
		     BUTTON|    FRAME| KEY|            MSG, 407, 453,  38,  72, 'l',
		     BUTTON|    FRAME| KEY,                  37, 230,  86, 111, RETURN,
		     BUTTON|    FRAME| KEY,                 238, 431,  86, 111, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 469, 133, 7, INIT, NULL, AN};


   arg_ptr[ 0]= Parameter;
   arg_ptr[ 1]= &X_dateiauswahlbox;
   arg_ptr[ 2]= &Y_dateiauswahlbox;
   ( char *)arg_ptr[ 3]= "*.*";
   MS.x= &parawin_X;
   MS.y= &parawin_Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_PARAMETERFENSTER, &MS.sa, SHADOW);
   ShowMouse( AUS);
   DrawIcon( *MS.x+ 16, *MS.y+ 34, Icon_ptr);
   ShowMouse( AN);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 2:                                         /* Verzeichnisbaum */
	    if( !ShowTree( Parameter, &X_verzeichnisbaum, DEFAULT))
	       MS.statsp= REINIT;
	    break;
	 case 3:                                              /* LW-Auswahl */
	    if(( LW= LW_Auswahl( &X_lwausw, &Y_lwausw, "", NOTHING, ALL_DRIVES))>= 0)
	    {
	       sprintf( Parameter, "%c:", 'A'+ LW);
	       MS.statsp= REINIT;
	    }
	    break;
	 case 0:                                                     /* ESC */
	 case 5:                                                 /* Abbruch */
	    ret_val= 1;
	 case 4:                                                      /* OK */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);            /* 0= o.k., 1= Abbruch */
}

void WorkIcon( GRP_struct *GRP, BYTE IconMark)
{
   FILE *Batch;
   int ret= 0;
   BOOL Exit= 0;
   WORD i;
   BYTE *GRP_ptr, *tmp_ptr, *suchweg, *workdir, Parameter[ GRP_MAXPARAMETER+ 1],
	Arbeitsdir[ MAXDIR];

   tmp_ptr= GRP_ptr= ptr_to_GRP( GRP, &ret, CHECK);
   if( !ret)
   {
      for( i= 0; ( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)&& ( i< ( GRP->RB->proz+ IconMark)); i++)
	 tmp_ptr+= *( DWORD *)tmp_ptr;       /* folgenden Eintrag auswerten */
      if( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)         /* gltiger Eintrag ? */
      {
	 if( *( tmp_ptr+ 8)== GRP_GRUPPE)
	 {
	    strcpy( GRP->gruppe, tmp_ptr+ 10);
	    veraendert= 1;
	    GRP->Neu= GRP_NEU;
	    ProgAnz( GRP);
	 }
	 else
	 {
	    if( !access( suchweg= tmp_ptr+ 16+ *( tmp_ptr+ 9)+ *( WORD *)( tmp_ptr+ 11+ *( tmp_ptr+ 9)), 0))  /* existiert die Startdatei ? */
	    {
	       if( !strcmp( workdir= suchweg+ *( tmp_ptr+ 13+ *( tmp_ptr+ 9)), GRP_DEFAULTDIR))
		  getcwd( Arbeitsdir, MAXDIR);
	       else
		  strcpy( Arbeitsdir, workdir);
	       if( !access( Arbeitsdir, 0))  /* existiert das Arbeitsverzeichnis ? */
	       {
		  strcpy( Parameter, workdir+ *( tmp_ptr+ 14+ *( tmp_ptr+ 9)));  /* feste Parameter */
		  if( *( tmp_ptr+ 10+ *( tmp_ptr+ 9))== GRP_PARAWIN)
		  {
		     if( Get_Parameter( Parameter, tmp_ptr+ 16+ *( tmp_ptr+ 9))) /* Abbruch */
			ret= ABBRUCH;
		  }
		  if( *Parameter!= '\0')
		     *( ( BYTE *)memmove( Parameter+ 1, Parameter, strlen( Parameter)+ 1)- 1)= SPACE;
		  if( !ret)
		  {
		     strcpy( prgexe_ptr, "~DSK##20.BAT");
		     if(( Batch= fopen( prgexe_path, "w+t"))!= NULL)
		     {
			if(( fwrite( Arbeitsdir, 2, 1, Batch)== 1)&& ( fputc( '\n', Batch)!= EOF)&& ( fwrite( "CD ", 3, 1, Batch)== 1)&& ( fwrite( Arbeitsdir, strlen( Arbeitsdir), 1, Batch)== 1)&& ( fputc( '\n', Batch)!= EOF))
			{
			   if( !strcmp(( suchweg+ strlen( suchweg)- 4), ".BAT")) /* ist es eine Batchdatei ? */
			   {
			      if( fwrite( "CALL ", 5, 1, Batch)!= 1)
				 ret= ABBRUCH;
			   }
			   else
			   {
			      if( Is_Window_EXE( suchweg)>= 0x0300)  /* min. WINDOWS 3.x Programm ? */
			      {
				 if( fwrite( "WIN ", 4, 1, Batch)!= 1)
				    ret= ABBRUCH;
			      }
			   }
			   if( !ret)
			   {
			      getcwd( Arbeitsdir, MAXDIR);   /* originales Verzeichnis merken */
			      if(( fwrite( suchweg, strlen( suchweg), 1, Batch)== 1)&& ( fwrite( Parameter, strlen( Parameter), 1, Batch)== 1)&& ( fputc( '\n', Batch)!= EOF)&& ( fwrite( Arbeitsdir, 2, 1, Batch)== 1)&& ( fputc( '\n', Batch)!= EOF)&& ( fwrite( "CD ", 3, 1, Batch)== 1)&& ( fwrite( Arbeitsdir, strlen( Arbeitsdir), 1, Batch)== 1)&& ( fputc( '\n', Batch)!= EOF))
				 Exit= 1;                     /* alles o.k. */
			   }
			}
			fclose( Batch);
		     }
		     else
			ErrorMsg( CREAT_ERROR"~DSK##20.BAT");
		  }
	       }
	       else
		  ErrorMsg( "The working directory does not exist");
	    }
	    else
	       ErrorMsg( "The start file does not exist");
	 }
      }
      free( GRP_ptr);
   }
   if( Exit)
      ExitMsg( 0);
}

void FR_Adresse( void)
{
   saveall sa;

   PCX_Window( &fr_adressex, &fr_adressey, PCX_VERSION, &sa, SHADOW);
   Klick();
   ShowMouse( AUS);
   BigScreenRestore( &sa, fr_adressex, fr_adressey);
   ShowMouse( AN);
}

int ExistDatei( char *file)
{
   strcpy( prgexe_ptr, file);
   return( access( prgexe_path, 0)== 0);
}

static void MakeMark( GRP_struct *GRP, int status)
{
   if( GRP->RB->max> 0)
   {
      switch( status)
      {
	 case 0:                                                   /* <-- */
	    Markierer( GRP, AUS);
	    if( GRP->balkenx> MARKX)
	       GRP->balkenx-= ICONABSTANDX;
	    else
	       GRP->balkenx= ( GRP->mark[ ( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY]* ICONABSTANDX)- ICONABSTANDX+ MARKX;
	    Markierer( GRP, AN);
	    break;
	 case 1:                                                  /* --> */
	    Markierer( GRP, AUS);
	    if((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)< GRP->mark[ ( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY])
	       GRP->balkenx+= ICONABSTANDX;
	    else
	       GRP->balkenx= MARKX;
	    Markierer( GRP, AN);
	    break;
	 case 2:                                                  /* Cur Up */
	    Markierer( GRP, AUS);
	    if( GRP->balkeny> GRP->ymerk)
	       GRP->balkeny-= ICONABSTANDY;
	    else
	    {
	       for( status= 0; GRP->mark[ status]&& ( status< 7); status++)
		  ;
	       if((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)<= GRP->mark[ --status])
		  GRP->balkeny= status* ICONABSTANDY+ GRP->ymerk;
	       else
		  GRP->balkeny= --status* ICONABSTANDY+ GRP->ymerk;
	    }
	    Markierer( GRP, AN);
	    break;
	 case 3:                                                   /* Cur Dn */
	    Markierer( GRP, AUS);
	    if((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)<= GRP->mark[ (( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY)+ 1])
	       GRP->balkeny+= ICONABSTANDY;
	    else
	       GRP->balkeny= GRP->ymerk;
	    Markierer( GRP, AN);
	    break;
	 case 4:                                                  /* Return */
	    status= ((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)+ ((( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY)<< 2))- 1;
	    WorkIcon( GRP, status);
	    break;
      }
   }
}

void Mark_of_pos( GRP_struct *GRP, int pos)
{
   GRP->balkenx= MARKX+ (( pos& 0x3)* ICONABSTANDX);
   GRP->balkeny= MARKY+ Y_ICON_MARK_ABST+ ( pos>> 2)* ICONABSTANDY;
   if( *GRP->gruppendir!= HGRP_ID)
      GRP->balkeny+= MARKYWIN- MARKY;
}

int markiertes_Icon( int x, int y, GRP_struct *GRP)
{
   return(( ( y- ( GRP->ymerk- Y_ICON_MARK_ABST- 10))/ ICONABSTANDY)* 4+ ( ( x- ( MARKX- 73))/ ICONABSTANDX));
}

void MoveIcon( GRP_struct *GRP)
{
   int ret= 0, i, old_X, old_Y, X_stat, Y_stat, icon_X, icon_Y, X_ref, Y_ref, IconMark;
   BYTE *GRP_ptr, *tmp_ptr, *icon_ptr, *nach_ptr, *zwischen_sp;
   BOOL move_icon= 0, INIchanged= FALSE;
   WORD old_len;

   old_X= MStat.x;
   old_Y= MStat.y;
   Y_stat= ( MStat.y- ( GRP->ymerk- Y_ICON_MARK_ABST- 10))/ ICONABSTANDY;
   X_stat= ( MStat.x- ( MARKX- 73))/ ICONABSTANDX;
   icon_X= X_stat* ICONABSTANDX+ MARKX- 16;
   icon_Y= Y_stat* ICONABSTANDY+ GRP->ymerk- Y_ICON_MARK_ABST- 4;
   X_ref= MStat.x- icon_X;
   Y_ref= MStat.y- icon_Y;
   if(( X_stat>= 0)&& ( X_stat<= 3)&& ( Y_stat>= 0)&& ( Y_stat<= (( *GRP->gruppendir== HGRP_ID) ? ( 5) : ( 4))))
   {
      if((( IconMark= Y_stat* 4+ X_stat)+ GRP->RB->proz)< GRP->RB->max)
      {
	 Markierer( GRP, AUS);
	 Mark_of_pos( GRP, IconMark);
	 Markierer( GRP, AN);
	 if( MStat.buttons== RIGHT)
	 {
	    switch( PMArtofMarkedEntry( GRP))
	    {
	       case GRUPPE:
		  INIchanged= Gruppe( GRP);
		  break;
	       case PROGRAMM:
		  INIchanged= MakeIni( GRP);
		  break;
	    }
	    if( INIchanged)
	    {
	       Check_GRPanzeige( GRP);
	       GRP->Neu= GRP_ALT;
	       ProgAnz( GRP);
	    }
	 }
	 else
	 {
	    if(( GRP->XMS_handle!= 0)&& ( MStat.x>= icon_X)&& ( MStat.x<= icon_X+ 31)&& ( MStat.y>= icon_Y)&& ( MStat.y<= icon_Y+ 31))
	    {
	       while( MouseStat()!= NOTHING)
	       {
		  if((( MStat.x!= old_X)|| ( MStat.y!= old_Y))&& ( move_icon|| ( !move_icon&& (( abs( MStat.x- old_X)>= 2)|| ( abs( MStat.y- old_Y)>= 2)))))
		  {
		     if( !move_icon)
		     {
			nach_ptr= tmp_ptr= GRP_ptr= ptr_to_GRP( GRP, &ret, CHECK);
			if( ret!= 0)                              /* Fehler */
			   return;
			for( i= 0; ( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)&& ( i< ( GRP->RB->proz+ IconMark)); i++)
			   tmp_ptr+= *( DWORD *)tmp_ptr;       /* folgenden Eintrag auswerten */
			if(( zwischen_sp= malloc( *( DWORD *)tmp_ptr))== NULL)
			{
			   ErrorMsg( KEIN_SPEICHER);
			   return;
			}

			if( *( tmp_ptr+ 8)== GRP_PROGRAMM)
			   icon_ptr= tmp_ptr+ 16+ *( tmp_ptr+ 9);
			else
			{
			   if( *( DWORD *)( tmp_ptr+ 4)& GRP_ICONMASK)
			      icon_ptr= tmp_ptr+ 10+ *( tmp_ptr+ 9);
			   else
			      icon_ptr= GRP_ICO_ptr;
			}

			SetXRange( 5+ X_ref, 612- ( 31- X_ref));
			SetYRange(( ( GRP->ymerk== ( MARKY+ Y_ICON_MARK_ABST)) ? ( 94) : ( 131)) + Y_ref, 454- ( 31- Y_ref));
			setfillstyle( SOLID_FILL, menubackround);
			ShowMouse( AUS);
			bar( icon_X, icon_Y, icon_X+ 31, icon_Y+ 31);
			ShowMouse( AN);
		     }
		     else
		     {
			ShowMouse( AUS);
			SCR_move( old_X- X_ref, 485, 32, 32, old_X- X_ref, old_Y- Y_ref);
			ShowMouse( AN);
		     }
		     ShowMouse( AUS);
		     SCR_move( MStat.x- X_ref, MStat.y- Y_ref, 32, 32, MStat.x- X_ref, 485);
		     DrawIcon( MStat.x- X_ref, MStat.y- Y_ref, icon_ptr);
		     ShowMouse( AN);
		     move_icon= 1;
		     old_X= MStat.x;
		     old_Y= MStat.y;
		  }
	       }
	    }
	    else
	       while( MouseStat()!= NOTHING);
	    if( move_icon)
	    {
	       SetXRange( 0, 639);
	       SetYRange( 0, 479);
	       IconMark= markiertes_Icon( old_X, old_Y, GRP);
	       if( IconMark< ( GRP->RB->max- GRP->RB->proz))
	       {
		  Mark_of_pos( GRP, IconMark);
		  for( i= 0; ( *( DWORD *)nach_ptr!= GRP_LASTENTRY)&& ( i< ( IconMark+ GRP->RB->proz)); i++)
		     nach_ptr+= *( DWORD *)nach_ptr;     /* folgenden Eintrag auswerten */
		  memcpy( zwischen_sp, tmp_ptr, *( DWORD *)tmp_ptr);
		  if( nach_ptr> tmp_ptr)
		  {
		     old_len= *( DWORD *)nach_ptr;
		     memmove( tmp_ptr, tmp_ptr+ *( DWORD *)tmp_ptr, ( nach_ptr+ *( DWORD *)nach_ptr)- ( tmp_ptr+ *( DWORD *)tmp_ptr));
		     memcpy( nach_ptr+ ( old_len- *( DWORD *)zwischen_sp), zwischen_sp, *( DWORD *)zwischen_sp);
		  }
		  else
		  {
		     memmove( nach_ptr+ *( DWORD *)tmp_ptr, nach_ptr, tmp_ptr- nach_ptr);
		     memcpy( nach_ptr, zwischen_sp, *( DWORD *)zwischen_sp);
		  }
		  if(( lseek( GRP->File_handle, GRP->seek_pos, SEEK_SET)== -1)|| ( _write( GRP->File_handle, GRP_ptr, GRP->mem_len)== -1))
		  {
		     ErrorMsg( WRITE_ERROR"Group file");
		     Info_Frage( 100, 200, "Could not write group\nfile completely.\nIt may be destroyed!", INFO);
		  }
		  else
		     XMSCopy( 0, ( DWORD)(( void far *)GRP_ptr), GRP->XMS_handle, 0L, ( GRP->mem_len+ 1)>> 1);
	       }
	       free( zwischen_sp);
	       free( GRP_ptr);
	       GRP->Neu= GRP_ALT;
	       ProgAnz( GRP);
	    }
	    else
	    {
	       delay( klickwait);
	       if( MouseStat()!= NOTHING)
	       {
		  while( MouseStat()!= NOTHING)   /* auf Loslassen der Maustaste warten */
		    ;
		  WorkIcon( GRP, IconMark);
	       }
	    }
	 }
      }
   }
}

int PMArtofMarkedEntry( GRP_struct *GRP)
{
   int ret= 0, i, IconMark;
   BYTE *GRP_ptr, *tmp_ptr;

   IconMark= Mark_of_Entry( GRP);
   tmp_ptr= GRP_ptr= ptr_to_GRP( GRP, &ret, CHECK);
   if( !ret)
   {
      for( i= 0; ( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)&& ( i< ( GRP->RB->proz+ IconMark)); i++)
	 ( ptrdiff_t)tmp_ptr+= *( DWORD *)tmp_ptr;    /* folgenden Eintrag auswerten */
      if( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)         /* gltiger Eintrag ? */
	 ret= ( ( *( tmp_ptr+ 8)== GRP_GRUPPE) ? GRUPPE : PROGRAMM);
      free( GRP_ptr);
   }
   return( ret);
}

void ChangeEntry( GRP_struct *GRP)
{
   BOOL INIchanged= FALSE;

   switch( PMArtofMarkedEntry( GRP))
   {
      case GRUPPE:
	 INIchanged= Gruppe( GRP);
	 break;
      case PROGRAMM:
	 INIchanged= MakeIni( GRP);
	 break;
   }
   if( INIchanged)
   {
      Check_GRPanzeige( GRP);
      GRP->Neu= GRP_ALT;
      ProgAnz( GRP);
   }
}

void Dummy_Balken( void){}   /* mu als Zeigerfunktion fr die Sliderbox angegeben werden */

void *open_resource_ICO( BYTE);

void main( int argc, char **argv)
{
   int gdriver= DETECT, gmode, ret, status, Dummy= 0;
   char Gruppenverzeichnis[ GRP_MAXGRUPPENDIR]= { HGRP_ID}, Gruppenname[ GRP_MAXGRUPPENNAME]= { HGRP_ID},
	*memPtr;
   RBalken RB= { 617, 94, 454, VERT_DIR, 4, MAX_HAUPTGRPICONS, 0L, 0L, 0L};
   GRP_struct GRP= { 0, 0, GRP_JUMPDIR, { 0,0,0,0,0,0,0}};
   void *arg_ptr[ 4];
   char *msg[]= { "Set time and alarm(s)   ",
		  "Pop up the program's quick reference (key combinations, etc)   ",
		  "Information on DESKTOP V"DESKTOP_VERSION" ("__DATE__")  ",
		  "Configure programs and groups   ",
		  "Go to the file manager   ",
		  "Pop up pocket calculator ",
		  "Change the SoundBlaster's volume  ",
		  "Pop up CD-ROM Audio player    ",
		  "Change system settings (colours, directories)        ",
		  "Quit program   ",
		  "Start program or open group by double clicking ",
		  "Select which part of the group to view ",
		  "Go to the main group       ",
		  "Go to the parent group              " };

   /* ACHTUNG !; siehe '#define Y_ICON_PUSHAREA', wenn dieses Array gendert wird */

   WORD mauspos[]= { DOUBLE_KLICKAREA|        KEY|            MSG, 580, 632,   4,  20, SHIFT_F10,
		     BUTTON|           FRAME| KEY|            MSG,  29,  98,  33,  85, 'h',
		     BUTTON|           FRAME| KEY|            MSG, 102, 171,  33,  85, 'i',
		     BUTTON|           FRAME| KEY|            MSG, 175, 244,  33,  85, 's',
		     BUTTON|           FRAME| KEY| DEFBUTTON| MSG, 248, 317,  33,  85, 'f',
		     BUTTON|           FRAME| KEY|            MSG, 321, 390,  33,  85, 'a',
		     BUTTON|           FRAME| KEY|            MSG, 439, 463,  54,  85, 'v',
		     BUTTON|           FRAME| KEY|            MSG, 394, 463,  33,  85, 'c',
		     BUTTON|           FRAME| KEY|            MSG, 467, 536,  33,  85, 't',
		     BUTTON|           FRAME| KEY|            MSG, 540, 609,  33,  85, ALT_X,
		     PUSHAREA|                                MSG,   5, 612,  94, 454,
		     ROLLBALKEN|              KEY|            MSG, 1, 1, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     BUTTON| _IF|      FRAME| KEY|            MSG,   9,  57,  98, 126, STRG_POS1,
		     BUTTON| _IF|      FRAME| KEY|            MSG,  61, 109,  98, 126, ESC,
		     TASTE,                                        CURSOR_LEFT,
		     TASTE,                                        CURSOR_RIGHT,
		     TASTE,                                        CURSOR_UP,
		     TASTE,                                        CURSOR_DOWN,
		     TASTE,                                        ALT_E
		   };
   MAUSStruct MS= { DEFAULT, DEFAULT, 640, 480, 19, INIT, NULL, AN};

   if( coreleft()< MEMAVAIL)   /* sind mindestens 100 KByte Speicher verfgbar ? */
   {
      printf( "\nDESKTOP V"DESKTOP_VERSION" needs another %ld kbytes of free DOS memory\n\n",
	      ( MEMAVAIL- coreleft())/ 1024);
      exit( 255);
   }
   if(( argc> 1)&& ( strchr( argv[ 1], '?')!= NULL))
   {
      puts( "\nDESKTOP V"DESKTOP_VERSION" (c) "ERSTELLUNGSZEITRAUM" Felix Ritter\n\n"
	    "\tDBD /P -> Starts Program Manager\n"
	    "\tDBD /D -> Starts File Manager\n");
      exit( 255);
   }
   if(( prgexe_ptr= searchpath( "DESKTOP2.EXE"))== NULL)
   {
      puts( "Could not find the file DESKTOP2.EXE of the program!\n"
	    "Check that the program directory is entered in the environment variable\n"
	    "PATH\n");
      exit( 255);
   }
   else
   {
      *( prgexe_ptr= strrchr( strcpy( prgexe_path, prgexe_ptr), '\\')+ 1)= '\0';
      strcpy( stpcpy( default_icon_path, prgexe_path), "DBD_AICO");
      if( Is_VGA())                    /* keine VGA-Grafikkarte installiert */
      {
	 ExitMsg( 250);
      }
      else
      {
	 if( ExistDatei( "~HGRPDBD.DG2")&& !ExistDatei( HGRPFILENAME))
	 {
	    strcpy( ( memPtr= strdup( prgexe_path))+ ( ( ptrdiff_t)prgexe_ptr- ( ptrdiff_t)prgexe_path), "~HGRPDBD.DG2");
	    if( rename( memPtr, prgexe_path)== -1)
	    {
	       perror( "Error: rename ~HGRPDBD.DG2 -> "HGRPFILENAME);
	       exit( 255);
	    }
	    free( memPtr);
	 }
	 _Get_Text_Screen();
	 if( registerbgidriver( EGAVGA_driver)< 0)
	 {
	    ExitMsg( 250);
	 }
	 else
	 {
	    initgraph( &gdriver, &gmode, NULL);
	    if(( graphresult()!= grOk)|| ( getgraphmode()!= VGAHI))   /* 640x480 VGA */
	    {
	       ExitMsg( 250);
	    }
	    else
	    {
	       if((( GRP_ICO_ptr= open_resource_ICO( ICO_GRUPPE))== NULL)||
		  (( OwnerButtonICO_ptr= open_resource_ICO( ICO_OWNERBUTTON))== NULL))
	       {
		  ExitMsg( MEMORY_EXIT);  /* Konnte Gruppensymbol nicht laden */
	       }
	       else
	       {
		  SetPal();                        /* Farbtabelle verndern */
		  if( XMSInit())                 /* XMS-Treiber vorhanden ? */
		  {
		     XMSQueryVer( &status, &ret);
		     XMSTreiber= ( status>= 200);      /* min. Version 2.00 */
		  }
		  else
		     XMSTreiber= 0;
		  _harderr( _CritHandler);           /* Fatal_Error Handler */
		  ctrlbrk( BreakHandler);             /* Ctrl-Break Handler */
		  GRP.gruppendir= Gruppenverzeichnis;
		  GRP.gruppe= Gruppenname;
		  GRP_struct_ptr= &GRP;  /* globalen Zeiger auf die Gruppenstruktur setzen */
		  RestoreSys_Temp();
		  if( !Save_DOS&& ( scrbuffer!= NULL))
		  {
		     free( scrbuffer);
		     scrbuffer= NULL;
		  }
		  SetAlarm();
		  InitMouse();        /* Maustreiber und Maus installiert ? */
		  LoschTbuf();               /* alte Tasteneingaben lschen */
		  MouseArt( maus_pfeil);        /* neuen Mauspfeil anzeigen */
		  ShowMouse( AN);
		  MSpeed( mausspeed); /* benutzerdefinierte Geschwindigkeit */
		  LoadFlexLibrary();     /* Dateierweiterungsexpander laden */
		  if( Sounddevice== SOUNDBLASTER)
		     _voc_init_driver();   /* SB-VOC-Treiber initialisieren */
		  Paste_Filter_to_Dir( getcwd( dmanager_path1, MAXDIR), "*.*");
		  sprintf( dmanager_path2, "%c:\\*.*", 'A'+ getdisk());
		  arg_ptr[ 0]= GRP.RB= &RB;
		  arg_ptr[ 1]= Dummy_Balken;
		  arg_ptr[ 2]= arg_ptr[ 3]= GRP.gruppendir;
		  MS.x= &Dummy;
		  MS.y= &Dummy;
		  MS.msg= msg;
		  MS.mauspos= mauspos;
		  MS.arg_ptr= arg_ptr;
		  GRP.MS= &MS;

		  while( TRUE)
		  {
		     if((( (( status= ExistDatei( "~LDM##20.SAV"))!= 0)|| (( status= ExistDatei( "~RDM##20.SAV"))!= 0))&& install)|| (( beginwindow_menu== DATEI_MANAGER)&& !(( argc> 1)&& ( toupper( ( int)argv[ 1][ 1])== 'P'))&& !install)|| (( argc> 1)&& ( toupper( ( int)argv[ 1][ 1])== 'D')&& !install))
			DateiManager( status);
		     else
		     {
			PCX_Window( MS.x, MS.y, PCX_PROGRAMMANAGER, NULL, NO_SHADOW);
			uhrsp= INIT;
			Clock();
			ProgAnz( &GRP);
			if(( argc> 1)&& ( toupper( ( int)argv[ 1][ 1])== 'I')&& !install)
			{
			   __CheckMousepos( &MS);
			   if( FindProgs( &GRP))
			   {
			      RBalken_Begin( GRP.MS, GRP.RB);
			      Mark_of_pos( &GRP, 0);
			      GRP.Neu= GRP_REDRAW;
			      ProgAnz( &GRP);
			   }
			}
			#ifdef COPYRIGHT
			   if( !install)
			      FR_Adresse();
			#endif
			install= AN;
			ret= 0;
			do
			{
			   switch( status= __CheckMousepos( &MS))
			   {
			      case 0:                        /* Uhr stellen */
				 SetClock();
				 break;
			      case 1:                              /* Hilfe */
				 strcpy( prgexe_ptr, "DESKTOP2.DOC");
				 _Editor_Viewer( prgexe_path, VIEW_ASCII, NULL);
				 break;
			      case 2:                               /* Info */
				 FR_Adresse();
				 break;
			      case 3:                              /* Setup */
				 ProgAufnehmen( &GRP);
				 break;
			      case 4:                       /* Dateimanager */
				 DateiManager( 0);
				 GRP.Neu= GRP_REDRAW;
				 MS.statsp= REINIT;
				 ret= NOCHMAL;
				 break;
			      case 5:                            /* Rechner */
				 _Rechner();
				 break;
			      case 6:                      /* SB-Lautstrke */
				 SB_Volume();
				 break;
			      case 7:                          /* CD-Player */
				 CD_Player();
				 break;
			      case 8:                        /* Systemsetup */
				 SysSetup( &GRP);
				 break;
			      case 9:                            /* Beenden */
				 ExitMsg( 255);
				 break;
			      case 10:                   /* direkt geklickt */
				 MoveIcon( &GRP);
				 break;
			      case 11:                      /* Sliderbox */
				 switch( RB.ret_val)
				 {
				    case ONE_ELEMENT_UP:
				    case ONE_ELEMENT_DOWN:
				    case ELEMENT_RANDOM:
				       GRP.Neu= GRP_ALT;
				       ProgAnz( &GRP);
				       break;
				    case POINTER_RETURN:
				       MakeMark( &GRP, 4);
				       break;
				 }
				 break;
			      case 12:                    /* Hauptgruppe */
				 HauptGruppe( &GRP);
				 break;
			      case 13:                    /* Vatergruppe */
				 VaterGruppe( &GRP);
				 break;
			      case 14:                /* Cursorsteuerung */
			      case 15:
			      case 16:
			      case 17:
				 MakeMark( &GRP, status- 14);
				 break;
			      case 18:
				 ChangeEntry( &GRP);
				 break;
			   }
			}while( !ret);
		     }
		  }
	       }
	    }
	 }
      }
   }
}
