/*  RES_OP.C  Resource access operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

typedef struct{ long res_length,
                     res_offset;
              }res_info;

void far pascal _GMove1VE( void far *__Xq, void far *__Yq, void far *__Spalten, void far *__Lines, void far *__Xz, void far *__Yz);

void SCR_move( WORD Xq, WORD Yq, WORD Spalten, WORD Lines, WORD Xz, WORD Yz)
{
   GMove1VE( Xq, Yq, Spalten, Lines, Xz, Yz);
}

void ScrScl( WORD Xanf, WORD Yanf, WORD Xend, WORD Yend, int dist)
{
   GMove1VE( Xanf, Yanf, Xend- Xanf+ 1, Yend- Yanf+ 1, Xanf, ( WORD)( Yanf+ dist));
}

res_info _get_resource_info( BYTE ID)
{
   res_info res_info;
   int i;
   long res_length[]= {    1129L,  /* DAT_INSTALLATIONSDATEN */
                            766L,  /* ICO_FR */
                            766L,  /* ICO_GRUPPE */
                            766L,  /* ICO_OWNERBUTTON */
                           4899L,  /* PCX_ALARM */
                           9271L,  /* PCX_FRAGE */
                          23474L,  /* PCX_ATTRIBUTE_EINZELN */
                          32342L,  /* PCX_ATTRIBUTE */
                          10382L,  /* PCX_ATTRIBUTE_VOREINSTELLUNG */
                          36516L,  /* PCX_AUTOINSTALLATION */
                           9702L,  /* PCX_CDPLAYER */
                           1459L,  /* PCX_KOMMANDOZEILE */
			  64628L,  /* PCX_DATEIMANAGER */
                          19982L,  /* PCX_DATEIAUSWAHLBOX */
                          10945L,  /* PCX_FILTER */
                           8538L,  /* PCX_DATEISORTIERUNG */
                          15870L,  /* PCX_VERZEICHNISBAUM */
                          34068L,  /* PCX_DISKAUFFRISCHEN */
                          34866L,  /* PCX_DISKVERGLEICHEN */
                          36583L,  /* PCX_DISKKOPIEREN */
                          24192L,  /* PCX_DISKINFO */
                          33464L,  /* PCX_DISKLOESCHEN */
                          31611L,  /* PCX_DISKPRUEFEN */
                           8021L,  /* PCX_EDIT_MENU */
                           8513L,  /* PCX_BEENDEN */
                          24977L,  /* PCX_MEHR */
                          23461L,  /* PCX_FATINFO */
                           7918L,  /* PCX_FINDFILE */
                          17930L,  /* PCX_FINDTEXT */
			  30756L,  /* PCX_FORMATIEREN_1 */
                           3780L,  /* PCX_FORMATIEREN_2 */
                           5085L,  /* PCX_ZEIGE_ZEILE */
                           5097L,  /* PCX_GRUPPE_UMNENNEN */
                          14460L,  /* PCX_GRUPPENINSTALLATION */
                           2470L,  /* PCX_GRUPPE */
                          20001L,  /* PCX_ICONAUSWAHL */
                          12407L,  /* PCX_ICON_EXTRAHIEREN */
                           5872L,  /* PCX_INFO */
                          10502L,  /* PCX_KOPIEREN */
                           7866L,  /* PCX_KOP_VERS_FRAGE */
                           8543L,  /* PCX_DISKLABEL */
                           4565L,  /* PCX_EDITOR_LEISTE */
                          22004L,  /* PCX_EDITOR_VIEWER */
                           4347L,  /* PCX_VIEWER_LEISTE */
                           6779L,  /* PCX_LOESCHEN */
                          14113L,  /* PCX_LWANWAHL */
                          11789L,  /* PCX_LWAUSWAHL */
                           9027L,  /* PCX_PARAMETERFENSTER */
                          13558L,  /* PCX_PRG_START */
                          13738L,  /* PCX_PROGRAMM_GRUPPE_AUSWAHL */
                          20205L,  /* PCX_PROGRAMMINSTALLATION */
			  34406L,  /* PCX_PROGRAMMANAGER */
                          12682L,  /* PCX_SORTIEREN */
                           5038L,  /* PCX_PROGRAMM_UMNENNEN */
                          19791L,  /* PCX_Q_Z_INFO */
                          21924L,  /* PCX_RECHNER */
                           7573L,  /* PCX_RENAME_EINZELN */
                           8994L,  /* PCX_RENAME */
                          10107L,  /* PCX_RENAME_VOREINSTELLUNG */
                           7990L,  /* PCX_SB_VOLUME */
                          15521L,  /* PCX_FARBENSETZEN */
                           8228L,  /* PCX_MAUSEINSTELLUNGEN */
                           7626L,  /* PCX_EDITOR_SPEICHERN_UNTER */
                           6007L,  /* PCX_TEXT_SUCHEN */
                          15121L,  /* PCX_SYSTEMEINSTELLUNGEN */
                          30088L,  /* PCX_UHRSTELLEN */
                          10286L,  /* PCX_VERSCHIEBEN */
                          32725L,  /* PCX_VERSION */
                          36201L,  /* PCX_VERSCHIEDENES_SETZEN */
                           7850L,  /* PCX_VERZEICHNIS_ERSTELLEN */
                           2302L,  /* PCX_PRINT */
                          28980L,  /* PCX_VIEWFILTER */
                           5545L,  /* PCX_VIEWER_HEX_ASCII */
                            752L,  /* TXT_FLEXLIBRARY_DEFAULT */
                          21695L,  /* VOC_ALARM */
                           8779L,  /* VOC_ERROR */
                          32019L,  /* VOC_READY */
                          18977L,  /* VOC_HINWEIS */
                      };
   res_info.res_length= res_length[ ID];
   res_info.res_offset= 0L;
   for( i= 0; i< ID; i++)
      res_info.res_offset+= res_length[ i];
   return( res_info);
}

long _resource_length( BYTE ID)
{
   res_info res_info;

   res_info= _get_resource_info( ID);
   return( res_info.res_length);
}

int _resource_open( BYTE ID)
{
   res_info res_info;
   int handle, ret_val;
   char prgexe_ptr_sp[ MAXPATH];

   res_info= _get_resource_info( ID);
   strcpy( prgexe_ptr_sp, prgexe_ptr);
   strcpy( prgexe_ptr, "RESOURCE.DB2");
   ret_val= _dos_open( prgexe_path, O_RDONLY, &handle);
   strcpy( prgexe_ptr, prgexe_ptr_sp);
   if( ret_val== 0)
   {
      if( lseek( handle, res_info.res_offset, SEEK_SET)!= -1L)
         return( handle);
   }
   return( -1);
}

void *open_resource_ICO( BYTE ID)
{
   int handle;
   BYTE *ICO_ptr;

   if(( handle= _resource_open( ID))!= -1)
   {
      if( lseek( handle, 0x7EL, SEEK_CUR)!= -1L)
      {
         if(( ICO_ptr= malloc( 640))!= NULL)
         {
            if( read( handle, ICO_ptr, 640)!= -1)
            {
               _dos_close( handle);
               return( ICO_ptr);
            }
            free( ICO_ptr);
         }
      }
      _dos_close( handle);
   }
   return( NULL);
}

void close_resource_ICO( void *ICO_ptr)
{
   free( ICO_ptr);
}

void _Icon( WORD X, WORD Y, BYTE ID)
{
   int handle;
   BYTE *ICO_ptr;

   if(( ICO_ptr= open_resource_ICO( ID))!= NULL)
   {
      DrawIcon( X, Y, ICO_ptr);
      close_resource_ICO( ICO_ptr);
   }
}

void ShowPicture( WORD X, WORD Y, char *file)
{
   int handle;
   BYTE *mem_ptr;

   if(( handle= _open( file, O_RDONLY))!= -1)
   {
      if( lseek( handle, 0x7EL, SEEK_SET)!= -1L)
      {
         if(( mem_ptr= malloc( 640))!= NULL)
         {
            if( read( handle, mem_ptr, 640)!= -1)
               DrawIcon( X, Y, mem_ptr);
            free( mem_ptr);
         }
      }
      _close( handle);
   }
   else
      ErrorMsg( OPEN_ERROR"?.ICO");
}

void far pascal _ShowPCX( BYTE __W_Bitplane, BYTE __R_Bitplane, void far *__Z_end_ptr, void far *__END_ptr, void far *__SCR_ptr, void far *__file_ptr, WORD __W_Maske);

#define PCX_HEADER_LENGTH  128

int PCX_Window( WORD *X, WORD *Y, BYTE ID, saveall *sa, BYTE Mode)
{
   int handle, ret_val= 0;
   unsigned read_len, gelesen, anz_fill;
   WORD PCX_Width, PCX_Height, BYTE_Zeile, X_end, W_Maske;
   unsigned long file_length;
   BYTE W_Bitplane= 0x80, R_Bitplane= 0, *file_ptr, *PCX_ptr, *SCR_ptr,
        *END_ptr, *Z_end_ptr, *PlaneSCR_ptr, Maske;

   ShowMouse( AUS);
   if(( handle= _resource_open( ID))!= -1)
   {
      file_length= _resource_length( ID)- PCX_HEADER_LENGTH;
      if(( PCX_ptr= farmalloc( file_length))!= NULL)
      {
         outportb( 0x3C4, 2);           /* Index auf's Map Mask Register */
         if( _dos_read( handle, PCX_ptr, PCX_HEADER_LENGTH, &gelesen)== 0)
         {
            if(( *PCX_ptr== 0x0A)&& ( *( PCX_ptr+ 3)== 1))  /* Datei-Identifikation */
            {
               PCX_Width=  *( WORD *)( PCX_ptr+  8)- *( WORD *)( PCX_ptr+  4);
               PCX_Height= *( WORD *)( PCX_ptr+ 10)- *( WORD *)( PCX_ptr+  6);
               BYTE_Zeile= *( WORD *)( PCX_ptr+ 66)- 1;
               *X&= 0xFFF8;    /* macht aus X eine durch 8 teilbare Zahl */
               X_end= *X+ PCX_Width;
               if( Mode== SHADOW)
               {
                  if( X_end> 636)
                  {
                     *X= ( *X- ( X_end- 636))& 0xFFF8;
                     X_end= *X+ PCX_Width;
                  }
               }
               else
               {
                  if( X_end> 639)
                  {
                     *X= ( *X- ( X_end- 639))& 0xFFF8;
                     X_end= *X+ PCX_Width;
                  }
               }
               if( sa!= NULL)
               {
                  if( Mode== SHADOW)
                  {
                     if( BigScreenSave( sa, *X, *Y, X_end+ 3, *Y+ PCX_Height+ 3))
                        ret_val= -4;
                  }
                  else
                  {
                     if( BigScreenSave( sa, *X, *Y, X_end, *Y+ PCX_Height))
                        ret_val= -4;
                  }
               }
               W_Maske= Maske= ( ( BYTE)0xFF)<< (( 8- (( X_end+ 1)& 7))& 7);
               asm{
                     not W_Maske
                     sal W_Maske, 8
                  }
               W_Maske|= Maske;
               file_ptr= PCX_ptr;
               do
               {
                  if( file_length> 65535L)
                     read_len= 65535;
                  else
                     read_len= file_length;
                  if( _dos_read( handle, file_ptr, read_len, &gelesen)!= 0)
                  {
                     if(( sa!= NULL)&& ( ret_val== 0))
                        BigScreenRestore( sa, *X, *Y);
                     ret_val= -1;
                     break;
                  }
                  ( ptrdiff_t)file_ptr+= gelesen;
                  file_length-= gelesen;
               }while( file_length> 0L);
               if( ret_val== 0)                        /* kein Fehler aufgetreten */
               {
                  END_ptr= file_ptr;
                  file_ptr= PCX_ptr;
                  Z_end_ptr= ( SCR_ptr= MK_FP( 0xA000, ( *Y)* 80+ (( *X)>> 3)))+ BYTE_Zeile;
                  ShowPCX( W_Bitplane, R_Bitplane, Z_end_ptr, END_ptr, SCR_ptr, file_ptr, W_Maske);
                  if( Mode== SHADOW)
                     Fensterschatten( *X, *Y, X_end, *Y+ PCX_Height);
               }
            }
            else
               ret_val= -2;
         }
         else
            ret_val= -1;
         farfree( PCX_ptr);
      }
      else
         ret_val= -3;
      _dos_close( handle);
   }
   else
      ret_val= -3;
   ShowMouse( AN);
   return( ret_val);
}