/*  WINDOWS.C  MS-Windows 3.x related operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <io.h>
#include <conio.h>
#include <fcntl.h>
#include <alloc.h>
#include <dir.h>
#include <string.h>
#include <graphics.h>
#include "pal_op.h"
#include "defines.h"
#include "msg.h"

#define RT_ICON       3
#define END_RESSOURCE 0

WORD Is_Window_EXE( char *file)
{
   int handle;
   BYTE buf[ 0x40];
   WORD ret_val= 0;

   if(( handle= _open( file, O_RDONLY))!= -1)
   {
      if( read( handle, buf, 0x40)!= -1)
      {
	 if( lseek( handle, *( DWORD *)( buf+ 0x3C), SEEK_SET)!= -1)
	 {
	    if( read( handle, buf, 0x40)!= -1)
	    {
	       if( *( WORD *)buf== 0x454E)  /* ist es ein Windowsprogramm ? */
		  ret_val= *( WORD *)( buf+ 0x3E); /* erwartete Windowsversion */
	    }
	 }
      }
      _close( handle);
   }
   return( ret_val);             /* 0= Fehler, >0= erwartete Windowsversion */
}

int WinEXEIcons( char *file, char *z_path, WORD *lfnr) /* z_path --> LW:\PATH\ */
{
   int ret_val= 0, handle, ico_handle;
   unsigned shift_count, i;
   unsigned long pos_winheader, datpossp, bmi_header;
   char *filename, exename[ 13];
   BYTE *buf;
   BYTE ico_header[]= "\x00\x00\x01\x00\x01\x00\x20\x20\x10\x00\x00\x00\x00\x00\xE8\x02"
		      "\x00\x00\x16\x00\x00\x00\x28\x00\x00\x00\x20\x00\x00\x00\x40\x00"
		      "\x00\x00\x01\x00\x04\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00"
		      "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		      "\x00\x00\x00\x00\x80\x00\x00\x80\x00\x00\x00\x80\x80\x00\x80\x00"
		      "\x00\x00\x80\x00\x80\x00\x80\x80\x00\x00\x80\x80\x80\x00\xC0\xC0"
		      "\xC0\x00\x00\x00\xFF\x00\x00\xFF\x00\x00\x00\xFF\xFF\x00\xFF\x00"
		      "\x00\x00\xFF\x00\xFF\x00\xFF\xFF\x00\x00\xFF\xFF\xFF";

   filename= strrchr( z_path, '\\')+ 1;
   strcpy( exename, strrchr( file, '\\')+ 1);
   *strrchr( exename, '.')= '\0';
   *( exename+ 5)= '\0';
   if(( handle= _open( file, O_RDONLY))!= -1)
   {
      if(( buf= malloc( 1024))!= NULL)
      {
	 if( _read( handle, buf, 0x40)!= -1)
	 {
	    pos_winheader= *( DWORD *)( buf+ 0x3C);
	    if(( lseek( handle, pos_winheader, SEEK_SET)!= -1)&& ( read( handle, buf, 0x40)!= -1))
	    {
	       if(( *( WORD *)buf== 0x454E)&& ( *( WORD *)( buf+ 0x3E)>= 0x0300))  /* min. WINDOWS 3.x Programm ? */
	       {
		  if(( lseek( handle, pos_winheader+ *( WORD *)( buf+ 0x24), SEEK_SET)!= -1)&& ( read( handle, &shift_count, sizeof( shift_count))!= -1))
		  {
		     if( shift_count< 32)  /* wrde sonst ungltige Werte ergeben */
		     {
			while( !ret_val)
			{
			   if( _read( handle, buf, 8)!= -1)
			   {
			      if( *( WORD *)buf== ( WORD)( 0x8000| RT_ICON))
			      {
				 for( i= *( WORD *)( buf+ 2); !ret_val&& ( i> 0); i--)
				 {
				    if(( _read( handle, buf, 12)!= -1)&& (( datpossp= tell( handle))!= -1L)&& ( lseek( handle, ( long)( *( WORD *)buf)<< shift_count, SEEK_SET)!= -1)&& ( read( handle, buf, 1024)!= -1))
				    {
				       if(( *( DWORD *)( buf+ 4)== 0x20L)&& ( *( DWORD *)( buf+ 8)== 0x40L)&& ( *( WORD *)( buf+ 14)== 0x04))  /* BITMAPINFOHEADER auswerten, ist es ein 32x32-16Color-Icon ? */
				       {
					  bmi_header= *( DWORD *)buf;
					  sprintf( filename, "%s%03d.ICO", exename, *lfnr);    /* beeinflut SETUP (Iconaufnehmen) */
					  if(( ico_handle= _creat( z_path, 0))!= -1)
					  {
					     if(( _write( ico_handle, ico_header, sizeof( ico_header))!= -1)&& ( write( ico_handle, buf+ bmi_header+ 0x40, 640)!= -1))
					     {
						_close( ico_handle);
						( *lfnr)++;
					     }
					     else
					     {
						_close( ico_handle);
						unlink( z_path);
						ErrorMsg( WRITE_ERROR"*.ICO");
						ret_val= -1;
					     }
					  }
					  else
					  {
					     ErrorMsg( CREAT_ERROR"*.ICO");
					     ret_val= -1;
					  }
				       }
				       if( lseek( handle, datpossp, SEEK_SET)== -1)
				       {
					  ErrorMsg( READ_ERROR"WIN-EXE");
					  ret_val= -1;
				       }
				    }
				    else
				    {
				       ErrorMsg( READ_ERROR"WIN-EXE");
				       ret_val= -1;
				    }
				 }
				 break;  /* Schleife verlassen, wenn letztes Icon verarbeitet */
			      }
			      else
			      {
				 if( *buf== END_RESSOURCE)  /* letzter Eintrag in der Resourcentabelle ? */
				    break;
				 if( lseek( handle, *( WORD *)( buf+ 2)* 12L, SEEK_CUR)== -1)
				 {
				    ErrorMsg( READ_ERROR"WIN-EXE");
				    ret_val= -1;
				 }
			      }
			   }
			   else
			   {
			      ErrorMsg( READ_ERROR"WIN-EXE");
			      ret_val= -1;
			   }
			}
		     }
		  }
		  else
		  {
		     ErrorMsg( READ_ERROR"WIN-EXE");
		     ret_val= -1;
		  }
	       }
	       else
	       {
		  ErrorMsg( "File is not a normal Windows 3.x program file");
		  ret_val= -1;
	       }
	    }
	    else
	    {
	       ErrorMsg( READ_ERROR"WIN-EXE");
	       ret_val= -1;
	    }
	 }
	 else
	 {
	    ErrorMsg( READ_ERROR"WIN-EXE");
	    ret_val= -1;
	 }
	 free( buf);
      }
      else
      {
	 ErrorMsg( KEIN_SPEICHER);
	 ret_val= -1;
      }
      _close( handle);
   }
   else
   {
      ErrorMsg( OPEN_ERROR"WIN-EXE");
      ret_val= -1;
   }
   if( *lfnr> 0)
      sprintf( filename, "%s000.ICO", exename);
   return( ret_val);
}
