#include <dos.h>
#include <graphics.h>
#include "color.h"
#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <bios.h>
#include <dir.h>
#include "maus.h"
#include "defines.h"

#define CODE_FILTER                     0x80FF   /* Filter fr Elemententyp */
#define CODE_FILTER_TO_BYTE             0x00FF
#define ELEMENTTYPBEZEICHNER_FILTER     0x8000
#define ONLY_FRAME                      1
#define WORK                            0
#define DUP_DIRINPUT                    0x0001
#define DUP_FILEINPUT                   0x0002
#define AFTER_INIT                      0x8000
#define AFTER_INIT_FILTER               0x7FFF

#define FORWARD                         1
#define BACKWARD                        2
#define ANZEIGE                         3

#define TASTENKOMBINATION               0
#define MAUSPOSINDEX                    1
#define ARGPOINTERINDEX                 2
#define POS_AT_ELEMENT                  3

#define RBALKEN_MINUS_MIN               1
#define RBALKEN_PLUS_MIN                2
#define RBALKEN_RANDOM                  3
#define RBALKEN_MINUS_MAX               4
#define RBALKEN_PLUS_MAX                5
#define UP                              1
#define DOWN                            2

#define MIN_Y_TO_MOVE                   23
#define MAX_Y_TO_MOVE                   455
#define MIN_X_TO_MOVE                   0
#define MAX_X_TO_MOVE                   635
#define INPUTZEILENHOEHE                16
#define INPUTZEILENTASTENBREITE         14
#define INPUTTEXT_Xl_ABSTAND            4
#define INPUTTEXT_Yo_ABSTAND            5
#define DATEIAUSWAHLBOXBUTTON_X_LAENGE  46
#define DATEIAUSWAHLBOXBUTTON_Y_LAENGE  34
#define DATEIAUSWAHLBOX_TASTE           'd';
#define DATEIAUSWAHLBOX_RET             2
#define CHECKBOX_X_LAENGE               12
#define CHECKBOX_Y_LAENGE               12
#define RADIOBUTTON_X_RADIUS            8
#define RADIOBUTTON_Y_RADIUS            8
#define FENSTERKOPFHOEHE                24
#define LAUFLEISTENTASTENBREITE         32
#define LAUFLEISTENHOEHE                20
#define LAUFLEISTEN_TASTEN_TEXTABSTAND  3
#define LAUFLEISTENANZEIGE              3
#define VERZEICHNISBAUMBUTTON_X_LAENGE  46
#define VERZEICHNISBAUMBUTTON_Y_LAENGE  34
#define VERZEICHNISBAUM_TASTE           'p';
#define VERZEICHNISBAUM_RET             2
#define INPUTZEILE                      1
#define ROLLBALKENDICKE                 17
#define BALKENFARBE                     EGA_DARKGRAY

struct MouseStat MStat;               /* Speicher des letzten Mausstatusses */

typedef struct
	{
	   WORD tasten, zeiger, anz_Einzelelemente, WORDS_pro_Element;
	}ElementInfo;

WORD maus_pfeil[]= { 0x0002,                               /* horiz. HotSpot */
		     0x0001,                                /* vert. HotSpot */

		     0xFFFF,
		     0xCFFF,
		     0xC7FF,
		     0xC3FF,
		     0xC1FF,
		     0xC0FF,
		     0xC07F,
		     0xC03F,
		     0xC01F,                           /* ScreenMask ( UND ) */
		     0xC00F,
		     0xC007,
		     0xC007,
		     0xE00F,
		     0xFF0F,
		     0xFFFF,
		     0xFFFF,

		     0x0000,
		     0x0000,
		     0x1000,
		     0x1800,
		     0x1C00,
		     0x1E00,
		     0x1F00,
		     0x1F80,                           /* CursorMask ( XOR ) */
		     0x1FC0,
		     0x1FE0,
		     0x1B80,
		     0x01C0,
		     0x0000,
		     0x0000,
		     0x0000,
		     0x0000 };

void ShowMouse( char e_a)           /* Schaltet den Mauscursor ein- und aus */
{
   if( globalmaus== AN)
   {
      if( !e_a)                                                      /* aus */
	 RP.r_ax= 2;
      else
	 RP.r_ax= 1;                                                 /* ein */
      intr( MAUS_INT, &RP);
   }
}

int InitMouse( void)                                 /* Hardware vorhanden? */
{
   RP.r_ax= 0;
   intr( MAUS_INT, &RP);
   return( RP.r_ax);
}

void MouseArt( unsigned mausarray[])          /* neuen Mauscursor einbinden */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 9;
      RP.r_bx= mausarray[ 0];
      RP.r_cx= mausarray[ 1];
      RP.r_es= FP_SEG( &mausarray[ 2]);
      RP.r_dx= FP_OFF( &mausarray[ 2]);
      intr( MAUS_INT, &RP);
   }
}

void MSpeed( int speed)                           /* Geschwindigkeit setzen */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 15;
      RP.r_cx= speed;
      RP.r_dx= speed;
      intr( MAUS_INT, &RP);
   }
}

WORD MouseStat( void)                    /* Status des Mauszeigers abfragen */
{
   if( globalmaus== AUS)
   {
      MStat.x=       RP.r_cx= 0;
      MStat.y=       RP.r_dx= 0;
      MStat.buttons= RP.r_bx= NOTHING;
   }
   else
   {
      RP.r_ax= 0x03;
      intr( MAUS_INT, &RP);
      MStat.x=       RP.r_cx;
      MStat.y=       RP.r_dx;
      MStat.buttons= RP.r_bx;
   }
   return( RP.r_bx);
}

void ClearStatus( void)
{
   if( msg_to_Klick== AUS)
   {
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      ShowMouse( AUS);
      bar( 10, 460, 559, 474);
      ShowMouse( AN);
   }
}

void PrintStatus( char *string)
{
   if( msg_to_Klick== AUS)
   {
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      ShowMouse( AUS);
      bar( 10, 460, 559, 474);
      setcolor( EGA_BLACK);
      outtextxy( 15, 463, string);
      ShowMouse( AN);
   }
}

void PrintStatus_to_Klick( char *string)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( 10, 460, 559, 474);
   setcolor( EGA_BLACK);
   outtextxy( 15, 463, string);
   ShowMouse( AN);
   msg_to_Klick= AN;
}

void ErrorMsg( char *msg)
{
   char errormsg[ 69];                /* Statuszeile umfat max. 68 Zeichen */

   sprintf( errormsg, "ERROR: %s", msg);
   PrintStatus_to_Klick( errormsg);
   ErrorSound();
}

void Hinweis( char *msg)                                  /* max 59 Zeichen */
{
   char Hinweis_msg[ 69];             /* Statuszeile umfat max. 68 Zeichen */

   sprintf( Hinweis_msg, "HINT: %s", msg);
   PrintStatus_to_Klick( Hinweis_msg);
   HinweisSound();
}

void CheckBox( int Xlo, int Ylo, int zust)
{
   char color;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( Xlo+ 1, Ylo+ 1, Xlo+ 11, Ylo+ 11);
   if( zust)
   {
      setcolor( EGA_BLACK);
      line( Xlo+ 2, Ylo+ 6, Xlo+ 2, Ylo+ 10);
      line( Xlo+ 3, Ylo+ 5, Xlo+ 3, Ylo+ 10);
      line( Xlo+ 4, Ylo+ 8, Xlo+ 9, Ylo+ 3);
      line( Xlo+ 4, Ylo+ 9, Xlo+ 10, Ylo+ 3);
   }
   setcolor( EGA_WHITE);
   line( Xlo, Ylo, Xlo+ 12, Ylo);
   line( Xlo, Ylo, Xlo, Ylo+ 12);
   setcolor( EGA_DARKGRAY);
   line( Xlo+ 12, Ylo, Xlo+ 12, Ylo+ 12);
   line( Xlo, Ylo+ 12, Xlo+ 12, Ylo+ 12);
   setcolor( color);
}

void OutLineTextxy( int x, int y, char *text, int ausw)
{
   int linex;

   outtextxy( x, y, text);
   if( ausw)
   {
      linex= x+ (( ausw- 1)<< 3)- 1;
      line( linex, y+ 9, linex+ 8, y+ 9);
   }
}

void Button( int Xl, int Yo, int Xr, int Yu, char *text, int ausw)
{
   int textx, texty, linex;
   char color;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( Xl+ 2, Yo+ 2, Xr- 2, Yu- 2);
   setcolor( EGA_WHITE);
   line( Xl- 1, Yu+ 1, Xr+ 1, Yu+ 1);
   line( Xr+ 1, Yo- 1, Xr+ 1, Yu+ 1);
   line( Xr- 1, Yo+ 1, Xl+ 1, Yo+ 1);
   line( Xl+ 1, Yo+ 1, Xl+ 1, Yu- 1);
   setcolor( EGA_DARKGRAY);
   line( Xl- 1, Yo- 1, Xl- 1, Yu+ 1);
   line( Xl- 1, Yo- 1, Xr, Yo- 1);
   line( Xl+ 2, Yu- 2, Xr- 1, Yu- 2);
   line( Xl+ 1, Yu- 1, Xr- 1, Yu- 1);
   line( Xr- 2, Yu- 1, Xr- 2, Yo+ 2);
   line( Xr- 1, Yu- 1, Xr- 1, Yo+ 1);
   setcolor( EGA_BLACK);
   rectangle( Xl, Yo, Xr, Yu);
   OutLineTextxy(( Xl+ (( Xr- Xl)>> 1)- ( strlen( text)<< 2)), ( Yo+ (( Yu- Yo)>> 1)- 3), text, ausw);
   setcolor( color);
}

void LoschTbuf( void)
{
   disable();
   *( int far *)MK_FP( 0x40, 0x1A)= *( int far *)MK_FP( 0x40, 0x1C);
   enable();
}

void While_Klick( void)
{
   while( MouseStat()!= NOTHING)
      ;
}

int WaitDelay( int wert)
{
   int i;

   for( i= 0; i< wert; i++)
   {
      LoschTbuf();
      MouseStat();
      if(( MStat.buttons== NOTHING)&& ( inportb( 0x60)>= 128))
	 return( 1);
      delay( 1);
   }
   return( 0);
}

void ButtonDown( void far *ptr[ 1], int x1, int y1, int x2, int y2)
{
   if(( ptr[ 0]= malloc( imagesize( x1+ 2, y1+ 2, x2- 2, y2- 2)))!= NULL)
   {
      ShowMouse( AUS);
      getimage( x1+ 2, y1+ 2, x2- 2, y2- 2, ptr[ 0]);
      putimage( x1+ 3, y1+ 3, ptr[ 0], COPY_PUT);
      setcolor( EGA_DARKGRAY);
      line( x2- 1, y1+ 1, x1+ 1, y1+ 1);
      line( x1+ 1, y1+ 1, x1+ 1, y2- 1);
      setcolor( EGA_LIGHTGRAY);
      line( x1+ 2, y1+ 2, x1+ 2, y2- 2);
      line( x1+ 3, y1+ 2, x2- 2, y1+ 2);
      line( x1+ 2, y2- 1, x2- 1, y2- 1);
      line( x2- 1, y2- 2, x2- 1, y1+ 2);
      ShowMouse( AN);
      OkSound();
   }
   else
   {
      closegraph();
      puts( "Not enough memory");
      exit( -1);
   }
}

void ButtonUp( void far *ptr[ 1], int x1, int y1, int x2, int y2)
{
   ShowMouse( AUS);
   putimage( x1+ 2, y1+ 2, ptr[ 0], COPY_PUT);
   setcolor( EGA_DARKGRAY);
   line( x2- 1, y1+ 2, x2- 1, y2- 1);
   line( x1+ 2, y2- 1, x2- 2, y2- 1);
   setcolor( EGA_WHITE);
   line( x1+ 1, y1+ 1, x2- 2, y1+ 1);
   line( x1+ 1, y1+ 2, x1+ 1, y2- 2);
   ShowMouse( AN);
   free( ptr[ 0]);
}

BOOL IsMouseInArea( int x1, int y1, int x2, int y2)
{
    MouseStat();
    return(( MStat.x>= x1)&& ( MStat.x<= x2)&& ( MStat.y>= y1)&& ( MStat.y<= y2));
}

BOOL KlickButton( int x1, int y1, int x2, int y2)
{
   char color;
   BOOL buttonDown= FALSE, mouseInArea= TRUE;
   void far *ptr[ 1];

   if( MStat.buttons!= NOTHING)
   {
      color= getcolor();
      do
      {
	 mouseInArea= IsMouseInArea( x1, y1, x2, y2);
	 if( !buttonDown&& mouseInArea)
	 {
	    ButtonDown( ptr, x1, y1, x2, y2);
	    buttonDown= TRUE;
	 }
	 if( buttonDown&& ( !mouseInArea|| ( MStat.buttons== NOTHING)))
	 {
	    ButtonUp( ptr, x1, y1, x2, y2);
	    buttonDown= FALSE;
	 }
      }while(( MStat.buttons!= NOTHING)|| buttonDown);
      setcolor( color);
   }
   return( mouseInArea);
}

void WhiteClearN( int x, int y, int laenge)
{
   setfillstyle( SOLID_FILL, EGA_WHITE);
   bar( x- 1, y- 3, x+ 1+ ( laenge<< 3), y+ 10);
}

void OutTextN( int x, int y, char *text, int anz)
{
   char buffer[ 81];

   strncpy( buffer, text, anz);
   buffer[ anz]= '\0';
   setcolor( EGA_BLACK);
   outtextxy( x, y, buffer);
}

void InitInputLine( MAUSStruct *MS, int index, int ptr_index)
{
   WhiteClearN( MS->mauspos[ index+ 1]+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND+ *MS->x, MS->mauspos[ index+ 2]+ INPUTTEXT_Yo_ABSTAND+ *MS->y, (( MS->mauspos[ index+ 3]- (( INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND)<< 1))>> 3));
   OutTextN( MS->mauspos[ index+ 1]+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND+ *MS->x, MS->mauspos[ index+ 2]+ INPUTTEXT_Yo_ABSTAND+ *MS->y, ( char *)MS->arg_ptr[ ptr_index], (( MS->mauspos[ index+ 3]- (( INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND)<< 1))>> 3));
}

void ScollInputLine( int x_anzeige, int y_anzeige, int *anzeigepos, int maxanzeige, int maxzeichen, char *inpptr, char *input)
{
   if(( *anzeigepos> ( maxanzeige- 1))&& ( inpptr< ( input+ maxzeichen+ 1)))
   {
      ( *anzeigepos)--;
      ShowMouse( AUS);
      WhiteClearN( x_anzeige, y_anzeige, maxanzeige);
      OutTextN( x_anzeige, y_anzeige, inpptr- ( maxanzeige- 1), maxanzeige- 1);
      ShowMouse( AN);
   }
   if(( *anzeigepos< 0)&& ( inpptr>= input))
   {
      ( *anzeigepos)++;
      ShowMouse( AUS);
      WhiteClearN( x_anzeige, y_anzeige, maxanzeige);
      OutTextN( x_anzeige, y_anzeige, inpptr, maxanzeige);
      ShowMouse( AN);
   }
}

void InputReverse( int x, int y, int laenge)
{
   int t_laenge;

   t_laenge= laenge<< 3;
   setcolor( 0x0F);
   setwritemode( XOR_PUT);
   line( x- 1, y- 3, x+ t_laenge, y- 3);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   line( x- 1, y- 1, x+ t_laenge, y- 1);
   line( x- 1, y+ 2, x+ t_laenge, y+ 2);
   line( x- 1, y+ 5, x+ t_laenge, y+ 5);
   line( x- 1, y+ 8, x+ t_laenge, y+ 8);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

int extended_ungetch( int Tastatur_Code)
{
   WORD *next_char= MK_FP( 0x0040, 0x001A),
	*last_char= MK_FP( 0x0040, 0x001C);

   if( *next_char== 0x001E)
   {
      if( *last_char== 0x003C)                     /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char= 0x003C;
   }
   else
   {
      if(( *next_char- 2)== *last_char)            /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char-= 2;
   }
   *( WORD *)MK_FP( 0x0040, *next_char)= Tastatur_Code<< 8;
   return( Tastatur_Code);
}

int _Input( int x, int y, int laenge, char *buffer, int maxzeichen)
{
   int anzeigepos= 0, taste, ret= 0, l, i, maxanzeige, start_length, x_anzeige, y_anzeige;
   char *input, *inpptr, loeschflag, del, cursor= AUS, Anzeigen= AUS;
   void far *ptr[ 2];

   x_anzeige= x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND;  /* Anzeige relativ zum Inputfeld */
   y_anzeige= y+ INPUTTEXT_Yo_ABSTAND;
   maxanzeige= (( laenge- ( INPUTZEILENTASTENBREITE<< 1))>> 3)- 1;
   if(( inpptr= input= calloc( maxzeichen+ 2, sizeof( char)))== NULL)   /* mit \0 initialisierten Speicher anfordern */
   {
      ErrorMsg( "Not enough memory");
      ret= -1;
   }
   else
   {
      ShowMouse( AUS);
      WhiteClearN( x_anzeige, y_anzeige, maxanzeige);
      ShowMouse( AN);
      if( buffer[ 0])                      /* String zu Anzeige bergeben ? */
      {
	 strncpy( input, buffer, maxzeichen);     /* \0 ist schon vorhanden */
	 ShowMouse( AUS);
	 OutTextN( x_anzeige, y_anzeige, input, maxanzeige);
	 (( l= strlen( input))> maxanzeige) ? ( start_length= maxanzeige) : ( start_length= l);
	 InputReverse( x_anzeige, y_anzeige, start_length);
	 ShowMouse( AN);
	 loeschflag= AN;
      }
      else
	 loeschflag= AUS;
      do
      {
	 MouseStat();
	 if( MStat.buttons!= NOTHING)
	 {
	    if( loeschflag== AN)
	    {
	       ShowMouse( AUS);
	       InputReverse( x_anzeige, y_anzeige, start_length);
	       ShowMouse( AN);
	    }
	    loeschflag= AUS;
	    if(( MStat.x>= x)&& ( MStat.x<= ( x+ laenge))&& ( MStat.y>= y)&& ( MStat.y<= y+ 16))
	    {
	       if(( MStat.x<= x_anzeige+ (( anzeigepos<< 3)+ ( strlen( inpptr)<< 3))+ 7)&& ( MStat.x>= x_anzeige)&& ( MStat.x<= x_anzeige+ (( maxanzeige- 1)<< 3)))
	       {
		  i= ( MStat.x- x_anzeige)>> 3;
		  inpptr+= i- anzeigepos;
		  anzeigepos= i;
	       }
	       else
	       {
		  if(( MStat.x>= x)&& ( MStat.x<= ( x+ 14)))    /* linke Taste */
		  {
		     del= AN;
		     ButtonDown( ptr, x, y, x+ 14, y+ 16);
		     if( anzeigepos> 0)               /* Cursor zum Feldanfang */
		     {
			inpptr-= anzeigepos;
			anzeigepos= 0;
		     }
		     do
		     {
			LoschTbuf();
			MouseStat();
			if( inpptr> input)
			{
			   inpptr--;
			   anzeigepos--;
			   ScollInputLine( x_anzeige, y_anzeige, &anzeigepos, maxanzeige, maxzeichen, inpptr, input);
			   delay( 30);
			}
			if( del== AN)
			   if( WaitDelay( 600))
			      break;
			del= AUS;
		     }while(( MStat.buttons!= NOTHING)|| ( inportb( 0x60)< 128));
		     ButtonUp( ptr, x, y, x+ 14, y+ 16);
		  }
		  else
		  {
		     if(( MStat.x>= ( x+ laenge- 14))&& ( MStat.x<= ( x+ laenge)))    /* rechte Taste */
		     {
			del= AN;
			ButtonDown( ptr, x+ laenge- 14, y, x+ laenge, y+ 16);
			if( anzeigepos< ( maxanzeige- 1)) /* Cursor zum Feldende */
			{
			   if(( i= strlen( input))< maxanzeige)
			   {
			      inpptr= input+ i;
			      anzeigepos= i;
			   }
			   else
			   {
			      inpptr+= ( maxanzeige- 1)- anzeigepos;
			      anzeigepos= maxanzeige- 1;
			   }
			}
			do
			{
			   LoschTbuf();
			   MouseStat();
			   if( inpptr< ( input+ strlen( input)))
			   {
			      inpptr++;
			      anzeigepos++;
			      ScollInputLine( x_anzeige, y_anzeige, &anzeigepos, maxanzeige, maxzeichen, inpptr, input);
			      delay( 30);
			   }
			   if( del== AN)
			      if( WaitDelay( 600))
				 break;
			   del= AUS;
			}while(( MStat.buttons!= NOTHING)|| ( inportb( 0x60)< 128));
			ButtonUp( ptr, x+ laenge- 14, y, x+ laenge, y+ 16);
		     }
		  }
	       }
	       while( MStat.buttons!= NOTHING)
		  MouseStat();
	    }
	    else
	    {
	       ret= 1;
	       continue;
	    }
	 }
	 if( kbhit())
	 {
	    if( loeschflag== AN)
	    {
	       ShowMouse( AUS);
	       InputReverse( x_anzeige, y_anzeige, start_length);
	       ShowMouse( AN);
	    }
	    switch( taste= getch())
	    {
	       case BACKSPACE:
		  if( inpptr> input)
		  {
		     loeschflag= AUS;
		     memmove( inpptr- 1, inpptr, maxzeichen+ 1- ( inpptr- input));
		     inpptr--;
		     anzeigepos--;
		     Anzeigen= AN;
		  }
		  break;
	       case TAB:
	       case STRG_RETURN:
		  ungetch( taste);
	       case RETURN:
		  ret= 1;
		  continue;
	       case ESC:
		  anzeigepos= 0;
		  loeschflag= AN;
		  inpptr= input;
		  if( buffer[ 0])
		  {
		     strncpy( input, buffer, maxzeichen);
		     input[ maxzeichen]= '\0';
		     Anzeigen= AN;
		  }
		  else
		  {
		     ShowMouse( AUS);
		     WhiteClearN( x_anzeige, y_anzeige, maxanzeige);
		     ShowMouse( AN);
		     input[ 0]= '\0';
		  }
		  break;
	       default:
		  if( loeschflag== AN)
		  {
		     ShowMouse( AUS);
		     WhiteClearN( x_anzeige, y_anzeige, maxanzeige);
		     ShowMouse( AN);
		     memset( input, '\0', maxzeichen+ 1);
		     loeschflag= AUS;
		  }
		  if(( inpptr< ( input+ maxzeichen))&& (( inpptr+ strlen( inpptr))< ( input+ maxzeichen)))
		  {
		     memmove( inpptr+ 1, inpptr, maxzeichen+ 1- ( inpptr- input));
		     *inpptr= taste;
		     ShowMouse( AUS);
		     WhiteClearN( x_anzeige+ ( anzeigepos<< 3), y_anzeige, 1);
		     OutTextN( x_anzeige+ ( anzeigepos<< 3), y_anzeige, inpptr, 1);
		     ShowMouse( AN);
		     inpptr++;
		     anzeigepos++;
		     Anzeigen= AN;
		  }
		  break;
	       case 0:                              /* erweiterter IBM-Code */
		  loeschflag= AUS;
		  switch( taste= getch())
		  {
		     case SHIFT_TAB:
			extended_ungetch( taste);
			ret= 1;
			continue;
		     case CURSOR_LEFT:
			if( inpptr> input)
			{
			   inpptr--;
			   anzeigepos--;
			}
			break;
		     case CURSOR_RIGHT:
			if( inpptr< ( input+ strlen( input)))
			{
			   inpptr++;
			   anzeigepos++;
			}
			break;
		     case DELETE:
			if( inpptr< ( input+ strlen( input)))
			{
			   memmove( inpptr, inpptr+ 1, maxzeichen+ 1- ( inpptr- input)- 1);
			   Anzeigen= AN;
			}
			break;
		     case HOME:
			inpptr= input;
			anzeigepos= 0;
			Anzeigen= AN;
			break;
		     case END:
			inpptr= input+ strlen( input);
			if( strlen( input)< maxanzeige)
			   anzeigepos= strlen( input);
			else
			   anzeigepos= maxanzeige;
			Anzeigen= AN;
			break;
		  }
		  break;

	    }
	    if( Anzeigen== AN)
	    {
	       ShowMouse( AUS);
	       WhiteClearN( x_anzeige+ ( anzeigepos<< 3), y_anzeige, maxanzeige- anzeigepos);
	       OutTextN( x_anzeige+ ( anzeigepos<< 3), y_anzeige, inpptr, maxanzeige- anzeigepos);
	       if( taste== ESC)
		  InputReverse( x_anzeige, y_anzeige, start_length);
	       ShowMouse( AN);
	       Anzeigen= AUS;
	    }
	    ScollInputLine( x_anzeige, y_anzeige, &anzeigepos, maxanzeige, maxzeichen, inpptr, input);
	 }
	 i= 0;
	 setcolor( 0x0F);
	 setwritemode( XOR_PUT);
	 while( 1)
	 {
	    ShowMouse( AUS);
	    line( x_anzeige+ ( anzeigepos<< 3)- 1, y_anzeige+ 8, x_anzeige+ ( anzeigepos<< 3)- 1, y_anzeige+ 8);
	    line( x_anzeige+ ( anzeigepos<< 3)+ 8, y_anzeige+ 8, x_anzeige+ ( anzeigepos<< 3)+ 8, y_anzeige+ 8);
	    line( x_anzeige+ ( anzeigepos<< 3)- 1, y_anzeige+ 9, x_anzeige+ ( anzeigepos<< 3)+ 8, y_anzeige+ 9);
	    ShowMouse( AN);
	    ( cursor== AN) ? ( cursor= AUS) : ( cursor= AN);
	    if( i&& ( cursor== AUS))
	       break;
	    for( l= 0; l<= 150; l++)
	    {
	       delay( 1);
	       MouseStat();
	       if(( kbhit())|| ( MStat.buttons!= NOTHING))
	       {
		  i= -1;
		  break;
	       }
	    }
	    if( i&& ( cursor== AUS))
	       break;
	 }
	 setwritemode( COPY_PUT);
      }while( !ret);
      if(( ret= strcmp( buffer, input))!= 0)
	 strcpy( buffer, input);
      free( input);
      if( ret!= 0)
	 ret= 1;
   }
   return( ret);              /* -1== ERROR, 1== verndert, 0== unverndert */
}

int Anzahl_Eintraege_pro_Typ( WORD typ, ElementInfo *EInfo)
{
   /* Bytes, Tasten, Pointer, anz. Einzelelem. */

   int groesse[][ 4]= { 3, 1, 1, 1,                             /* CHECKBOX */
			5, 1, 0, 1,                               /* BUTTON */
			5, 1, 1, 1,                                /* INPUT */
			};

   EInfo->tasten= groesse[ typ& CODE_FILTER_TO_BYTE][ 1];
   EInfo->zeiger= groesse[ typ& CODE_FILTER_TO_BYTE][ 2];
   EInfo->anz_Einzelelemente= groesse[ typ& CODE_FILTER_TO_BYTE][ 3];
   if( typ& KEY)                /* Hat das Element eine Tastenkombination ? */
      EInfo->WORDS_pro_Element= groesse[ typ& CODE_FILTER_TO_BYTE][ 0]+ groesse[ typ& CODE_FILTER_TO_BYTE][ 1];
   else
      EInfo->WORDS_pro_Element= groesse[ typ& CODE_FILTER_TO_BYTE][ 0];
   return( EInfo->WORDS_pro_Element);
}

int Is_Mouse_at_Element( MAUSStruct *MS, int index)
{
   switch( MS->mauspos[ index]& CODE_FILTER)
   {
      case BUTTON:
	 return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 2]+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 3]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 4]+ *MS->y)));
      case CHECKBOX:
	 return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ CHECKBOX_X_LAENGE+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ CHECKBOX_Y_LAENGE+ *MS->y)));
      case INPUT:
	 return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y)));
   }
   return( 0);
}

void KlickCheckBox( int Xlo, int Ylo)
{
   char color;

   color= getcolor();
   setcolor( EGA_BLACK);
   ShowMouse( AUS);
   line( Xlo, Ylo, Xlo+ 12, Ylo);
   line( Xlo+ 12, Ylo, Xlo+ 12, Ylo+ 12);
   line( Xlo+ 12, Ylo+ 12, Xlo, Ylo+ 12);
   line( Xlo, Ylo+ 12, Xlo, Ylo);
   line( Xlo+ 1, Ylo+ 1, Xlo+ 11, Ylo+ 1);
   line( Xlo+ 11, Ylo+ 1, Xlo+ 11, Ylo+ 11);
   line( Xlo+ 11, Ylo+ 11, Xlo+ 1, Ylo+ 11);
   line( Xlo+ 1, Ylo+ 11, Xlo+ 1, Ylo+ 1);
   ShowMouse( AN);
   setcolor( color);
   While_Klick();
}

void InitElemente( MAUSStruct *MS, int index, int ptr_index)
{
   switch( MS->mauspos[ index]& CODE_FILTER)
   {
      case CHECKBOX:
	 ShowMouse( AUS);
	 CheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, *( char *)MS->arg_ptr[ ptr_index]);
	 ShowMouse( AN);
	 break;
      case INPUT:
	 ShowMouse( AUS);
	 InitInputLine( MS, index, ptr_index);
	 ShowMouse( AN);
	 break;
   }
}

#pragma warn -par /* WARNUNG: 'Parameter 'parameter' is never used' unterdrcken */

int MakeKlick( MAUSStruct *MS, int index, int ptr_index, int status)
{
   ElementInfo EInfo;
   int ret_val= 0;

   switch( MS->mauspos[ index]& CODE_FILTER)
   {
      case CHECKBOX:
	 KlickCheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y);
	 ( *( char *)MS->arg_ptr[ ptr_index]== AN) ? ( *( char *)MS->arg_ptr[ ptr_index]= AUS) : ( *( char *)MS->arg_ptr[ ptr_index]= AN);
	 ShowMouse( AUS);
	 CheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, *( char *)MS->arg_ptr[ ptr_index]);
	 ShowMouse( AN);
	 break;
      case BUTTON:
	 if( !KlickButton( MS->mauspos[ index+ 1]+ *MS->x+ 1, MS->mauspos[ index+ 3]+ *MS->y+ 1, MS->mauspos[ index+ 2]+ *MS->x- 1, MS->mauspos[ index+ 4]+ *MS->y- 1))
	    ret_val= 1;
	 break;
      case INPUT:
	 if( !_Input( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 4]))
	    ret_val= 1;
	 break;
   }
   return( ret_val);
}

#pragma warn +par /* WARNUNG: 'Parameter 'parameter' is never used' erlauben */

void ButtonRahmen( int Xl, int Yo, int Xr, int Yu, char an_aus)
{
   char color;

   color= getcolor();
   if( an_aus== AN)
   {
      setcolor( EGA_BLACK);
      rectangle( Xl, Yo, Xr, Yu);
   }
   else
   {
      setcolor( EGA_WHITE);
      line( Xl, Yu, Xr, Yu);
      line( Xr, Yu, Xr, Yo);
      setcolor( EGA_DARKGRAY);
      line( Xl, Yo, Xl, Yu);
      line( Xl, Yo, Xr, Yo);
   }
   setcolor( color);
}

void CheckBoxRahmen( int Xlo, int Ylo, char an_aus)
{
   char color;

   color= getcolor();
   if( an_aus== AN)
      setcolor( EGA_BLACK);
   else
      setcolor( EGA_LIGHTGRAY);
   rectangle( Xlo- 1, Ylo- 1, Xlo+ 13, Ylo+ 13);
   setcolor( color);
}

void InputRahmen( int x, int y, int laenge, char *input, char an_aus)
{
   int maxanzeige, length, l;
   char color;

   color= getcolor();
   maxanzeige= (( laenge- ( INPUTZEILENTASTENBREITE<< 1))>> 3)- 1;
   WhiteClearN( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, maxanzeige);
   OutTextN( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, input, maxanzeige);
   if( an_aus== AN)
   {
      (( l= strlen( input))> maxanzeige) ? ( length= maxanzeige) : ( length= l);
      InputReverse( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, length);
   }
   setcolor( color);
}

int ElementeRahmen( MAUSStruct *MS, char modus, char direction)
{
   ElementInfo EInfo;
   int old_framesp;
   char an_aus, ret_val= 1, endlos= 2, tmp_flag= 0;

   (( MS->statsp== INIT)|| ( direction== ANZEIGE)) ? ( an_aus= AN) : ( an_aus= AUS);
   ShowMouse( AUS);
   for( ; an_aus<= AN; an_aus++)
   {
      if( an_aus== AN)
      {
	 if( MS->statzeile== AN)
	 {
	    if( MS->mauspos[ MS->framesp]& MSG)
	       PrintStatus( MS->msg[ MS->frame_msg_sp& AFTER_INIT_FILTER]);
	    else
	       ClearStatus();
	 }
      }
      switch( MS->mauspos[ MS->framesp]& CODE_FILTER)
      {
	 case BUTTON:
	    ButtonRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 3]+ *MS->y, MS->mauspos[ MS->framesp+ 2]+ *MS->x, MS->mauspos[ MS->framesp+ 4]+ *MS->y, an_aus);
	    break;
	 case CHECKBOX:
	    CheckBoxRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, an_aus);
	    break;
	 case INPUT:
	    if( modus== ONLY_FRAME)
	    {
	       InputRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3], ( char *)MS->arg_ptr[ MS->frame_ptr_sp], an_aus);
	    }
	    else
	    {
	       if( an_aus== AN)
	       {
		  ShowMouse( AN);
		  if( _Input( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3], ( char *)MS->arg_ptr[ MS->frame_ptr_sp], MS->mauspos[ MS->framesp+ 4])== 1)  /* String wurde verndert */
		     ret_val= 0;
		  ShowMouse( AUS);
	       }
	    }
	    break;
      }
      if( an_aus== AUS)
      {
	 if( direction== FORWARD)
	 {
	    Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
	    if( MS->frame_pos_at_element< EInfo.anz_Einzelelemente)
	    {
	       MS->frame_pos_at_element++;
	       tmp_flag= 1;
	    }
	 }
	 else
	 {
	    if( MS->frame_pos_at_element> 1)
	    {
	       MS->frame_pos_at_element--;
	       tmp_flag= 1;
	    }
	 }
	 if( !tmp_flag)
	 {
	    do
	    {
	       old_framesp= MS->framesp;
	       if( direction== FORWARD)
	       {
		  MS->framesp+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
		  MS->frame_pos_at_element= 1;
		  MS->frame_ret++;
		  if( MS->frame_ret>= MS->spotanz)
		  {
		     MS->frame_ret= 0;
		     MS->frame_ptr_sp= 0;
		     MS->framesp= 0;
		     MS->frame_msg_sp= 0;
		     endlos--;          /* verhindert Endlosschleife bei nichtvorhandensein von FRAME */
		  }
		  else
		  {
		     MS->frame_ptr_sp+= EInfo.zeiger;
		     if(( MS->mauspos[ MS->framesp]& MSG)&& ( MS->mauspos[ old_framesp]& MSG))
		     {
			MS->frame_msg_sp&= AFTER_INIT_FILTER;
			MS->frame_msg_sp++;
		     }
		  }
	       }
	       else
	       {
		  while(( MS->framesp> 0)&& !( MS->mauspos[ --MS->framesp]& ELEMENTTYPBEZEICHNER_FILTER))
		     ;
		  Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
		  MS->frame_pos_at_element= EInfo.anz_Einzelelemente;
		  MS->frame_ret--;
		  if( MS->frame_ret< 0)
		  {
		     MS->frame_ret= MS->spotanz- 1;
		     MS->frame_ptr_sp= MS->Last_arg_ptr;
		     MS->framesp= MS->Last_mauspos;
		     MS->frame_msg_sp= MS->Last_msg;
		     endlos--;          /* verhindert Endlosschleife bei nichtvorhandensein von FRAME */
		  }
		  else
		  {
		     MS->frame_ptr_sp-= EInfo.zeiger;
		     if(( MS->mauspos[ MS->framesp]& MSG)&& (( MS->mauspos[ old_framesp]& MSG)|| ( MS->frame_msg_sp& AFTER_INIT)))
		     {
			MS->frame_msg_sp&= AFTER_INIT_FILTER;
			MS->frame_msg_sp--;
		     }
		  }
	       }
	    }while( !( MS->mauspos[ MS->framesp]& FRAME)&& endlos);
	 }
      }
   }
   ShowMouse( AN);
   return( ret_val);        /* 0-> MS->frame_ret von __CheckMousepos zurck */
}

int Taste_Umformen( int Taste, WORD Sondertaste)
{
   switch( Sondertaste& 0x000F)
   {
      case ALT_PRESS:
	 return( Taste- ALT);
      case STRG_PRESS:
	 return( Taste- STRG);
   }
   return( Taste);
}

int __CheckMousepos( MAUSStruct *MS)
{
   ElementInfo EInfo;
   saveall screen_move;
   int i, l, array_index, Sondertaste= NOTHING, taste, tastvergl,
       xabst, yabst, x, y, mx, my, status= -1, ptr_index, klickstatus;
   char color;

   if(( MS->statsp== INIT)|| ( MS->statsp== REINIT))   /* Elemente initialisieren */
   {
      if( MS->statsp== INIT)
      {
	 MS->framesp= 0;
	 MS->frame_ptr_sp= 0;
	 MS->frame_ret= 0;
	 MS->frame_pos_at_element= 1;
	 MS->frame_msg_sp= 0;
	 MS->anz_intern_Tasten= 0;
	 MS->dup_flag= 0x0000;
	 MS->duplicate= 0x0000;
	 ClearStatus();
      }
      for( i= 0, l= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
      {
	 InitElemente( MS, array_index, ptr_index);
	 if(( MS->mauspos[ array_index]& DEFBUTTON)&& ( MS->statsp== INIT))
	 {
	    MS->framesp= array_index;
	    MS->frame_ptr_sp= ptr_index;
	    MS->frame_ret= i;
	    MS->frame_msg_sp= l| AFTER_INIT;
	 }
	 if( MS->mauspos[ array_index]& MSG)
	    l++;
	 array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
      }
      if( MS->statsp== INIT)
      {
	 MS->Last_mauspos= array_index- EInfo.WORDS_pro_Element;
	 MS->Last_arg_ptr= ptr_index- EInfo.zeiger;
	 MS->Last_msg= l- 1;
	 if( !ElementeRahmen( MS, WORK, FORWARD))
	    status= MS->frame_ret;
      }
      else
	 if( MS->statsp== REINIT)
	    ElementeRahmen( MS, ONLY_FRAME, ANZEIGE);
      MS->statsp= -1;
      return( status);
   }
   MouseStat();                                      /* MausStatus erfragen */
   if( MS->statzeile== AN)                       /* Statuszeile erwnscht ? */
   {
      for( i= 0, l= 0, array_index= 0; i< MS->spotanz; i++)
      {
	 if( MS->mauspos[ array_index]& MSG)
	 {
	    if( Is_Mouse_at_Element( MS, array_index))
	    {
	       if( MS->statsp!= l)  /* steht Meldung nicht in Statuszeile ? */
		  PrintStatus( MS->msg[ MS->statsp= l]);
	       l= -1;
	       break;
	    }
	    l++;
	 }
	 array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], NULL);
      }
      if(( l!= -1)&& ( MS->statsp!= -1))
      {
	 ClearStatus();
	 MS->statsp= -1;
      }
   }
   if( kbhit())                                /* Taste im Tastaturpuffer ? */
   {
      if( !( taste= getch()))                         /* erweiterter Code ? */
      {
	 Sondertaste= bioskey( 2);
	 switch( taste= getch())                /* erweiterter Tastaturcode */
	 {
	    case SHIFT_TAB:
	       msg_to_Klick= AUS;
	       if( !ElementeRahmen( MS, WORK, BACKWARD))
		  status= MS->frame_ret;
	       return( status);
	 }
      }
      else
      {
	 switch( taste)
	 {
	    case TAB:
	       msg_to_Klick= AUS;
	       if( !ElementeRahmen( MS, WORK, FORWARD))
		  status= MS->frame_ret;
	       return( status);
	    case STRG_RETURN:
	       msg_to_Klick= AUS;
	       if( !MakeKlick( MS, MS->framesp, MS->frame_ptr_sp, MS->frame_pos_at_element))
		  return( MS->frame_ret);
	       return( -1);
	 }
      }
      for( i= 0; i< MS->anz_intern_Tasten; i++)
      {
	 if( taste== Taste_Umformen( MS->intern_Tasten[ i][ TASTENKOMBINATION], Sondertaste))
	 {
	    MakeKlick( MS, MS->intern_Tasten[ i][ MAUSPOSINDEX], MS->intern_Tasten[ i][ ARGPOINTERINDEX], MS->intern_Tasten[ i][ POS_AT_ELEMENT]);
	    msg_to_Klick= AUS;
	    return( -1);
	 }
      }
      for( i= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, array_index+= EInfo.WORDS_pro_Element, ptr_index+= EInfo.zeiger)
      {
	 Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	 if( MS->mauspos[ array_index]& KEY) /* Tastenkombination vorhanden */
	 {
	    for( l= EInfo.tasten; l> 0; l--)/* wieviel Tasten hat Element ? */
	    {
	       if( taste== Taste_Umformen( MS->mauspos[ array_index+ EInfo.WORDS_pro_Element- l], Sondertaste))
	       {
		  if( !MakeKlick( MS, array_index, ptr_index, EInfo.tasten- l+ 1))
		     status= i;
		  break;
	       }
	    }
	 }
      }
   }
   else
   {
      if( MStat.buttons!= NOTHING)
      {
	 for( i= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
	 {
	    if(( klickstatus= Is_Mouse_at_Element( MS, array_index))!= 0)
	    {
	       if( !MakeKlick( MS, array_index, ptr_index, klickstatus))
		  status= i;
	       break;
	    }
	    array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	 }
      }
   }
   if( status!= -1)
      msg_to_Klick= AUS;
   return( status);
}
