# This defines and checks the environment, in which an application is
# about to be make'ed.
# And source in the version information and the last make's information.
#	The version is stored within VERSION.MK and consists of two macros:
#		VERSION_MAJOR is the major number
#		VERSION_MINOR is the minor number
#		Both forming the version info: $(VERSION_MAJOR).$(VERSION_MINOR)
#	The last make's information is stored within $(LNG).MK and has 3 macros:
#		LASTMAKE_MODEL is the memory model the previous Make run under
#		LASTMAKE_COMPILER is the compiler the prvious Make run under
#		LASTMAKE_NDEBUG is set, if NDEBUG was set previously
#	and LASTMAKE.MK, where a single macro is stored:
#		LASTMAKE_LNG contains the previously used language

# Suggested directory structure:
# \FREEDOS		all executables for the OS itself
# \FREEDOS\SRC	entry point of the sources
# \FREEDOS\SRC\BIN	executables necessary for make'ing the sources
# \FREEDOS\SRC\BIN\SRC	one-file sources of the BIN directory
# \FREEDOS\SRC\BIN\*		multi-file sources of the BIN directory
# \FREEDOS\SRC\LIB\$(_COMPILER)	pre-built libraries or place, where to store make'ed LIBs to
# 			The message library is named: $(LNG).{lib,msg}
# \FREEDOS\SRC\LIB\*	sources of the LIB directory
# \FREEDOS\SRC\INCLUDE	Free-Dos include files
# ^^^^^^^^ root of the Free-Dos sources

# Environment variables:

# FREEDOS: The fully-qualified directory of the root
# LNG: currently used language. 
# COMPILER: currently used compiler

# NDEBUG: if set, the debug information is omitted
# MODEL: The memory model. If omitted, 's' is assumed. (Micro-C
#        is always referenced by 'mc'.)
#        Macro _MODEL is "s", if unset, or $(MODEL:l), otherwise.

# MCDIR: Micro-C's directory. If omitted, "c:\mc" is assumed.

#
# Macros
#
# FDSRC: directory %FREEDOS%\SRC
# FDBIN: directory $(FDSRC)\BIN\
# FDLIB: directory $(FDSRC)\LIB\$(_COMPILER)
# FDINC: directory $(FDSRC)\INCLUDE\
# CC: name & initialization of the compiler
# LD: name & initialization of the linker
# AS: name & initialization of the assembler
# INSTALL: name & initialization of the install utility
# RM: multi-argument & multi-line delete without prompting
# CFG: compiler configuration file
# INSTCFG: global configuration flags for the install utility
#
# MSGLIB: name of the local message library (Std.: $(LNG).lib)
# MSGDCL: name of the local message description file (Std.: msg.h)
#
# Y: helps to break shell recipe groups, when in the middle of a script
#    a program returns an error state

# language supplied?
.IF $(LNG) == $(NULL)
.IMPORT : LNG
.ENDIF
# Free-Dos root directory supplied?
.IF $(FREEDOS) == $(NULL)
.IMPORT : FREEDOS
.ENDIF
FREEDOS !:= $(FREEDOS:u)	# Because of a side effect of dmake must be upper-cased
FDSRC = $(FREEDOS)\SRC
FDBIN = $(FDSRC)\BIN
FDLIB = $(FDSRC)\LIB\$(_COMPILER)
FDINC = $(FDSRC)\INCLUDE
RM !:= $(FDBIN)\RM.COM

#
# With the settings of .GROUP* and Y it's possible to write
# target .GROUP .PROLOG .EPILOG :
#		line1
#		$Y
#		line2
#		$Y
#		line3
# and whenever a line returns an error state, the shell script is
# terminated.
#
.PROLOG .EPILOG :		# always insert group prolog and epilog
Y !:= if errorlevel 1 goto ende		# goto script ende if error
.GROUPEPILOG :			# label @ the end of the shell script
	:ende
	exit
.GROUPPROLOG :			# turn off statement echo'ing inside the shell
[
@echo off
]

.IF $(INCDIR)
# source in $(FDINC)
INCDIR !:= $(FDINC);$(INCDIR)
.ENDIF
.IF $(LIBDIR)
# source in $(FDLIB)
LIBDIR !:= $(FDLIB);$(LIBDIR)
.ENDIF


MSGLIB *= $(LNG:l).lib
MSGDCL *= msg.h
MSGINFO *= msgfeat.inc msgdecl.inc
MSGLIBINC *= $(LNG:l).dcl $(LNG:l).ftr

.IF $(NDEBUG) == $(NULL)
.IMPORT .IGNORE : NDEBUG
.ENDIF

.INCLUDE .IGNORE : $(LNG).mk version.mk lastmake.mk
# Make sure that there is a version
VERSION_MINOR *= 0
VERSION_MAJOR *= 0
VERSION = $(VERSION_MAJOR).$(VERSION_MINOR)

# Preprocess the last make's information a bit
LASTMAKE !:= $(LASTMAKE_MODEL):$(LASTMAKE_COMPILER):$(LASTMAKE_NDEBUG)
THISMAKE != $(_MODEL):$(_COMPILER):$(null,$(NDEBUG) $(NULL) Y)
